/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.CallSiteBinder;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.relation.Predicate;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.project.PageFieldsToInputParametersRewriter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.PredicateCompiler;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.util.CompilerUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.inject.Inject;

public class RowExpressionPredicateCompiler
implements PredicateCompiler {
    private final Metadata metadata;
    private final LoadingCache<CacheKey, Supplier<Predicate>> predicateCache;

    @Inject
    public RowExpressionPredicateCompiler(Metadata metadata) {
        this(Objects.requireNonNull(metadata, "metadata is null"), 10000);
    }

    public RowExpressionPredicateCompiler(Metadata metadata, int predicateCacheSize) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.predicateCache = predicateCacheSize > 0 ? CacheBuilder.newBuilder().recordStats().maximumSize((long)predicateCacheSize).build(CacheLoader.from(cacheKey -> this.compilePredicateInternal(((CacheKey)cacheKey).sqlFunctionProperties, ((CacheKey)cacheKey).sessionFunctions, ((CacheKey)cacheKey).rowExpression))) : null;
    }

    public Supplier<Predicate> compilePredicate(SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, RowExpression predicate) {
        if (this.predicateCache == null) {
            return this.compilePredicateInternal(sqlFunctionProperties, sessionFunctions, predicate);
        }
        return (Supplier)this.predicateCache.getUnchecked((Object)new CacheKey(sqlFunctionProperties, sessionFunctions, predicate));
    }

    private Supplier<Predicate> compilePredicateInternal(SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, RowExpression predicate) {
        Class<Predicate> predicateClass;
        Objects.requireNonNull(predicate, "predicate is null");
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters(predicate);
        int[] inputChannels = result.getInputChannels().getInputChannels().stream().mapToInt(Integer::intValue).toArray();
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = this.definePredicateClass(sqlFunctionProperties, sessionFunctions, result.getRewrittenExpression(), inputChannels, callSiteBinder);
        try {
            predicateClass = CompilerUtils.defineClass(classDefinition, Predicate.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, predicate.toString(), e.getCause());
        }
        return () -> {
            try {
                return (Predicate)predicateClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, (Throwable)e);
            }
        };
    }

    private ClassDefinition definePredicateClass(SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, RowExpression predicate, int[] inputChannels, CallSiteBinder callSiteBinder) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(Predicate.class.getSimpleName(), Optional.empty()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(Predicate.class)});
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        this.generatePredicateMethod(sqlFunctionProperties, sessionFunctions, classDefinition, callSiteBinder, cachedInstanceBinder, predicate);
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getInputChannels", ParameterizedType.type(int[].class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind((Object)inputChannels, int[].class), "getInputChannels")).retObject();
        RowExpressionPredicateCompiler.generateConstructor(classDefinition, cachedInstanceBinder);
        return classDefinition;
    }

    private MethodDefinition generatePredicateMethod(SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression predicate) {
        AtomicInteger lambdaCounter = new AtomicInteger(0);
        Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap = LambdaBytecodeGenerator.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, predicate, this.metadata, sqlFunctionProperties, sessionFunctions, lambdaCounter);
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluate", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.builder().add((Object)properties).add((Object)page).add((Object)position).build());
        method.comment("Predicate: %s", new Object[]{predicate.toString()});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        RowExpressionPredicateCompiler.declareBlockVariables(predicate, page, scope, body);
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        RowExpressionCompiler compiler = new RowExpressionCompiler(classDefinition, callSiteBinder, cachedInstanceBinder, RowExpressionPredicateCompiler.fieldReferenceCompiler(callSiteBinder), this.metadata, sqlFunctionProperties, sessionFunctions, compiledLambdaMap, lambdaCounter);
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        body.append(compiler.compile(predicate, scope, Optional.empty())).putVariable(result).append((BytecodeNode)BytecodeExpressions.and((BytecodeExpression)BytecodeExpressions.not((BytecodeExpression)wasNullVariable), (BytecodeExpression)result).ret());
        return method;
    }

    private static void declareBlockVariables(RowExpression expression, Parameter page, Scope scope, BytecodeBlock body) {
        for (int channel : RowExpressionPredicateCompiler.getInputChannels(expression)) {
            scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)channel)}));
        }
    }

    private static List<Integer> getInputChannels(Iterable<RowExpression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (RowExpression expression : Expressions.subExpressions(expressions)) {
            if (!(expression instanceof InputReferenceExpression)) continue;
            channels.add(((InputReferenceExpression)expression).getField());
        }
        return ImmutableList.copyOf(channels);
    }

    private static List<Integer> getInputChannels(RowExpression expression) {
        return RowExpressionPredicateCompiler.getInputChannels((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    private static RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler(CallSiteBinder callSiteBinder) {
        return new InputReferenceCompiler((scope, field) -> scope.getVariable("block_" + field), (scope, field) -> scope.getVariable("position"), callSiteBinder);
    }

    private static void generateConstructor(ClassDefinition classDefinition, CachedInstanceBinder cachedInstanceBinder) {
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        body.ret();
    }

    private static final class CacheKey {
        private final SqlFunctionProperties sqlFunctionProperties;
        private final Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions;
        private final RowExpression rowExpression;

        private CacheKey(SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, RowExpression rowExpression) {
            this.sqlFunctionProperties = Objects.requireNonNull(sqlFunctionProperties, "sqlFunctionProperties is null");
            this.sessionFunctions = Objects.requireNonNull(sessionFunctions, "sessionFunctions is null");
            this.rowExpression = Objects.requireNonNull(rowExpression, "rowExpression is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return Objects.equals(this.sqlFunctionProperties, that.sqlFunctionProperties) && Objects.equals(this.rowExpression, that.rowExpression);
        }

        public int hashCode() {
            return Objects.hash(this.sqlFunctionProperties, this.rowExpression);
        }
    }
}

