/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.CallSiteBinder;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.aggregation.LambdaProvider;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.LambdaCapture;
import com.facebook.presto.sql.gen.LambdaExpressionExtractor;
import com.facebook.presto.sql.gen.ParameterAndType;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Failures;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public class LambdaBytecodeGenerator {
    private LambdaBytecodeGenerator() {
    }

    public static Map<LambdaDefinitionExpression, CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression expression, Metadata metadata, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, AtomicInteger lambdaCounter) {
        return LambdaBytecodeGenerator.generateMethodsForLambda(containerClassDefinition, callSiteBinder, cachedInstanceBinder, expression, metadata, sqlFunctionProperties, sessionFunctions, "", lambdaCounter);
    }

    public static Map<LambdaDefinitionExpression, CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression expression, Metadata metadata, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, String methodNamePrefix, AtomicInteger lambdaCounter) {
        return LambdaBytecodeGenerator.generateMethodsForLambda(containerClassDefinition, callSiteBinder, cachedInstanceBinder, (List<RowExpression>)ImmutableList.of((Object)expression), metadata, sqlFunctionProperties, sessionFunctions, methodNamePrefix, lambdaCounter);
    }

    public static Map<LambdaDefinitionExpression, CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression expression, Metadata metadata, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, String methodNamePrefix, Set<LambdaDefinitionExpression> existingCompiledLambdas, AtomicInteger lambdaCounter) {
        return LambdaBytecodeGenerator.generateMethodsForLambda(containerClassDefinition, callSiteBinder, cachedInstanceBinder, (List<RowExpression>)ImmutableList.of((Object)expression), metadata, sqlFunctionProperties, sessionFunctions, methodNamePrefix, existingCompiledLambdas, lambdaCounter);
    }

    public static Map<LambdaDefinitionExpression, CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, List<RowExpression> expressions, Metadata metadata, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, String methodNamePrefix, AtomicInteger lambdaCounter) {
        return LambdaBytecodeGenerator.generateMethodsForLambda(containerClassDefinition, callSiteBinder, cachedInstanceBinder, expressions, metadata, sqlFunctionProperties, sessionFunctions, methodNamePrefix, (Set<LambdaDefinitionExpression>)ImmutableSet.of(), lambdaCounter);
    }

    private static Map<LambdaDefinitionExpression, CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, List<RowExpression> expressions, Metadata metadata, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, String methodNamePrefix, Set<LambdaDefinitionExpression> existingCompiledLambdas, AtomicInteger lambdaCounter) {
        Set lambdaExpressions = (Set)expressions.stream().map(LambdaExpressionExtractor::extractLambdaExpressions).flatMap(Collection::stream).filter(lambda -> !existingCompiledLambdas.contains(lambda)).collect(ImmutableSet.toImmutableSet());
        ImmutableMap.Builder compiledLambdaMap = ImmutableMap.builder();
        for (LambdaDefinitionExpression lambdaExpression : lambdaExpressions) {
            CompiledLambda compiledLambda = LambdaBytecodeGenerator.preGenerateLambdaExpression(lambdaExpression, methodNamePrefix + "lambda_" + lambdaCounter.getAndIncrement(), containerClassDefinition, (Map<LambdaDefinitionExpression, CompiledLambda>)compiledLambdaMap.build(), callSiteBinder, cachedInstanceBinder, metadata, sqlFunctionProperties, sessionFunctions, lambdaCounter);
            compiledLambdaMap.put((Object)lambdaExpression, (Object)compiledLambda);
        }
        return compiledLambdaMap.build();
    }

    private static CompiledLambda preGenerateLambdaExpression(LambdaDefinitionExpression lambdaExpression, String methodName, ClassDefinition classDefinition, Map<LambdaDefinitionExpression, CompiledLambda> compiledLambdaMap, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, Metadata metadata, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, AtomicInteger lambdaCounter) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        ImmutableMap.Builder parameterMapBuilder = ImmutableMap.builder();
        parameters.add((Object)Parameter.arg((String)"properties", SqlFunctionProperties.class));
        for (int i = 0; i < lambdaExpression.getArguments().size(); ++i) {
            Class type = Primitives.wrap((Class)((com.facebook.presto.common.type.Type)lambdaExpression.getArgumentTypes().get(i)).getJavaType());
            String argumentName = (String)lambdaExpression.getArguments().get(i);
            Parameter arg = Parameter.arg((String)("lambda_" + argumentName), (Class)type);
            parameters.add((Object)arg);
            parameterMapBuilder.put((Object)argumentName, (Object)new ParameterAndType(arg, type));
        }
        RowExpressionCompiler innerExpressionCompiler = new RowExpressionCompiler(classDefinition, callSiteBinder, cachedInstanceBinder, LambdaBytecodeGenerator.variableReferenceCompiler((Map<String, ParameterAndType>)parameterMapBuilder.build()), metadata, sqlFunctionProperties, sessionFunctions, compiledLambdaMap, lambdaCounter);
        return LambdaBytecodeGenerator.defineLambdaMethod(innerExpressionCompiler, classDefinition, methodName, (List<Parameter>)parameters.build(), lambdaExpression);
    }

    private static CompiledLambda defineLambdaMethod(RowExpressionCompiler innerExpressionCompiler, ClassDefinition classDefinition, String methodName, List<Parameter> inputParameters, LambdaDefinitionExpression lambda) {
        Failures.checkCondition(inputParameters.size() <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for lambda expression", new Object[0]);
        Class returnType = Primitives.wrap((Class)lambda.getBody().getType().getJavaType());
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), methodName, ParameterizedType.type((Class)returnType), inputParameters);
        Scope scope = method.getScope();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        BytecodeNode compiledBody = innerExpressionCompiler.compile(lambda.getBody(), scope, Optional.empty());
        method.getBody().putVariable(wasNull, false).append(compiledBody).append(BytecodeUtils.boxPrimitiveIfNecessary(scope, returnType)).ret(returnType);
        Handle lambdaAsmHandle = new Handle(5, method.getThis().getType().getClassName(), method.getName(), method.getMethodDescriptor(), false);
        return new CompiledLambda(lambdaAsmHandle, method.getReturnType(), method.getParameterTypes());
    }

    public static BytecodeNode generateLambda(BytecodeGeneratorContext context, List<RowExpression> captureExpressions, CompiledLambda compiledLambda, Class lambdaInterface) {
        if (!lambdaInterface.isAnnotationPresent(FunctionalInterface.class)) {
            throw new VerifyException("lambda should be generated as class annotated with FunctionalInterface");
        }
        BytecodeBlock block = new BytecodeBlock().setDescription("Partial apply");
        Scope scope = context.getScope();
        Variable wasNull = scope.getVariable("wasNull");
        ImmutableList.Builder captureVariableBuilder = ImmutableList.builder();
        for (RowExpression captureExpression : captureExpressions) {
            Class valueType = Primitives.wrap((Class)captureExpression.getType().getJavaType());
            Variable valueVariable = scope.createTempVariable(valueType);
            block.append(context.generate(captureExpression, Optional.empty()));
            block.append(BytecodeUtils.boxPrimitiveIfNecessary(scope, valueType));
            block.putVariable(valueVariable);
            block.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
            captureVariableBuilder.add((Object)valueVariable);
        }
        ImmutableList captureVariables = ImmutableList.builder().add((Object[])new BytecodeExpression[]{scope.getThis(), scope.getVariable("properties")}).addAll((Iterable)captureVariableBuilder.build()).build();
        Type instantiatedMethodAsmType = Type.getMethodType((Type)compiledLambda.getReturnType().getAsmType(), (Type[])((Type[])((ImmutableList)compiledLambda.getParameterTypes().stream().skip(captureExpressions.size() + 1).map(ParameterizedType::getAsmType).collect(ImmutableList.toImmutableList())).toArray((Object[])new Type[0])));
        block.append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)LambdaCapture.LAMBDA_CAPTURE_METHOD, (Iterable)ImmutableList.of((Object)Type.getType((Method)LambdaBytecodeGenerator.getSingleApplyMethod(lambdaInterface)), (Object)compiledLambda.getLambdaAsmHandle(), (Object)instantiatedMethodAsmType), (String)"apply", (ParameterizedType)ParameterizedType.type((Class)lambdaInterface), (Iterable)captureVariables));
        return block;
    }

    public static Class<? extends LambdaProvider> compileLambdaProvider(LambdaDefinitionExpression lambdaExpression, Metadata metadata, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, Class lambdaInterface) {
        ClassDefinition lambdaProviderClassDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("LambdaProvider"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(LambdaProvider.class)});
        FieldDefinition propertiesField = lambdaProviderClassDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "properties", SqlFunctionProperties.class);
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(lambdaProviderClassDefinition, callSiteBinder);
        AtomicInteger lambdaCounter = new AtomicInteger(0);
        Map<LambdaDefinitionExpression, CompiledLambda> compiledLambdaMap = LambdaBytecodeGenerator.generateMethodsForLambda(lambdaProviderClassDefinition, callSiteBinder, cachedInstanceBinder, (RowExpression)lambdaExpression, metadata, sqlFunctionProperties, sessionFunctions, lambdaCounter);
        MethodDefinition method = lambdaProviderClassDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getLambda", ParameterizedType.type(Object.class), (Iterable)ImmutableList.of());
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        scope.declareVariable("properties", body, method.getThis().getField(propertiesField));
        RowExpressionCompiler rowExpressionCompiler = new RowExpressionCompiler(lambdaProviderClassDefinition, callSiteBinder, cachedInstanceBinder, LambdaBytecodeGenerator.variableReferenceCompiler((Map<String, ParameterAndType>)ImmutableMap.of()), metadata, sqlFunctionProperties, sessionFunctions, compiledLambdaMap, lambdaCounter);
        BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(rowExpressionCompiler, scope, callSiteBinder, cachedInstanceBinder, metadata.getFunctionAndTypeManager());
        body.append(LambdaBytecodeGenerator.generateLambda(generatorContext, (List<RowExpression>)ImmutableList.of(), compiledLambdaMap.get(lambdaExpression), lambdaInterface)).retObject();
        Parameter propertiesParameter = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        MethodDefinition constructorDefinition = lambdaProviderClassDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{propertiesParameter});
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable constructorThisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)constructorThisVariable).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)constructorThisVariable.setField(propertiesField, (BytecodeExpression)propertiesParameter));
        cachedInstanceBinder.generateInitializations(constructorThisVariable, constructorBody);
        constructorBody.ret();
        return CompilerUtils.defineClass(lambdaProviderClassDefinition, LambdaProvider.class, callSiteBinder.getBindings(), AccumulatorCompiler.class.getClassLoader());
    }

    private static Method getSingleApplyMethod(Class lambdaFunctionInterface) {
        Failures.checkCondition(lambdaFunctionInterface.isAnnotationPresent(FunctionalInterface.class), (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Lambda function interface is required to be annotated with FunctionalInterface", new Object[0]);
        List applyMethods = (List)Arrays.stream(lambdaFunctionInterface.getMethods()).filter(method -> method.getName().equals("apply")).collect(ImmutableList.toImmutableList());
        Failures.checkCondition(applyMethods.size() == 1, (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Expect to have exactly 1 method with name 'apply' in interface " + lambdaFunctionInterface.getName(), new Object[0]);
        return (Method)applyMethods.get(0);
    }

    private static RowExpressionVisitor<BytecodeNode, Scope> variableReferenceCompiler(final Map<String, ParameterAndType> parameterMap) {
        return new RowExpressionVisitor<BytecodeNode, Scope>(){

            public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                throw new UnsupportedOperationException();
            }

            public BytecodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException();
            }

            public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException();
            }

            public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
                throw new UnsupportedOperationException();
            }

            public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
                ParameterAndType parameterAndType = (ParameterAndType)parameterMap.get(reference.getName());
                Parameter parameter = parameterAndType.getParameter();
                Class<?> type = parameterAndType.getType();
                return new BytecodeBlock().append((BytecodeNode)parameter).append((BytecodeNode)BytecodeUtils.unboxPrimitiveIfNecessary(context, type));
            }

            public BytecodeNode visitSpecialForm(SpecialFormExpression specialForm, Scope context) {
                throw new UnsupportedOperationException();
            }
        };
    }

    static class CompiledLambda {
        private final Handle lambdaAsmHandle;
        private final ParameterizedType returnType;
        private final List<ParameterizedType> parameterTypes;

        public CompiledLambda(Handle lambdaAsmHandle, ParameterizedType returnType, List<ParameterizedType> parameterTypes) {
            this.lambdaAsmHandle = Objects.requireNonNull(lambdaAsmHandle, "lambdaMethodAsmHandle is null");
            this.returnType = Objects.requireNonNull(returnType, "returnType is null");
            this.parameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameterTypes, "returnType is null"));
        }

        public Handle getLambdaAsmHandle() {
            return this.lambdaAsmHandle;
        }

        public ParameterizedType getReturnType() {
            return this.returnType;
        }

        public List<ParameterizedType> getParameterTypes() {
            return this.parameterTypes;
        }
    }
}

