/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.MetadataExtractor;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.analyzer.UtilizedColumnsAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.AnalyzerUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class Analyzer {
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final Session session;
    private final Optional<QueryExplainer> queryExplainer;
    private final List<Expression> parameters;
    private final Map<NodeRef<Parameter>, Expression> parameterLookup;
    private final WarningCollector warningCollector;
    private final MetadataExtractor metadataExtractor;

    public Analyzer(Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Optional<QueryExplainer> queryExplainer, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector) {
        this(session, metadata, sqlParser, accessControl, queryExplainer, parameters, parameterLookup, warningCollector, Optional.empty());
    }

    public Analyzer(Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Optional<QueryExplainer> queryExplainer, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector, Optional<ExecutorService> metadataExtractorExecutor) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "query explainer is null");
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.parameterLookup = Objects.requireNonNull(parameterLookup, "parameterLookup is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        Objects.requireNonNull(metadataExtractorExecutor, "metadataExtractorExecutor is null");
        this.metadataExtractor = new MetadataExtractor(session, metadata, metadataExtractorExecutor, sqlParser, warningCollector);
    }

    public Analysis analyze(Statement statement) {
        return this.analyze(statement, false);
    }

    public Analysis analyze(Statement statement, boolean isDescribe) {
        Analysis analysis = this.analyzeSemantic(statement, isDescribe);
        AnalyzerUtil.checkAccessPermissions(analysis.getAccessControlReferences());
        return analysis;
    }

    public Analysis analyzeSemantic(Statement statement, boolean isDescribe) {
        Statement rewrittenStatement = StatementRewrite.rewrite(this.session, this.metadata, this.sqlParser, this.queryExplainer, statement, this.parameters, this.parameterLookup, this.accessControl, this.warningCollector);
        Analysis analysis = new Analysis(rewrittenStatement, this.parameterLookup, isDescribe);
        this.metadataExtractor.populateMetadataHandle(this.session, rewrittenStatement, analysis.getMetadataHandle());
        StatementAnalyzer analyzer = new StatementAnalyzer(analysis, this.metadata, this.sqlParser, this.accessControl, this.session, this.warningCollector);
        analyzer.analyze((Node)rewrittenStatement, Optional.empty());
        UtilizedColumnsAnalyzer.analyzeForUtilizedColumns(analysis, (Node)analysis.getStatement());
        analysis.populateTableColumnAndSubfieldReferencesForAccessControl(SystemSessionProperties.isCheckAccessControlOnUtilizedColumnsOnly(this.session), SystemSessionProperties.isCheckAccessControlWithSubfields(this.session));
        return analysis;
    }

    static void verifyNoAggregateWindowOrGroupingFunctions(Map<NodeRef<FunctionCall>, FunctionHandle> functionHandles, FunctionAndTypeResolver functionAndTypeResolver, Expression predicate, String clause) {
        List<GroupingOperation> groupingOperations;
        List<FunctionCall> windowExpressions;
        List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions(functionHandles, (Iterable<? extends Node>)ImmutableList.of((Object)predicate), functionAndTypeResolver);
        ImmutableList found = ImmutableList.copyOf((Iterable)Iterables.concat(aggregates, windowExpressions = ExpressionTreeUtils.extractWindowFunctions((Iterable<? extends Node>)ImmutableList.of((Object)predicate)), groupingOperations = ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)predicate), GroupingOperation.class)));
        if (!found.isEmpty()) {
            throw new SemanticException(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_WINDOWS_OR_GROUPING, (Node)predicate, "%s cannot contain aggregations, window functions or grouping operations: %s", new Object[]{clause, found});
        }
    }

    static void verifyNoExternalFunctions(Map<NodeRef<FunctionCall>, FunctionHandle> functionHandles, FunctionAndTypeResolver functionAndTypeResolver, Expression predicate, String clause) {
        List<FunctionCall> externalFunctions = ExpressionTreeUtils.extractExternalFunctions(functionHandles, (Iterable<? extends Node>)ImmutableList.of((Object)predicate), functionAndTypeResolver);
        if (!externalFunctions.isEmpty()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)predicate, "External functions in %s is not supported: %s", new Object[]{clause, externalFunctions});
        }
    }
}

