/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.session.ResourceEstimates;
import com.facebook.presto.spi.tracing.Tracer;
import com.google.common.collect.ImmutableList;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public interface SessionContext {
    public Identity getIdentity();

    default public List<X509Certificate> getCertificates() {
        return ImmutableList.of();
    }

    @Nullable
    public String getCatalog();

    @Nullable
    public String getSchema();

    @Nullable
    public String getSource();

    public String getRemoteUserAddress();

    @Nullable
    public String getUserAgent();

    @Nullable
    public String getClientInfo();

    public Set<String> getClientTags();

    public ResourceEstimates getResourceEstimates();

    @Nullable
    public String getTimeZoneId();

    @Nullable
    public String getLanguage();

    public Optional<Tracer> getTracer();

    public Map<String, String> getSystemProperties();

    public Map<String, Map<String, String>> getCatalogSessionProperties();

    public Map<String, String> getPreparedStatements();

    public Optional<TransactionId> getTransactionId();

    public Optional<String> getTraceToken();

    public boolean supportClientTransaction();

    public Map<SqlFunctionId, SqlInvokedFunction> getSessionFunctions();
}

