/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.common.WarningHandlingLevel;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.execution.warnings.WarningCollectorFactory;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.SessionSupplier;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AuthorizedIdentity;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.SqlEnvironmentConfig;
import com.facebook.presto.transaction.TransactionManager;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class QuerySessionSupplier
implements SessionSupplier {
    private final Logger log = Logger.get(QuerySessionSupplier.class);
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;
    private final Optional<TimeZoneKey> forcedSessionTimeZone;

    @Inject
    public QuerySessionSupplier(TransactionManager transactionManager, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, SqlEnvironmentConfig config) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        Objects.requireNonNull(config, "config is null");
        this.forcedSessionTimeZone = Objects.requireNonNull(config.getForcedSessionTimeZone(), "forcedSessionTimeZone is null");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session createSession(QueryId queryId, SessionContext context, WarningCollectorFactory warningCollectorFactory, Optional<AuthorizedIdentity> authorizedIdentity) {
        void var8_17;
        Identity identity = context.getIdentity();
        if (authorizedIdentity.isPresent()) {
            identity = new Identity(identity.getUser(), identity.getPrincipal(), identity.getRoles(), identity.getExtraCredentials(), identity.getExtraAuthenticators(), Optional.of(authorizedIdentity.get().getUserName()), authorizedIdentity.get().getReasonForSelect());
            this.log.info(String.format("For query %s, given user is %s, authorized user is %s", queryId.getId(), identity.getUser(), authorizedIdentity.get().getUserName()));
        }
        Session.SessionBuilder sessionBuilder = Session.builder(this.sessionPropertyManager).setQueryId(queryId).setIdentity(identity).setSource(context.getSource()).setCatalog(context.getCatalog()).setSchema(context.getSchema()).setRemoteUserAddress(context.getRemoteUserAddress()).setUserAgent(context.getUserAgent()).setClientInfo(context.getClientInfo()).setClientTags(context.getClientTags()).setTraceToken(context.getTraceToken()).setResourceEstimates(context.getResourceEstimates()).setTracer(context.getTracer());
        if (this.forcedSessionTimeZone.isPresent()) {
            sessionBuilder.setTimeZoneKey(this.forcedSessionTimeZone.get());
        } else if (context.getTimeZoneId() != null) {
            sessionBuilder.setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)context.getTimeZoneId()));
        }
        if (context.getLanguage() != null) {
            sessionBuilder.setLocale(Locale.forLanguageTag(context.getLanguage()));
        }
        for (Map.Entry<String, String> entry : context.getSystemProperties().entrySet()) {
            sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : context.getCatalogSessionProperties().entrySet()) {
            String catalog = entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                sessionBuilder.setCatalogSessionProperty(catalog, (String)entry2.getKey(), (String)entry2.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : context.getPreparedStatements().entrySet()) {
            sessionBuilder.addPreparedStatement(entry.getKey(), (String)entry.getValue());
        }
        if (context.supportClientTransaction()) {
            sessionBuilder.setClientTransactionSupport();
        }
        for (Map.Entry<String, Object> entry : context.getSessionFunctions().entrySet()) {
            sessionBuilder.addSessionFunction((SqlFunctionId)entry.getKey(), (SqlInvokedFunction)entry.getValue());
        }
        WarningCollector warningCollector = warningCollectorFactory.create(sessionBuilder.getSystemProperty("warning_handling", WarningHandlingLevel.class));
        sessionBuilder.setWarningCollector(warningCollector);
        Session session = sessionBuilder.build();
        if (context.getTransactionId().isPresent()) {
            Session session2 = session.beginTransactionId(context.getTransactionId().get(), this.transactionManager, this.accessControl);
        }
        return var8_17;
    }
}

