/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.server.BasicQueryStats;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;

@ThriftStruct
public class QueryProgressStats {
    private final long elapsedTimeMillis;
    private final long queuedTimeMillis;
    private final long executionTimeMillis;
    private final long cpuTimeMillis;
    private final long scheduledTimeMillis;
    private final long currentMemoryBytes;
    private final long peakMemoryBytes;
    private final long peakTotalMemoryBytes;
    private final long peakTaskTotalMemoryBytes;
    private final double cumulativeUserMemory;
    private final double cumulativeTotalMemory;
    private final long inputRows;
    private final long inputBytes;
    private final OptionalDouble progressPercentage;
    private final boolean blocked;
    private final Optional<Set<BlockedReason>> blockedReasons;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int completedDrivers;

    @JsonCreator
    @ThriftConstructor
    public QueryProgressStats(@JsonProperty(value="elapsedTimeMillis") long elapsedTimeMillis, @JsonProperty(value="queuedTimeMillis") long queuedTimeMillis, @JsonProperty(value="executionTimeMillis") long executionTimeMillis, @JsonProperty(value="cpuTimeMillis") long cpuTimeMillis, @JsonProperty(value="scheduledTimeMillis") long scheduledTimeMillis, @JsonProperty(value="currentMemoryBytes") long currentMemoryBytes, @JsonProperty(value="peakMemoryBytes") long peakMemoryBytes, @JsonProperty(value="peakTotalMemoryBytes") long peakTotalMemoryBytes, @JsonProperty(value="peakTaskTotalMemoryBytes") long peakTaskTotalMemoryBytes, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="cumulativeTotalMemory") double cumulativeTotalMemory, @JsonProperty(value="inputRows") long inputRows, @JsonProperty(value="inputBytes") long inputBytes, @JsonProperty(value="blocked") boolean blocked, @JsonProperty(value="blockedReasons") Optional<Set<BlockedReason>> blockedReasons, @JsonProperty(value="progressPercentage") OptionalDouble progressPercentage, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="completedDrivers") int completedDrivers) {
        this.elapsedTimeMillis = elapsedTimeMillis;
        this.queuedTimeMillis = queuedTimeMillis;
        this.executionTimeMillis = executionTimeMillis;
        this.cpuTimeMillis = cpuTimeMillis;
        this.scheduledTimeMillis = scheduledTimeMillis;
        this.currentMemoryBytes = currentMemoryBytes;
        this.peakMemoryBytes = peakMemoryBytes;
        this.peakTotalMemoryBytes = peakTotalMemoryBytes;
        this.peakTaskTotalMemoryBytes = peakTaskTotalMemoryBytes;
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.cumulativeTotalMemory = cumulativeTotalMemory;
        this.inputRows = inputRows;
        this.inputBytes = inputBytes;
        this.blocked = blocked;
        this.blockedReasons = Objects.requireNonNull(blockedReasons, "blockedReasons is null").map(ImmutableSet::copyOf);
        this.progressPercentage = Objects.requireNonNull(progressPercentage, "progressPercentage is null");
        this.queuedDrivers = queuedDrivers;
        this.runningDrivers = runningDrivers;
        this.completedDrivers = completedDrivers;
    }

    public static QueryProgressStats createQueryProgressStats(BasicQueryStats queryStats) {
        return new QueryProgressStats(queryStats.getElapsedTime().toMillis(), queryStats.getQueuedTime().toMillis(), queryStats.getExecutionTime().toMillis(), queryStats.getTotalCpuTime().toMillis(), queryStats.getTotalScheduledTime().toMillis(), queryStats.getUserMemoryReservation().toBytes(), queryStats.getPeakUserMemoryReservation().toBytes(), queryStats.getPeakTotalMemoryReservation().toBytes(), queryStats.getPeakTaskTotalMemoryReservation().toBytes(), queryStats.getCumulativeUserMemory(), queryStats.getCumulativeTotalMemory(), queryStats.getRawInputPositions(), queryStats.getRawInputDataSize().toBytes(), queryStats.isFullyBlocked(), queryStats.isFullyBlocked() ? Optional.of(queryStats.getBlockedReasons()) : Optional.empty(), queryStats.getProgressPercentage(), queryStats.getQueuedDrivers(), queryStats.getRunningDrivers(), queryStats.getCompletedDrivers());
    }

    @ThriftField(value=1)
    @JsonProperty
    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    @ThriftField(value=2)
    @JsonProperty
    public long getQueuedTimeMillis() {
        return this.queuedTimeMillis;
    }

    @ThriftField(value=3)
    @JsonProperty
    public long getExecutionTimeMillis() {
        return this.executionTimeMillis;
    }

    @ThriftField(value=4)
    @JsonProperty
    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    @ThriftField(value=5)
    @JsonProperty
    public long getScheduledTimeMillis() {
        return this.scheduledTimeMillis;
    }

    @ThriftField(value=6)
    @JsonProperty
    public long getCurrentMemoryBytes() {
        return this.currentMemoryBytes;
    }

    @ThriftField(value=7)
    @JsonProperty
    public long getPeakMemoryBytes() {
        return this.peakMemoryBytes;
    }

    @ThriftField(value=8)
    @JsonProperty
    public long getPeakTotalMemoryBytes() {
        return this.peakTotalMemoryBytes;
    }

    @ThriftField(value=9)
    @JsonProperty
    public long getPeakTaskTotalMemoryBytes() {
        return this.peakTaskTotalMemoryBytes;
    }

    @ThriftField(value=10)
    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @ThriftField(value=11)
    @JsonProperty
    public double getCumulativeTotalMemory() {
        return this.cumulativeTotalMemory;
    }

    @ThriftField(value=12)
    @JsonProperty
    public long getInputRows() {
        return this.inputRows;
    }

    @ThriftField(value=13)
    @JsonProperty
    public long getInputBytes() {
        return this.inputBytes;
    }

    @ThriftField(value=14)
    @JsonProperty
    public boolean isBlocked() {
        return this.blocked;
    }

    @ThriftField(value=15)
    @JsonProperty
    public Optional<Set<BlockedReason>> getBlockedReasons() {
        return this.blockedReasons;
    }

    @ThriftField(value=16)
    @JsonProperty
    public OptionalDouble getProgressPercentage() {
        return this.progressPercentage;
    }

    @ThriftField(value=17)
    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @ThriftField(value=18)
    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @ThriftField(value=19)
    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }
}

