/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.security.SecurityConfig;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AuthorizedIdentity;
import com.facebook.presto.spi.security.Identity;
import java.util.Optional;

public class AccessControlUtils {
    private AccessControlUtils() {
    }

    public static void checkPermissions(AccessControl accessControl, SecurityConfig securityConfig, QueryId queryId, SessionContext sessionContext) {
        Identity identity = sessionContext.getIdentity();
        if (!securityConfig.isAuthorizedIdentitySelectionEnabled()) {
            accessControl.checkCanSetUser(identity, new AccessControlContext(queryId, Optional.ofNullable(sessionContext.getClientInfo()), Optional.ofNullable(sessionContext.getSource())), identity.getPrincipal(), identity.getUser());
        }
    }

    public static Optional<AuthorizedIdentity> getAuthorizedIdentity(AccessControl accessControl, SecurityConfig securityConfig, QueryId queryId, SessionContext sessionContext) {
        if (securityConfig.isAuthorizedIdentitySelectionEnabled()) {
            Identity identity = sessionContext.getIdentity();
            AuthorizedIdentity authorizedIdentity = accessControl.selectAuthorizedIdentity(identity, new AccessControlContext(queryId, Optional.ofNullable(sessionContext.getClientInfo()), Optional.ofNullable(sessionContext.getSource())), identity.getUser(), sessionContext.getCertificates());
            return Optional.of(authorizedIdentity);
        }
        return Optional.empty();
    }
}

