/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.memory.ClusterMemoryPool;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.facebook.presto.resourcemanager.ResourceManagerInconsistentException;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.BasicQueryStats;
import com.facebook.presto.server.NodeStatus;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.ClusterMemoryPoolInfo;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class ResourceManagerClusterStateProvider {
    private final Map<String, CoordinatorQueriesState> nodeQueryStates = new ConcurrentHashMap<String, CoordinatorQueriesState>();
    private final Map<String, InternalNodeState> nodeStatuses = new ConcurrentHashMap<String, InternalNodeState>();
    private final Map<String, CoordinatorResourceGroupState> resourceGroupStates = new ConcurrentHashMap<String, CoordinatorResourceGroupState>();
    private final AtomicReference<Integer> adjustedQueueSize = new AtomicReference<Integer>(0);
    private final InternalNodeManager internalNodeManager;
    private final SessionPropertyManager sessionPropertyManager;
    private final int maxCompletedQueries;
    private final Duration queryExpirationTimeout;
    private final Duration completedQueryExpirationTimeout;
    private final boolean isReservedPoolEnabled;
    private final Supplier<Map<MemoryPoolId, ClusterMemoryPoolInfo>> clusterMemoryPoolInfosSupplier;

    @Inject
    public ResourceManagerClusterStateProvider(InternalNodeManager internalNodeManager, SessionPropertyManager sessionPropertyManager, ResourceManagerConfig resourceManagerConfig, NodeMemoryConfig nodeMemoryConfig, @ForResourceManager ScheduledExecutorService scheduledExecutorService) {
        this(Objects.requireNonNull(internalNodeManager, "internalNodeManager is null"), Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null"), Objects.requireNonNull(resourceManagerConfig, "resourceManagerConfig is null").getMaxCompletedQueries(), resourceManagerConfig.getQueryExpirationTimeout(), resourceManagerConfig.getCompletedQueryExpirationTimeout(), resourceManagerConfig.getNodeStatusTimeout(), resourceManagerConfig.getMemoryPoolInfoRefreshDuration(), resourceManagerConfig.getResourceGroupRuntimeInfoTimeout(), Objects.requireNonNull(nodeMemoryConfig, "nodeMemoryConfig is null").isReservedPoolEnabled(), Objects.requireNonNull(scheduledExecutorService, "scheduledExecutorService is null"));
    }

    public ResourceManagerClusterStateProvider(InternalNodeManager internalNodeManager, SessionPropertyManager sessionPropertyManager, int maxCompletedQueries, Duration queryExpirationTimeout, Duration completedQueryExpirationTimeout, Duration nodeStatusTimeout, Duration memoryPoolInfoRefreshDuration, Duration resourceGroupRuntimeInfoTimeout, boolean isReservedPoolEnabled, ScheduledExecutorService scheduledExecutorService) {
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        Preconditions.checkArgument((maxCompletedQueries > 0 ? 1 : 0) != 0, (String)"maxCompletedQueries must be > 0, was %s", (int)maxCompletedQueries);
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.maxCompletedQueries = maxCompletedQueries;
        this.queryExpirationTimeout = Objects.requireNonNull(queryExpirationTimeout, "queryExpirationTimeout is null");
        this.completedQueryExpirationTimeout = Objects.requireNonNull(completedQueryExpirationTimeout, "completedQueryExpirationTimeout is null");
        Objects.requireNonNull(memoryPoolInfoRefreshDuration, "memoryPoolInfoRefreshDuration is null");
        this.clusterMemoryPoolInfosSupplier = memoryPoolInfoRefreshDuration.toMillis() > 0L ? Suppliers.memoizeWithExpiration(this::getClusterMemoryPoolInfoInternal, (long)memoryPoolInfoRefreshDuration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : this::getClusterMemoryPoolInfoInternal;
        this.isReservedPoolEnabled = isReservedPoolEnabled;
        Objects.requireNonNull(scheduledExecutorService, "scheduledExecutorService is null");
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            for (CoordinatorQueriesState coordinatorQueriesState : ImmutableList.copyOf(this.nodeQueryStates.values())) {
                coordinatorQueriesState.purgeExpiredQueries();
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            for (Map.Entry nodeEntry : ImmutableList.copyOf(this.nodeStatuses.entrySet())) {
                if (System.currentTimeMillis() - ((InternalNodeState)nodeEntry.getValue()).getLastHeartbeatInMillis() <= nodeStatusTimeout.toMillis()) continue;
                this.nodeStatuses.remove(nodeEntry.getKey());
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            for (Map.Entry resourceGroupState : ImmutableList.copyOf(this.resourceGroupStates.entrySet())) {
                if (System.currentTimeMillis() - ((CoordinatorResourceGroupState)resourceGroupState.getValue()).getLastHeartbeatInMillis() <= resourceGroupRuntimeInfoTimeout.toMillis()) continue;
                this.resourceGroupStates.remove(resourceGroupState.getKey());
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        scheduledExecutorService.scheduleAtFixedRate(() -> this.adjustedQueueSize.set(this.computeAdjustedQueueSize()), 100L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void registerQueryHeartbeat(String nodeId, BasicQueryInfo basicQueryInfo, long sequenceId) {
        Objects.requireNonNull(nodeId, "nodeId is null");
        Objects.requireNonNull(basicQueryInfo, "basicQueryInfo is null");
        Stream activeOrShuttingDownCoordinators = Stream.concat(this.internalNodeManager.getCoordinators().stream(), this.internalNodeManager.getShuttingDownCoordinator().stream());
        Preconditions.checkArgument((boolean)activeOrShuttingDownCoordinators.anyMatch(i -> nodeId.equals(i.getNodeIdentifier())), (String)"%s is not a coordinator (coordinators: %s)", (Object)nodeId, this.internalNodeManager.getCoordinators().stream().collect(ImmutableSet.toImmutableSet()));
        CoordinatorQueriesState state = this.nodeQueryStates.computeIfAbsent(nodeId, identifier -> new CoordinatorQueriesState(nodeId, this.maxCompletedQueries, this.queryExpirationTimeout.toMillis(), this.completedQueryExpirationTimeout.toMillis()));
        state.addOrUpdateQuery(basicQueryInfo, sequenceId);
    }

    public void registerNodeHeartbeat(NodeStatus nodeStatus) {
        Objects.requireNonNull(nodeStatus, "nodeStatus is null");
        InternalNodeState nodeState = this.nodeStatuses.get(nodeStatus.getNodeId());
        if (nodeState == null) {
            this.nodeStatuses.put(nodeStatus.getNodeId(), new InternalNodeState(nodeStatus));
        } else {
            nodeState.updateNodeStatus(nodeStatus);
        }
    }

    public void registerResourceGroupRuntimeHeartbeat(String node, List<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfos) {
        this.resourceGroupStates.put(node, new CoordinatorResourceGroupState(node, System.currentTimeMillis(), resourceGroupRuntimeInfos));
    }

    public int getAdjustedQueueSize() {
        return this.adjustedQueueSize.get();
    }

    private int computeAdjustedQueueSize() {
        HashMap resourceGroupBuilders = new HashMap();
        this.resourceGroupStates.values().stream().map(CoordinatorResourceGroupState::getResourceGroups).flatMap(Collection::stream).forEach(resourceGroupRuntimeInfo -> {
            ResourceGroupId resourceGroupId = resourceGroupRuntimeInfo.getResourceGroupId();
            ResourceGroupRuntimeInfo.Builder runtimeInfoBuilder = resourceGroupBuilders.computeIfAbsent(resourceGroupId, ResourceGroupRuntimeInfo::builder);
            runtimeInfoBuilder.addQueuedQueries(resourceGroupRuntimeInfo.getQueuedQueries());
            runtimeInfoBuilder.addRunningQueries(resourceGroupRuntimeInfo.getRunningQueries());
            runtimeInfoBuilder.addDescendantQueuedQueries(resourceGroupRuntimeInfo.getDescendantQueuedQueries());
            runtimeInfoBuilder.addDescendantRunningQueries(resourceGroupRuntimeInfo.getDescendantRunningQueries());
            if (resourceGroupRuntimeInfo.getResourceGroupConfigSpec().isPresent()) {
                runtimeInfoBuilder.setResourceGroupSpecInfo(resourceGroupRuntimeInfo.getResourceGroupConfigSpec().get());
            }
        });
        List resourceGroupRuntimeInfos = (List)resourceGroupBuilders.values().stream().map(ResourceGroupRuntimeInfo.Builder::build).collect(ImmutableList.toImmutableList());
        int adjustedQueueSize = 0;
        for (ResourceGroupRuntimeInfo runtimeInfo : resourceGroupRuntimeInfos) {
            Preconditions.checkState((boolean)runtimeInfo.getResourceGroupConfigSpec().isPresent());
            adjustedQueueSize += Math.max(Math.min(runtimeInfo.getQueuedQueries(), runtimeInfo.getResourceGroupConfigSpec().get().getSoftConcurrencyLimit() - runtimeInfo.getRunningQueries()), 0);
        }
        return adjustedQueueSize;
    }

    public List<ResourceGroupRuntimeInfo> getClusterResourceGroups(String excludingNode) throws ResourceManagerInconsistentException {
        Objects.requireNonNull(excludingNode, "excludingNode is null");
        this.validateCoordinatorConsistency();
        HashMap resourceGroupBuilders = new HashMap();
        this.nodeQueryStates.values().stream().filter(state -> !state.getNodeId().equals(excludingNode)).map(CoordinatorQueriesState::getActiveQueries).flatMap(Collection::stream).map(Query::getBasicQueryInfo).filter(info -> info.getResourceGroupId().isPresent()).forEach(info -> {
            ResourceGroupId resourceGroupId = info.getResourceGroupId().get();
            ResourceGroupRuntimeInfo.Builder builder = resourceGroupBuilders.computeIfAbsent(resourceGroupId, ResourceGroupRuntimeInfo::builder);
            if (info.getState() == QueryState.QUEUED) {
                builder.addQueuedQueries(1);
            } else if (!info.getState().isDone() && info.getState() != QueryState.WAITING_FOR_PREREQUISITES) {
                builder.addRunningQueries(1);
            }
            builder.addUserMemoryReservationBytes(info.getQueryStats().getUserMemoryReservation().toBytes());
            while (resourceGroupId.getParent().isPresent()) {
                resourceGroupId = (ResourceGroupId)resourceGroupId.getParent().get();
                ResourceGroupRuntimeInfo.Builder parentBuilder = resourceGroupBuilders.computeIfAbsent(resourceGroupId, ResourceGroupRuntimeInfo::builder);
                if (info.getState() == QueryState.QUEUED) {
                    parentBuilder.addDescendantQueuedQueries(1);
                    continue;
                }
                if (info.getState().isDone() || info.getState() == QueryState.WAITING_FOR_PREREQUISITES) continue;
                parentBuilder.addDescendantRunningQueries(1);
            }
        });
        return (List)resourceGroupBuilders.values().stream().map(ResourceGroupRuntimeInfo.Builder::build).collect(ImmutableList.toImmutableList());
    }

    public List<BasicQueryInfo> getClusterQueries() {
        return (List)ImmutableList.copyOf(this.nodeQueryStates.values()).stream().map(CoordinatorQueriesState::getAllQueries).flatMap(Collection::stream).map(Query::getBasicQueryInfo).collect(ImmutableList.toImmutableList());
    }

    public int getRunningTaskCount() {
        int runningTaskCount = this.nodeQueryStates.values().stream().map(CoordinatorQueriesState::getActiveQueries).flatMap(Collection::stream).map(Query::getBasicQueryInfo).filter(q -> q.getState() == QueryState.RUNNING).map(BasicQueryInfo::getQueryStats).collect(Collectors.summingInt(BasicQueryStats::getRunningTasks));
        return runningTaskCount;
    }

    public Map<MemoryPoolId, ClusterMemoryPoolInfo> getClusterMemoryPoolInfo() {
        return this.clusterMemoryPoolInfosSupplier.get();
    }

    private Map<MemoryPoolId, ClusterMemoryPoolInfo> getClusterMemoryPoolInfoInternal() {
        List memoryInfos = (List)this.nodeStatuses.values().stream().map(nodeStatus -> nodeStatus.getNodeStatus().getMemoryInfo()).collect(ImmutableList.toImmutableList());
        int queriesAssignedToGeneralPool = 0;
        int queriesAssignedToReservedPool = 0;
        Query largestGeneralPoolQuery = null;
        for (CoordinatorQueriesState nodeQueryState : this.nodeQueryStates.values()) {
            for (Query query2 : nodeQueryState.getActiveQueries()) {
                MemoryPoolId memoryPool = query2.getBasicQueryInfo().getMemoryPool();
                if (LocalMemoryManager.GENERAL_POOL.equals((Object)memoryPool)) {
                    queriesAssignedToGeneralPool = Math.incrementExact(queriesAssignedToGeneralPool);
                    if (SystemSessionProperties.resourceOvercommit(query2.getBasicQueryInfo().getSession().toSession(this.sessionPropertyManager))) continue;
                    largestGeneralPoolQuery = this.getLargestMemoryQuery(Optional.ofNullable(largestGeneralPoolQuery), query2);
                    continue;
                }
                if (LocalMemoryManager.RESERVED_POOL.equals((Object)memoryPool)) {
                    queriesAssignedToReservedPool = Math.incrementExact(queriesAssignedToReservedPool);
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized memory pool: " + memoryPool);
            }
        }
        List runningQueries = (List)this.nodeQueryStates.values().stream().map(CoordinatorQueriesState::getActiveQueries).flatMap(Collection::stream).filter(query -> query.getBasicQueryInfo().getState() == QueryState.RUNNING).map(Query::getQueryId).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder memoryPoolInfos = ImmutableMap.builder();
        ClusterMemoryPool pool = new ClusterMemoryPool(LocalMemoryManager.GENERAL_POOL);
        pool.update(memoryInfos, queriesAssignedToGeneralPool);
        ClusterMemoryPoolInfo clusterInfo = pool.getClusterInfo(Optional.ofNullable(largestGeneralPoolQuery).map(Query::getQueryId), Optional.ofNullable(runningQueries));
        memoryPoolInfos.put((Object)LocalMemoryManager.GENERAL_POOL, (Object)clusterInfo);
        if (this.isReservedPoolEnabled) {
            pool = new ClusterMemoryPool(LocalMemoryManager.RESERVED_POOL);
            pool.update(memoryInfos, queriesAssignedToReservedPool);
            memoryPoolInfos.put((Object)LocalMemoryManager.RESERVED_POOL, (Object)pool.getClusterInfo());
        }
        return memoryPoolInfos.build();
    }

    private Query getLargestMemoryQuery(Optional<Query> existingLargeQuery, Query newQuery) {
        Objects.requireNonNull(newQuery, "newQuery must not be null");
        return existingLargeQuery.map(largeQuery -> {
            long largestGeneralBytes = largeQuery.getBasicQueryInfo().getQueryStats().getTotalMemoryReservation().toBytes();
            long currentGeneralBytes = newQuery.getBasicQueryInfo().getQueryStats().getTotalMemoryReservation().toBytes();
            if (currentGeneralBytes > largestGeneralBytes) {
                return newQuery;
            }
            return largeQuery;
        }).orElse(newQuery);
    }

    public Map<String, MemoryInfo> getWorkerMemoryInfo() {
        return (Map)this.nodeStatuses.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> {
            String nodeIdentifier = ((InternalNodeState)e.getValue()).getNodeStatus().getNodeId();
            String nodeHost = URI.create(((InternalNodeState)e.getValue()).getNodeStatus().getExternalAddress()).getHost();
            return nodeIdentifier + " [" + nodeHost + "]";
        }, e -> ((InternalNodeState)e.getValue()).getNodeStatus().getMemoryInfo()));
    }

    private void validateCoordinatorConsistency() {
        Set heartbeatedCoordinatorNodes;
        Set coordinators = (Set)this.internalNodeManager.getCoordinators().stream().map(InternalNode::getNodeIdentifier).collect(ImmutableSet.toImmutableSet());
        if (!Sets.difference((Set)coordinators, (Set)(heartbeatedCoordinatorNodes = (Set)this.nodeStatuses.values().stream().map(InternalNodeState::getNodeStatus).filter(NodeStatus::isCoordinator).map(NodeStatus::getNodeId).collect(ImmutableSet.toImmutableSet()))).isEmpty() || coordinators.isEmpty()) {
            throw new ResourceManagerInconsistentException(String.format("%s nodes found in discovery vs. %s nodes found in heartbeats", coordinators.size(), heartbeatedCoordinatorNodes.size()));
        }
    }

    private static boolean isQueryExpired(Query query, long timeoutInMillis, long timeout) {
        return timeoutInMillis - query.getLastHeartbeatInMillis() > timeout;
    }

    private static boolean isQueryCompleted(Query query) {
        return query.getBasicQueryInfo().getState().isDone();
    }

    public static class Query {
        private final QueryId queryId;
        private volatile BasicQueryInfo basicQueryInfo;
        private final AtomicLong lastHeartbeatInMillis = new AtomicLong();
        private final AtomicLong sequenceId;

        public Query(BasicQueryInfo basicQueryInfo, long sequenceId) {
            this.queryId = basicQueryInfo.getQueryId();
            this.basicQueryInfo = basicQueryInfo;
            this.sequenceId = new AtomicLong(sequenceId);
            this.recordHeartbeat();
        }

        private void recordHeartbeat() {
            this.lastHeartbeatInMillis.set(System.currentTimeMillis());
        }

        public long getLastHeartbeatInMillis() {
            return this.lastHeartbeatInMillis.get();
        }

        public Query updateQueryInfo(BasicQueryInfo basicQueryInfo, long sequenceId) {
            Objects.requireNonNull(basicQueryInfo, "basicQueryInfo is null");
            long newSequenceId = this.sequenceId.updateAndGet(operand -> Math.max(operand, sequenceId));
            if (newSequenceId == sequenceId) {
                this.basicQueryInfo = basicQueryInfo;
            }
            this.recordHeartbeat();
            return this;
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public BasicQueryInfo getBasicQueryInfo() {
            return this.basicQueryInfo;
        }
    }

    private static final class InternalNodeState {
        private volatile NodeStatus nodeStatus;
        private final AtomicLong lastHeartbeatInMillis = new AtomicLong();

        private InternalNodeState(NodeStatus nodeStatus) {
            this.nodeStatus = nodeStatus;
            this.recordHeartbeat();
        }

        private void recordHeartbeat() {
            this.lastHeartbeatInMillis.set(System.currentTimeMillis());
        }

        public long getLastHeartbeatInMillis() {
            return this.lastHeartbeatInMillis.get();
        }

        public InternalNodeState updateNodeStatus(NodeStatus nodeStatus) {
            Objects.requireNonNull(nodeStatus, "nodeStatus is null");
            this.nodeStatus = nodeStatus;
            this.recordHeartbeat();
            return this;
        }

        public NodeStatus getNodeStatus() {
            return this.nodeStatus;
        }
    }

    private static class CoordinatorQueriesState {
        private final String nodeId;
        private final int maxCompletedQueries;
        private final long queryExpirationTimeoutMillis;
        private final long completedQueryExpirationTimeoutMillis;
        @GuardedBy(value="this")
        private final Map<QueryId, Query> activeQueries = new HashMap<QueryId, Query>();
        @GuardedBy(value="this")
        private final Map<QueryId, Query> completedQueries = new LinkedHashMap<QueryId, Query>();

        public CoordinatorQueriesState(String nodeId, int maxCompletedQueries, long queryExpirationTimeoutMillis, long completedQueryExpirationTimeoutMillis) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
            Preconditions.checkArgument((maxCompletedQueries > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((queryExpirationTimeoutMillis > 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((completedQueryExpirationTimeoutMillis > 0L ? 1 : 0) != 0);
            this.maxCompletedQueries = maxCompletedQueries;
            this.queryExpirationTimeoutMillis = queryExpirationTimeoutMillis;
            this.completedQueryExpirationTimeoutMillis = completedQueryExpirationTimeoutMillis;
        }

        public synchronized void addOrUpdateQuery(BasicQueryInfo basicQueryInfo, long sequenceId) {
            Objects.requireNonNull(basicQueryInfo, "basicQueryInfo is null");
            QueryId queryId = basicQueryInfo.getQueryId();
            Query query = this.activeQueries.get(queryId);
            if (query == null) {
                query = this.completedQueries.get(queryId);
            }
            if (query == null) {
                query = new Query(basicQueryInfo, sequenceId);
                this.activeQueries.put(queryId, query);
            } else {
                query = query.updateQueryInfo(basicQueryInfo, sequenceId);
            }
            if (ResourceManagerClusterStateProvider.isQueryCompleted(query)) {
                this.completedQueries.put(query.getQueryId(), query);
                this.activeQueries.remove(query.getQueryId());
            }
        }

        public synchronized void purgeExpiredQueries() {
            long currentTimeMillis = System.currentTimeMillis();
            Iterator<Query> queryIterator = this.activeQueries.values().iterator();
            while (queryIterator.hasNext()) {
                Query query = queryIterator.next();
                if (!ResourceManagerClusterStateProvider.isQueryExpired(query, currentTimeMillis, this.queryExpirationTimeoutMillis)) continue;
                this.completedQueries.put(query.getQueryId(), query);
                queryIterator.remove();
            }
            Iterator<Query> completedQueriesIterator = this.completedQueries.values().iterator();
            while (completedQueriesIterator.hasNext()) {
                Query query = completedQueriesIterator.next();
                if (this.completedQueries.size() <= this.maxCompletedQueries && !ResourceManagerClusterStateProvider.isQueryExpired(query, currentTimeMillis, this.completedQueryExpirationTimeoutMillis)) break;
                completedQueriesIterator.remove();
            }
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public synchronized List<Query> getActiveQueries() {
            return ImmutableList.copyOf(this.activeQueries.values());
        }

        public synchronized List<Query> getAllQueries() {
            this.purgeExpiredQueries();
            return ImmutableList.builder().addAll(this.activeQueries.values()).addAll(this.completedQueries.values()).build();
        }
    }

    private static class CoordinatorResourceGroupState {
        private final String nodeId;
        private final long lastHeartbeatInMillis;
        private final List<ResourceGroupRuntimeInfo> resourceGroups;

        public CoordinatorResourceGroupState(String nodeId, long lastHeartbeatInMillis, List<ResourceGroupRuntimeInfo> resourceGroups) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
            this.lastHeartbeatInMillis = lastHeartbeatInMillis;
            this.resourceGroups = Objects.requireNonNull(resourceGroups, "resourceGroups is null");
        }

        public List<ResourceGroupRuntimeInfo> getResourceGroups() {
            return this.resourceGroups;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public long getLastHeartbeatInMillis() {
            return this.lastHeartbeatInMillis;
        }
    }
}

