/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStateProvider;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.ClusterStatsResource;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.spi.memory.ClusterMemoryPoolInfo;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/cluster")
@RolesAllowed(value={"user", "admin"})
public class DistributedClusterStatsResource {
    private final boolean isIncludeCoordinator;
    private final ResourceManagerClusterStateProvider clusterStateProvider;
    private final InternalNodeManager internalNodeManager;
    private final Supplier<ClusterStatsResource.ClusterStats> clusterStatsSupplier;

    @Inject
    public DistributedClusterStatsResource(NodeSchedulerConfig nodeSchedulerConfig, ServerConfig serverConfig, ResourceManagerClusterStateProvider clusterStateProvider, InternalNodeManager internalNodeManager) {
        this.isIncludeCoordinator = Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null").isIncludeCoordinator();
        this.clusterStateProvider = Objects.requireNonNull(clusterStateProvider, "nodeStateManager is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        Duration expirationDuration = Objects.requireNonNull(serverConfig, "serverConfig is null").getClusterStatsExpirationDuration();
        this.clusterStatsSupplier = expirationDuration.getValue() > 0.0 ? Suppliers.memoizeWithExpiration(this::calculateClusterStats, (long)expirationDuration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : this::calculateClusterStats;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getClusterStats() {
        return Response.ok((Object)this.clusterStatsSupplier.get()).build();
    }

    private ClusterStatsResource.ClusterStats calculateClusterStats() {
        long runningQueries = 0L;
        long blockedQueries = 0L;
        long queuedQueries = 0L;
        long activeNodes = this.internalNodeManager.getNodes(NodeState.ACTIVE).size();
        if (!this.isIncludeCoordinator) {
            activeNodes -= (long)this.internalNodeManager.getCoordinators().size();
        }
        activeNodes -= (long)this.internalNodeManager.getResourceManagers().size();
        long runningDrivers = 0L;
        long runningTasks = 0L;
        double memoryReservation = 0.0;
        long totalInputRows = 0L;
        long totalInputBytes = 0L;
        long totalCpuTimeSecs = 0L;
        for (BasicQueryInfo query : this.clusterStateProvider.getClusterQueries()) {
            if (query.getState() == QueryState.QUEUED) {
                ++queuedQueries;
            } else if (query.getState() == QueryState.RUNNING) {
                if (query.getQueryStats().isFullyBlocked()) {
                    ++blockedQueries;
                } else {
                    ++runningQueries;
                }
            }
            if (query.getState().isDone()) continue;
            totalInputBytes += query.getQueryStats().getRawInputDataSize().toBytes();
            totalInputRows += query.getQueryStats().getRawInputPositions();
            totalCpuTimeSecs = (long)((double)totalCpuTimeSecs + query.getQueryStats().getTotalCpuTime().getValue(TimeUnit.SECONDS));
            memoryReservation += (double)query.getQueryStats().getUserMemoryReservation().toBytes();
            runningDrivers += (long)query.getQueryStats().getRunningDrivers();
            runningTasks += (long)query.getQueryStats().getRunningTasks();
        }
        return new ClusterStatsResource.ClusterStats(runningQueries, blockedQueries, queuedQueries, activeNodes, runningDrivers, runningTasks, memoryReservation, totalInputRows, totalInputBytes, totalCpuTimeSecs, this.clusterStateProvider.getAdjustedQueueSize());
    }

    @GET
    @Path(value="memory")
    public Response getClusterMemoryPoolInfo() {
        Map memoryPoolInfos = (Map)this.clusterStateProvider.getClusterMemoryPoolInfo().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ClusterMemoryPoolInfo)e.getValue()).getMemoryPoolInfo()));
        return Response.ok().entity((Object)memoryPoolInfos).build();
    }

    @GET
    @Path(value="workerMemory")
    public Response getWorkerMemoryInfo() {
        return Response.ok().entity(this.clusterStateProvider.getWorkerMemoryInfo()).build();
    }
}

