/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.tdigest.Centroid;
import com.facebook.presto.tdigest.TDigest;
import com.facebook.presto.util.Failures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.List;

public final class TDigestFunctions {
    public static final double DEFAULT_COMPRESSION = 100.0;
    @VisibleForTesting
    static final RowType TDIGEST_CENTROIDS_ROW_TYPE = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"centroid_means", (Type)new ArrayType((Type)DoubleType.DOUBLE)), (Object)RowType.field((String)"centroid_weights", (Type)new ArrayType((Type)IntegerType.INTEGER)), (Object)RowType.field((String)"compression", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"min", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"max", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"sum", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"count", (Type)BigintType.BIGINT)));

    private TDigestFunctions() {
    }

    @ScalarFunction(value="value_at_quantile", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the tdigest is qn.")
    @SqlType(value="double")
    public static double valueAtQuantileDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="double") double quantile) {
        return TDigest.createTDigest(input).getQuantile(quantile);
    }

    @ScalarFunction(value="values_at_quantiles", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the tdigest is qn.")
    @SqlType(value="array(double)")
    public static Block valuesAtQuantilesDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        TDigest tDigest = TDigest.createTDigest(input);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            DoubleType.DOUBLE.writeDouble(output, tDigest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i)));
        }
        return output.build();
    }

    @ScalarFunction(value="quantile_at_value", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Given an input x between min/max values of t-digest, find which quantile is represented by that value")
    @SqlType(value="double")
    public static double quantileAtValueDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="double") double value) {
        return TDigest.createTDigest(input).getCdf(value);
    }

    @ScalarFunction(value="quantiles_at_values", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="For each input x between min/max values of t-digest, find which quantile is represented by that value")
    @SqlType(value="array(double)")
    public static Block quantilesAtValuesDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="array(double)") Block valuesArrayBlock) {
        TDigest tDigest = TDigest.createTDigest(input);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, valuesArrayBlock.getPositionCount());
        for (int i = 0; i < valuesArrayBlock.getPositionCount(); ++i) {
            DoubleType.DOUBLE.writeDouble(output, tDigest.getCdf(DoubleType.DOUBLE.getDouble(valuesArrayBlock, i)));
        }
        return output.build();
    }

    @ScalarFunction(value="scale_tdigest", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Scale a t-digest according to a new weight")
    @SqlType(value="tdigest(double)")
    public static Slice scaleTDigestDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="double") double scale) {
        Failures.checkCondition(scale > 0.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Scale factor should be positive.", new Object[0]);
        TDigest digest = TDigest.createTDigest(input);
        digest.scale(scale);
        return digest.serialize();
    }

    @ScalarFunction(value="destructure_tdigest", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Return the raw TDigest, including arrays of centroid means and weights, as well as min, max, sum, count, and compression factor.")
    @SqlType(value="row(centroid_means array(double), centroid_weights array(integer), compression double, min double, max double, sum double, count bigint)")
    public static Block destructureTDigest(@SqlType(value="tdigest(double)") Slice input) {
        TDigest tDigest = TDigest.createTDigest(input);
        BlockBuilder blockBuilder = TDIGEST_CENTROIDS_ROW_TYPE.createBlockBuilder(null, 1);
        BlockBuilder rowBuilder = blockBuilder.beginBlockEntry();
        BlockBuilder meansBuilder = DoubleType.DOUBLE.createBlockBuilder(null, tDigest.centroidCount());
        BlockBuilder weightsBuilder = IntegerType.INTEGER.createBlockBuilder(null, tDigest.centroidCount());
        for (Centroid centroid : tDigest.centroids()) {
            int weight = (int)centroid.getWeight();
            DoubleType.DOUBLE.writeDouble(meansBuilder, centroid.getMean());
            IntegerType.INTEGER.writeLong(weightsBuilder, (long)weight);
        }
        rowBuilder.appendStructure((Block)meansBuilder);
        rowBuilder.appendStructure((Block)weightsBuilder);
        DoubleType.DOUBLE.writeDouble(rowBuilder, tDigest.getCompressionFactor());
        DoubleType.DOUBLE.writeDouble(rowBuilder, tDigest.getMin());
        DoubleType.DOUBLE.writeDouble(rowBuilder, tDigest.getMax());
        DoubleType.DOUBLE.writeDouble(rowBuilder, tDigest.getSum());
        BigintType.BIGINT.writeLong(rowBuilder, (long)tDigest.getSize());
        blockBuilder.closeEntry();
        return TDIGEST_CENTROIDS_ROW_TYPE.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }

    @ScalarFunction(value="trimmed_mean", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Returns an estimate of the mean, excluding portions of the distribution outside the provided quantile bounds.")
    @SqlType(value="double")
    public static double trimmedMeanTDigestDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="double") double lowerQuantileBound, @SqlType(value="double") double upperQuantileBound) {
        Failures.checkCondition(lowerQuantileBound >= 0.0 && lowerQuantileBound <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lower quantile bound should be in [0,1].", new Object[0]);
        Failures.checkCondition(upperQuantileBound >= 0.0 && upperQuantileBound <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Upper quantile bound should be in [0,1].", new Object[0]);
        TDigest digest = TDigest.createTDigest(input);
        return digest.trimmedMean(lowerQuantileBound, upperQuantileBound);
    }

    @ScalarFunction(value="construct_tdigest", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Create a TDigest by passing in its internal state.")
    @SqlType(value="tdigest(double)")
    public static Slice constructTDigest(@SqlType(value="array(double)") Block centroidMeansBlock, @SqlType(value="array(double)") Block centroidWeightsBlock, @SqlType(value="double") double compression, @SqlType(value="double") double min, @SqlType(value="double") double max, @SqlType(value="double") double sum, @SqlType(value="bigint") long count) {
        double[] centroidMeans = new double[centroidMeansBlock.getPositionCount()];
        for (int i = 0; i < centroidMeansBlock.getPositionCount(); ++i) {
            centroidMeans[i] = DoubleType.DOUBLE.getDouble(centroidMeansBlock, i);
        }
        double[] centroidWeights = new double[centroidWeightsBlock.getPositionCount()];
        for (int i = 0; i < centroidWeightsBlock.getPositionCount(); ++i) {
            centroidWeights[i] = DoubleType.DOUBLE.getDouble(centroidWeightsBlock, i);
        }
        TDigest tDigest = TDigest.createTDigest(centroidMeans, centroidWeights, compression, min, max, sum, Math.toIntExact(count));
        return tDigest.serialize();
    }

    @ScalarFunction(value="merge_tdigest", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Merge an array of TDigests into a single TDigest")
    @SqlType(value="tdigest(double)")
    @SqlNullable
    public static Slice merge_tdigest(@SqlType(value="array(tdigest(double))") Block input) {
        if (input.getPositionCount() == 0) {
            return null;
        }
        TDigest output = null;
        for (int i = 0; i < input.getPositionCount(); ++i) {
            if (input.isNull(i)) continue;
            TDigest tdigest = TDigest.createTDigest(input.getSlice(i, 0, input.getSliceLength(i)));
            if (output == null) {
                output = tdigest;
                continue;
            }
            output.merge(tdigest);
        }
        return output == null ? null : output.serialize();
    }
}

