/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.JsonOperators;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.JsonUtil;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RowToJsonCast
extends SqlOperator {
    public static final RowToJsonCast ROW_TO_JSON = new RowToJsonCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowToJsonCast.class, "toJson", List.class, List.class, SqlFunctionProperties.class, Block.class);
    private static final int ESTIMATED_FIELD_VALUE_SIZE = 40;
    private static final int ESTIMATED_FIELD_KEY_SIZE = 10;

    private RowToJsonCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.withVariadicBound((String)"T", (String)"row")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"json"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T")));
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type type = boundVariables.getTypeVariable("T");
        Failures.checkCondition(JsonUtil.canCastToJson(type), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast %s to JSON", type);
        List fieldTypes = type.getTypeParameters();
        ArrayList fieldWriters = new ArrayList(fieldTypes.size());
        List typeSignatureParameters = type.getTypeSignature().getParameters();
        List fieldNames = typeSignatureParameters.stream().map(typeSignatureParameter -> typeSignatureParameter.getNamedTypeSignature().getName().orElse("")).collect(Collectors.toList());
        Failures.checkCondition(fieldNames.size() == fieldTypes.size(), (ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "The number of field names (%d) and field types (%d) should match in type %s ", fieldNames.size(), fieldTypes.size(), type);
        fieldTypes.forEach(fieldType -> fieldWriters.add(JsonUtil.JsonGeneratorWriter.createJsonGeneratorWriter(fieldType)));
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(fieldNames).bindTo(fieldWriters);
        return new BuiltInScalarFunctionImplementation(false, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
    }

    private static Slice toJsonArray(List<JsonUtil.JsonGeneratorWriter> fieldWriters, SqlFunctionProperties session, Block block) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(40);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonOperators.JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeStartArray();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    fieldWriters.get(i).writeJsonValue(jsonGenerator, block, i, session);
                }
                jsonGenerator.writeEndArray();
            }
            return output.slice();
        }
        catch (IOException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @UsedByGeneratedCode
    public static Slice toJson(List<String> fieldNames, List<JsonUtil.JsonGeneratorWriter> fieldWriters, SqlFunctionProperties session, Block block) {
        if (session.isFieldNamesInJsonCastEnabled()) {
            return RowToJsonCast.toJsonObject(fieldNames, fieldWriters, session, block);
        }
        return RowToJsonCast.toJsonArray(fieldWriters, session, block);
    }

    private static Slice toJsonObject(List<String> fieldNames, List<JsonUtil.JsonGeneratorWriter> fieldWriters, SqlFunctionProperties session, Block block) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(50);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonOperators.JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeStartObject();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    jsonGenerator.writeFieldName(fieldNames.get(i));
                    fieldWriters.get(i).writeJsonValue(jsonGenerator, block, i, session);
                }
                jsonGenerator.writeEndObject();
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

