/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.DuplicateMapKeyException;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.SingleMapBlockWriter;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class MapConstructor
extends SqlScalarFunction {
    public static final MapConstructor MAP_CONSTRUCTOR = new MapConstructor();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapConstructor.class, "createMap", MapType.class, Type.class, Type.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, SqlFunctionProperties.class, Block.class, Block.class);
    private static final String DESCRIPTION = "Constructs a map from the given key/value arrays";

    public MapConstructor() {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"map"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"K"), (Object)Signature.typeVariable((String)"V")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,V)"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(K)"), (Object)TypeSignature.parseTypeSignature((String)"array(V)")), false));
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        Type mapType = functionAndTypeManager.getParameterizedType("map", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
        MethodHandle keyNativeHashCode = functionAndTypeManager.getJavaScalarFunctionImplementation(functionAndTypeManager.resolveOperator(OperatorType.HASH_CODE, TypeSignatureProvider.fromTypes((Type[])new Type[]{keyType}))).getMethodHandle();
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyNativeEquals = functionAndTypeManager.getJavaScalarFunctionImplementation(functionAndTypeManager.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{keyType, keyType}))).getMethodHandle();
        MethodHandle keyBlockEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyIndeterminate = functionAndTypeManager.getJavaScalarFunctionImplementation(functionAndTypeManager.resolveOperator(OperatorType.INDETERMINATE, TypeSignatureProvider.fromTypeSignatures((TypeSignature[])new TypeSignature[]{keyType.getTypeSignature()}))).getMethodHandle();
        return new BuiltInScalarFunctionImplementation(false, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), METHOD_HANDLE.bindTo(mapType).bindTo(keyType).bindTo(valueType).bindTo(keyBlockEquals).bindTo(keyBlockHashCode).bindTo(keyIndeterminate), Optional.empty());
    }

    @UsedByGeneratedCode
    public static Block createMap(MapType mapType, Type keyType, Type valueType, MethodHandle keyBlockEqual, MethodHandle keyBlockHashCode, MethodHandle keyIndeterminate, SqlFunctionProperties properties, Block keyBlock, Block valueBlock) {
        Failures.checkCondition(keyBlock.getPositionCount() == valueBlock.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key and value arrays must be the same length", new Object[0]);
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, keyBlock.getPositionCount() * 2);
        SingleMapBlockWriter blockBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < keyBlock.getPositionCount(); ++i) {
            if (keyBlock.isNull(i)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
            }
            if (keyType.getJavaType() == Block.class) {
                Object keyObject = TypeUtils.readNativeValue((Type)mapType.getKeyType(), (Block)keyBlock, (int)i);
                try {
                    if (keyIndeterminate.invoke(keyObject, false)) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be indeterminate: " + mapType.getKeyType().getObjectValue(properties, keyBlock, i));
                    }
                }
                catch (Throwable t) {
                    throw Failures.internalError(t);
                }
            }
            keyType.appendTo(keyBlock, i, (BlockBuilder)blockBuilder);
            valueType.appendTo(valueBlock, i, (BlockBuilder)blockBuilder);
        }
        try {
            mapBlockBuilder.closeEntryStrict(keyBlockEqual, keyBlockHashCode);
        }
        catch (DuplicateMapKeyException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, e.getDetailedMessage(mapType.getKeyType(), properties), (Throwable)e);
        }
        catch (NotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
        }
        return mapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }
}

