/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.gen.lambda.LambdaFunctionInterface;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class InvokeFunction
extends SqlScalarFunction {
    public static final InvokeFunction INVOKE_FUNCTION = new InvokeFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(InvokeFunction.class, "invoke", InvokeLambda.class);

    private InvokeFunction() {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"invoke"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"function(T)")), false));
    }

    public final SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.HIDDEN;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return "lambda invoke function";
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type returnType = boundVariables.getTypeVariable("T");
        return new BuiltInScalarFunctionImplementation(true, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.functionTypeArgumentProperty(InvokeLambda.class)), METHOD_HANDLE.asType(METHOD_HANDLE.type().changeReturnType(Primitives.wrap((Class)returnType.getJavaType()))));
    }

    public static Object invoke(InvokeLambda function) {
        return function.apply();
    }

    @FunctionalInterface
    public static interface InvokeLambda
    extends LambdaFunctionInterface {
        public Object apply();
    }
}

