/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.google.common.primitives.Ints;
import java.lang.invoke.MethodHandle;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@ScalarFunction(value="array_sort")
@Description(value="Sorts the given array in ascending order according to the natural ordering of its elements.")
public final class ArraySortFunction {
    private ArraySortFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block sort(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"E", "E"}) MethodHandle lessThanFunction, final @TypeParameter(value="E") Type type, final @SqlType(value="array(E)") Block block) {
        int arrayLength = block.getPositionCount();
        if (arrayLength < 2) {
            return block;
        }
        ListOfPositions listOfPositions = new ListOfPositions(block.getPositionCount());
        if (block.mayHaveNull()) {
            listOfPositions.sort(new Comparator<Integer>(){

                @Override
                public int compare(Integer p1, Integer p2) {
                    if (block.isNull(p1.intValue())) {
                        return block.isNull(p2.intValue()) ? 0 : 1;
                    }
                    if (block.isNull(p2.intValue())) {
                        return -1;
                    }
                    try {
                        return type.compareTo(block, p1.intValue(), block, p2.intValue());
                    }
                    catch (NotSupportedException | PrestoException e) {
                        if (e instanceof NotSupportedException || ((PrestoException)e).getErrorCode() == StandardErrorCode.NOT_SUPPORTED.toErrorCode()) {
                            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array contains elements not supported for comparison", e);
                        }
                        throw e;
                    }
                }
            });
        } else {
            listOfPositions.sort(new Comparator<Integer>(){

                @Override
                public int compare(Integer p1, Integer p2) {
                    try {
                        return type.compareTo(block, p1.intValue(), block, p2.intValue());
                    }
                    catch (NotSupportedException | PrestoException e) {
                        if (e instanceof NotSupportedException || ((PrestoException)e).getErrorCode() == StandardErrorCode.NOT_SUPPORTED.toErrorCode()) {
                            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array contains elements not supported for comparison", e);
                        }
                        throw e;
                    }
                }
            });
        }
        List<Integer> sortedListOfPositions = listOfPositions.getSortedListOfPositions();
        if (sortedListOfPositions == listOfPositions) {
            return block;
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(null, arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            type.appendTo(block, sortedListOfPositions.get(i).intValue(), blockBuilder);
        }
        return blockBuilder.build();
    }

    @SqlType(value="array(bigint)")
    public static Block bigintSort(@SqlType(value="array(bigint)") Block array) {
        int i;
        int arrayLength = array.getPositionCount();
        if (arrayLength < 2) {
            return array;
        }
        long[] values = new long[array.getPositionCount()];
        int nulls = 0;
        if (array.mayHaveNull()) {
            int j = 0;
            for (i = 0; i < array.getPositionCount(); ++i) {
                if (array.isNull(i)) {
                    ++nulls;
                    continue;
                }
                values[j++] = BigintType.BIGINT.getLong(array, i);
            }
        } else {
            for (int i2 = 0; i2 < array.getPositionCount(); ++i2) {
                values[i2] = BigintType.BIGINT.getLong(array, i2);
            }
        }
        Arrays.sort(values, 0, values.length - nulls);
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, arrayLength);
        for (i = 0; i < values.length - nulls; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, values[i]);
        }
        for (i = 0; i < nulls; ++i) {
            blockBuilder.appendNull();
        }
        return blockBuilder.build();
    }

    @SqlType(value="array(double)")
    public static Block doubleSort(@SqlType(value="array(double)") Block array) {
        int i;
        int arrayLength = array.getPositionCount();
        if (arrayLength < 2) {
            return array;
        }
        double[] values = new double[array.getPositionCount()];
        int nulls = 0;
        if (array.mayHaveNull()) {
            int j = 0;
            for (i = 0; i < array.getPositionCount(); ++i) {
                if (array.isNull(i)) {
                    ++nulls;
                    continue;
                }
                values[j++] = DoubleType.DOUBLE.getDouble(array, i);
            }
        } else {
            for (int i2 = 0; i2 < array.getPositionCount(); ++i2) {
                values[i2] = DoubleType.DOUBLE.getDouble(array, i2);
            }
        }
        Arrays.sort(values, 0, values.length - nulls);
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, arrayLength);
        for (i = 0; i < values.length - nulls; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, values[i]);
        }
        for (i = 0; i < nulls; ++i) {
            blockBuilder.appendNull();
        }
        return blockBuilder.build();
    }

    @SqlType(value="array(real)")
    public static Block floatSort(@SqlType(value="array(real)") Block array) {
        int i;
        int arrayLength = array.getPositionCount();
        if (arrayLength < 2) {
            return array;
        }
        float[] values = new float[array.getPositionCount()];
        int nulls = 0;
        if (array.mayHaveNull()) {
            int j = 0;
            for (i = 0; i < array.getPositionCount(); ++i) {
                if (array.isNull(i)) {
                    ++nulls;
                    continue;
                }
                values[j++] = Float.intBitsToFloat(array.getInt(i));
            }
        } else {
            for (int i2 = 0; i2 < array.getPositionCount(); ++i2) {
                values[i2] = Float.intBitsToFloat(array.getInt(i2));
            }
        }
        Arrays.sort(values, 0, values.length - nulls);
        BlockBuilder blockBuilder = RealType.REAL.createBlockBuilder(null, arrayLength);
        for (i = 0; i < values.length - nulls; ++i) {
            RealType.REAL.writeLong(blockBuilder, (long)Float.floatToIntBits(values[i]));
        }
        for (i = 0; i < nulls; ++i) {
            blockBuilder.appendNull();
        }
        return blockBuilder.build();
    }

    private static class ListOfPositions
    extends AbstractList<Integer> {
        private final int size;
        private List<Integer> sortedListOfPositions;

        ListOfPositions(int size) {
            this.size = size;
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public final Integer get(int i) {
            return i;
        }

        @Override
        public final Integer set(int index, Integer position) {
            if (index != position) {
                if (this.sortedListOfPositions == null) {
                    this.sortedListOfPositions = Ints.asList((int[])new int[this.size()]);
                    for (int i = 0; i < this.size(); ++i) {
                        this.sortedListOfPositions.set(i, i);
                    }
                }
                this.sortedListOfPositions.set(index, position);
            }
            return position;
        }

        List<Integer> getSortedListOfPositions() {
            return this.sortedListOfPositions == null ? this : this.sortedListOfPositions;
        }
    }
}

