/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountAggregationUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountAndSumState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;

public class NoisyCountAndSumAggregationUtils {
    private NoisyCountAndSumAggregationUtils() {
    }

    public static void updateState(NoisyCountAndSumState state, double value, double noiseScale, Double lower, Double upper, Long randomSeed) {
        NoisyCountAggregationUtils.updateState(state, noiseScale, randomSeed);
        NoisyCountAndSumAggregationUtils.checkLowerUpper(lower, upper);
        double clippedValue = value;
        if (lower != null && upper != null) {
            state.setNullLowerUpper(false);
            state.setLower(lower);
            state.setUpper(upper);
            clippedValue = NoisyCountAndSumAggregationUtils.clip(value, lower, upper);
        }
        state.setSum(state.getSum() + clippedValue);
    }

    public static void combineStates(NoisyCountAndSumState state, NoisyCountAndSumState otherState) {
        NoisyCountAggregationUtils.combineStates(state, otherState);
        if (state.isNullLowerUpper()) {
            state.setNullLowerUpper(otherState.isNullLowerUpper());
            state.setLower(otherState.getLower());
            state.setUpper(otherState.getUpper());
        }
        state.setSum(state.getSum() + otherState.getSum());
    }

    public static void writeNoisySumOutput(NoisyCountAndSumState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
            return;
        }
        double noise = NoisyCountAggregationUtils.getNoise(state);
        double trueSum = state.getSum();
        double noisySum = trueSum + noise;
        DoubleType.DOUBLE.writeDouble(out, noisySum);
    }

    public static void writeNoisyAvgOutput(NoisyCountAndSumState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
            return;
        }
        double noise = NoisyCountAggregationUtils.getNoise(state);
        double trueAvg = state.getSum() / (double)state.getCount();
        double noisyAvg = trueAvg + noise;
        DoubleType.DOUBLE.writeDouble(out, noisyAvg);
    }

    public static double clip(double value, double lower, double upper) {
        return Math.max(lower, Math.min(upper, value));
    }

    public static void checkLowerUpper(Double lower, Double upper) {
        if (lower != null && upper != null) {
            if (upper < lower) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lower must be <= upper");
            }
            return;
        }
        if (lower == null && upper == null) {
            return;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lower and upper should either both null or both non-null");
    }
}

