/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.approxmostfrequent;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.approxmostfrequent.ApproximateMostFrequentState;
import com.facebook.presto.operator.aggregation.approxmostfrequent.ApproximateMostFrequentStateFactory;
import com.facebook.presto.operator.aggregation.approxmostfrequent.ApproximateMostFrequentStateSerializer;
import com.facebook.presto.operator.aggregation.approxmostfrequent.stream.StreamSummary;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class ApproximateMostFrequent
extends SqlAggregationFunction {
    public static final ApproximateMostFrequent APPROXIMATE_MOST_FREQUENT = new ApproximateMostFrequent();
    public static final String NAME = "approx_most_frequent";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(ApproximateMostFrequent.class, "output", ApproximateMostFrequentState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(ApproximateMostFrequent.class, "input", Type.class, ApproximateMostFrequentState.class, Long.TYPE, Block.class, Integer.TYPE, Long.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(ApproximateMostFrequent.class, "combine", ApproximateMostFrequentState.class, ApproximateMostFrequentState.class);
    private static final String MAX_BUCKETS = "max_buckets";
    private static final String CAPACITY = "capacity";
    private static final String KEYS = "keys";
    private static final String VALUES = "values";

    protected ApproximateMostFrequent() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"K")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,bigint)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"bigint"), (Object)TypeSignature.parseTypeSignature((String)"K"), (Object)TypeSignature.parseTypeSignature((String)"bigint")));
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type keyType = boundVariables.getTypeVariable("K");
        Preconditions.checkArgument((boolean)keyType.isComparable(), (Object)"keyType must be comparable");
        Type serializedType = functionAndTypeManager.getParameterizedType("row", (List<TypeSignatureParameter>)ImmutableList.of((Object)this.buildTypeSignatureParameter(MAX_BUCKETS, (Type)BigintType.BIGINT), (Object)this.buildTypeSignatureParameter(CAPACITY, (Type)BigintType.BIGINT), (Object)this.buildTypeSignatureParameter(KEYS, (Type)new ArrayType(keyType)), (Object)this.buildTypeSignatureParameter(VALUES, (Type)new ArrayType((Type)BigintType.BIGINT))));
        Type outputType = functionAndTypeManager.getParameterizedType("map", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)BigintType.BIGINT.getTypeSignature())));
        DynamicClassLoader classLoader = new DynamicClassLoader(ApproximateMostFrequent.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)keyType);
        ApproximateMostFrequentStateSerializer stateSerializer = new ApproximateMostFrequentStateSerializer(keyType, serializedType);
        MethodHandle inputFunction = INPUT_FUNCTION.bindTo(keyType);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), ApproximateMostFrequent.createInputParameterMetadata(keyType), inputFunction, COMBINE_FUNCTION, OUTPUT_FUNCTION, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(ApproximateMostFrequentState.class, (AccumulatorStateSerializer)stateSerializer, (AccumulatorStateFactory)new ApproximateMostFrequentStateFactory())), outputType);
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)serializedType), outputType, true, false, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    private TypeSignatureParameter buildTypeSignatureParameter(String fieldName, Type type) {
        return TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName(fieldName, false)), type.getTypeSignature()));
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type keyType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Type)BigintType.BIGINT), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, keyType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Type)BigintType.BIGINT));
    }

    public String getDescription() {
        return "Computes the top frequent elements approximately";
    }

    public static void input(Type type, ApproximateMostFrequentState state, long buckets, Block valueBlock, int valueIndex, long capacity) {
        StreamSummary streamSummary = state.getStateSummary();
        if (streamSummary == null) {
            Failures.checkCondition(buckets > 1L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "approx_most_frequent bucket count must be greater than one, input bucket count: %s", buckets);
            streamSummary = new StreamSummary(type, Math.toIntExact(buckets), Math.toIntExact(capacity));
            state.setStateSummary(streamSummary);
        }
        streamSummary.add(valueBlock, valueIndex, 1L);
    }

    public static void combine(ApproximateMostFrequentState state, ApproximateMostFrequentState otherState) {
        StreamSummary streamSummary = state.getStateSummary();
        if (streamSummary == null) {
            state.setStateSummary(otherState.getStateSummary());
        } else {
            streamSummary.merge(otherState.getStateSummary());
        }
    }

    public static void output(ApproximateMostFrequentState state, BlockBuilder out) {
        if (state.getStateSummary() == null) {
            out.appendNull();
        } else {
            state.getStateSummary().topK(out);
        }
    }
}

