/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class BuiltInAggregationFunctionImplementation
implements JavaAggregationFunctionImplementation {
    private final String name;
    private final List<Type> parameterTypes;
    private final List<Type> intermediateType;
    private final Type finalType;
    private final List<Class> lambdaInterfaces;
    private final boolean decomposable;
    private final boolean orderSensitive;
    private final AggregationMetadata aggregationMetadata;
    private final Class<? extends Accumulator> accumulatorClass;
    private final Class<? extends GroupedAccumulator> groupedAccumulatorClass;

    public BuiltInAggregationFunctionImplementation(String name, List<Type> parameterTypes, List<Type> intermediateType, Type finalType, boolean decomposable, boolean orderSensitive, AggregationMetadata aggregationMetadata, Class<? extends Accumulator> accumulatorClass, Class<? extends GroupedAccumulator> groupedAccumulatorClass) {
        this(name, parameterTypes, intermediateType, finalType, decomposable, orderSensitive, aggregationMetadata, accumulatorClass, groupedAccumulatorClass, (List<Class>)ImmutableList.of());
    }

    public BuiltInAggregationFunctionImplementation(String name, List<Type> parameterTypes, List<Type> intermediateType, Type finalType, boolean decomposable, boolean orderSensitive, AggregationMetadata aggregationMetadata, Class<? extends Accumulator> accumulatorClass, Class<? extends GroupedAccumulator> groupedAccumulatorClass, List<Class> lambdaInterfaces) {
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
        this.parameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
        this.intermediateType = Objects.requireNonNull(intermediateType, "intermediateType is null");
        this.finalType = Objects.requireNonNull(finalType, "finalType is null");
        this.decomposable = decomposable;
        this.orderSensitive = orderSensitive;
        this.aggregationMetadata = aggregationMetadata;
        this.accumulatorClass = accumulatorClass;
        this.groupedAccumulatorClass = groupedAccumulatorClass;
        this.lambdaInterfaces = ImmutableList.copyOf(lambdaInterfaces);
    }

    public String name() {
        return this.name;
    }

    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getFinalType() {
        return this.finalType;
    }

    public Type getIntermediateType() {
        if (this.intermediateType.size() == 1) {
            return (Type)Iterables.getOnlyElement(this.intermediateType);
        }
        return RowType.withDefaultFieldNames(this.intermediateType);
    }

    public List<Class> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    public boolean isDecomposable() {
        return this.decomposable;
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public AggregationMetadata getAggregationMetadata() {
        return this.aggregationMetadata;
    }

    public Class<? extends Accumulator> getAccumulatorClass() {
        return this.accumulatorClass;
    }

    public Class<? extends GroupedAccumulator> getGroupedAccumulatorClass() {
        return this.groupedAccumulatorClass;
    }
}

