/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupedTopNBuilder;
import com.facebook.presto.operator.InMemoryGroupedTopNBuilder;
import com.facebook.presto.operator.NoChannelGroupByHash;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.SimplePageWithPositionComparator;
import com.facebook.presto.operator.SpillableGroupedTopNBuilder;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class TopNRowNumberOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final int[] outputChannels;
    private GroupedTopNBuilder groupedTopNBuilder;
    private boolean finishing;
    private boolean finished;
    private Work<?> unfinishedWork;
    private WorkProcessor<Page> outputPages;

    public TopNRowNumberOperator(OperatorContext operatorContext, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<Type> partitionTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, int maxRowCountPerPartition, boolean generateRowNumber, Optional<Integer> hashChannel, int expectedPositions, long unspillMemoryLimit, JoinCompiler joinCompiler, SpillerFactory spillerFactory, boolean spillEnabled) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        ImmutableList.Builder outputChannelsBuilder = ImmutableList.builder();
        for (int channel : Objects.requireNonNull(outputChannels, "outputChannels is null")) {
            outputChannelsBuilder.add((Object)channel);
        }
        if (generateRowNumber) {
            outputChannelsBuilder.add((Object)outputChannels.size());
        }
        this.outputChannels = Ints.toArray((Collection)outputChannelsBuilder.build());
        Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
        List<Type> types = TopNRowNumberOperator.toTypes(sourceTypes, outputChannels, generateRowNumber);
        Supplier<GroupByHash> groupByHashSupplier = () -> this.createGroupByHash(partitionTypes, partitionChannels, hashChannel, expectedPositions, joinCompiler, SystemSessionProperties.isDictionaryAggregationEnabled(operatorContext.getSession()), this::updateMemoryReservation);
        this.groupedTopNBuilder = spillEnabled ? new SpillableGroupedTopNBuilder((List<Type>)ImmutableList.copyOf(sourceTypes), partitionTypes, partitionChannels, () -> new InMemoryGroupedTopNBuilder((List<Type>)ImmutableList.copyOf((Collection)sourceTypes), new SimplePageWithPositionComparator(types, sortChannels, sortOrders), maxRowCountPerPartition, generateRowNumber, operatorContext.localRevocableMemoryContext(), (GroupByHash)groupByHashSupplier.get()), () -> new InMemoryGroupedTopNBuilder((List<Type>)ImmutableList.copyOf((Collection)sourceTypes), new SimplePageWithPositionComparator(types, sortChannels, sortOrders), maxRowCountPerPartition, generateRowNumber, operatorContext.localUserMemoryContext(), (GroupByHash)groupByHashSupplier.get()), operatorContext::isWaitingForMemory, unspillMemoryLimit, operatorContext.localUserMemoryContext(), operatorContext.localRevocableMemoryContext(), operatorContext.aggregateSystemMemoryContext(), operatorContext.aggregateSystemMemoryContext(), operatorContext.getSpillContext(), operatorContext.getDriverContext().getYieldSignal(), spillerFactory) : new InMemoryGroupedTopNBuilder((List<Type>)ImmutableList.copyOf(sourceTypes), new SimplePageWithPositionComparator(types, sortChannels, sortOrders), maxRowCountPerPartition, generateRowNumber, operatorContext.localUserMemoryContext(), groupByHashSupplier.get());
    }

    private GroupByHash createGroupByHash(List<? extends Type> partitionTypes, List<Integer> partitionChannels, Optional<Integer> inputHashChannel, int expectedPositions, JoinCompiler joinCompiler, boolean isDictionaryAggregationEnabled, UpdateMemory updateMemory) {
        if (!partitionChannels.isEmpty()) {
            Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions must be > 0");
            return GroupByHash.createGroupByHash(partitionTypes, Ints.toArray(partitionChannels), inputHashChannel, expectedPositions, isDictionaryAggregationEnabled, joinCompiler, updateMemory);
        }
        return new NoChannelGroupByHash();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputPages == null && this.unfinishedWork == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkState((this.unfinishedWork == null ? 1 : 0) != 0, (Object)"Cannot add input with the operator when unfinished work is not empty");
        Preconditions.checkState((this.outputPages == null ? 1 : 0) != 0, (Object)"Cannot add input with the operator when flushing");
        Objects.requireNonNull(page, "page is null");
        this.unfinishedWork = this.groupedTopNBuilder.processPage(page);
        if (this.unfinishedWork.process()) {
            this.unfinishedWork = null;
        }
        this.updateMemoryReservation();
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        if (this.finishing) {
            return NOT_BLOCKED;
        }
        return this.groupedTopNBuilder.startMemoryRevoke();
    }

    @Override
    public void finishMemoryRevoke() {
        this.groupedTopNBuilder.finishMemoryRevoke();
    }

    @Override
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        if (this.unfinishedWork != null) {
            boolean finished = this.unfinishedWork.process();
            this.updateMemoryReservation();
            if (!finished) {
                return null;
            }
            this.unfinishedWork = null;
        }
        if (!this.finishing) {
            return null;
        }
        if (this.outputPages == null) {
            if (this.groupedTopNBuilder == null) {
                this.finished = true;
                return null;
            }
            this.outputPages = this.groupedTopNBuilder.buildResult();
        }
        if (!this.outputPages.process()) {
            return null;
        }
        if (this.outputPages.isFinished()) {
            if (this.groupedTopNBuilder != null) {
                this.groupedTopNBuilder.close();
                this.groupedTopNBuilder = null;
            }
            this.finished = true;
            return null;
        }
        Page outputPage = this.outputPages.getResult().extractChannels(this.outputChannels);
        this.updateMemoryReservation();
        return outputPage;
    }

    @VisibleForTesting
    public int getCapacity() {
        GroupByHash groupByHash = this.groupedTopNBuilder.getGroupByHash();
        Preconditions.checkState((groupByHash != null ? 1 : 0) != 0);
        return groupByHash.getCapacity();
    }

    private boolean updateMemoryReservation() {
        this.groupedTopNBuilder.updateMemoryReservations();
        return this.operatorContext.isWaitingForMemory().isDone();
    }

    private static List<Type> toTypes(List<? extends Type> sourceTypes, List<Integer> outputChannels, boolean generateRowNumber) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (int channel : outputChannels) {
            types.add((Object)sourceTypes.get(channel));
        }
        if (generateRowNumber) {
            types.add((Object)BigintType.BIGINT);
        }
        return types.build();
    }

    public static class TopNRowNumberOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<Integer> partitionChannels;
        private final List<Type> partitionTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final int maxRowCountPerPartition;
        private final boolean partial;
        private final Optional<Integer> hashChannel;
        private final int expectedPositions;
        private final boolean generateRowNumber;
        private boolean closed;
        private final long unspillMemoryLimit;
        private final JoinCompiler joinCompiler;
        private final SpillerFactory spillerFactory;
        private final boolean spillEnabled;

        public TopNRowNumberOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<? extends Type> partitionTypes, List<Integer> sortChannels, List<SortOrder> sortOrder, int maxRowCountPerPartition, boolean partial, Optional<Integer> hashChannel, int expectedPositions, long unspillMemoryLimit, JoinCompiler joinCompiler, SpillerFactory spillerFactory, boolean spillEnabled) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
            this.partitionTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionTypes, "partitionTypes is null"));
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels));
            this.sortOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrder));
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.partial = partial;
            Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
            this.maxRowCountPerPartition = maxRowCountPerPartition;
            Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions must be > 0");
            this.generateRowNumber = !partial;
            this.expectedPositions = expectedPositions;
            this.unspillMemoryLimit = unspillMemoryLimit;
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            this.spillerFactory = spillerFactory;
            this.spillEnabled = spillEnabled;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TopNRowNumberOperator.class.getSimpleName());
            return new TopNRowNumberOperator(operatorContext, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.sortChannels, this.sortOrder, this.maxRowCountPerPartition, this.generateRowNumber, this.hashChannel, this.expectedPositions, this.unspillMemoryLimit, this.joinCompiler, this.spillerFactory, this.spillEnabled);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TopNRowNumberOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.sortChannels, this.sortOrder, this.maxRowCountPerPartition, this.partial, this.hashChannel, this.expectedPositions, this.unspillMemoryLimit, this.joinCompiler, this.spillerFactory, this.spillEnabled);
        }
    }
}

