/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesIndexComparator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Throwables;
import java.util.Objects;

public class SimpleChannelComparator
implements PagesIndexComparator {
    private final int leftChannel;
    private final int rightChannel;
    private final SortOrder sortOrder;
    private final Type sortType;

    public SimpleChannelComparator(int leftChannel, int rightChannel, Type sortType, SortOrder sortOrder) {
        this.leftChannel = leftChannel;
        this.rightChannel = rightChannel;
        this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null");
        this.sortType = Objects.requireNonNull(sortType, "sortType is null.");
    }

    @Override
    public int compareTo(PagesIndex pagesIndex, int leftPosition, int rightPosition) {
        long leftPageAddress = pagesIndex.getValueAddresses().get(leftPosition);
        int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
        int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
        long rightPageAddress = pagesIndex.getValueAddresses().get(rightPosition);
        int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
        int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
        try {
            Block leftBlock = (Block)pagesIndex.getChannel(this.leftChannel).get(leftBlockIndex);
            Block rightBlock = (Block)pagesIndex.getChannel(this.rightChannel).get(rightBlockIndex);
            int result = this.sortOrder.compareBlockValue(this.sortType, leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
            return this.sortOrder.isAscending() ? result : -result;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
        }
    }
}

