/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ReferenceCount {
    private final SettableFuture<Void> freeFuture = SettableFuture.create();
    @GuardedBy(value="this")
    private int count;

    public ReferenceCount(int initialCount) {
        Preconditions.checkArgument((initialCount >= 0 ? 1 : 0) != 0, (String)"initialCount must not be negative, got %s", (int)initialCount);
        this.count = initialCount;
        if (initialCount == 0) {
            this.freeFuture.set(null);
        }
    }

    public ListenableFuture<Void> getFreeFuture() {
        return this.freeFuture;
    }

    public synchronized void retain() {
        Preconditions.checkState((!this.freeFuture.isDone() ? 1 : 0) != 0, (Object)"Reference has already been freed");
        ++this.count;
    }

    public synchronized void release() {
        Preconditions.checkState((!this.freeFuture.isDone() ? 1 : 0) != 0, (Object)"Reference has already been freed");
        --this.count;
        if (this.count == 0) {
            this.freeFuture.set(null);
        }
    }
}

