/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@ThriftStruct
@Immutable
public class DriverStats {
    private final Lifespan lifespan;
    private final DateTime createTime;
    private final DateTime startTime;
    private final DateTime endTime;
    private final Duration queuedTime;
    private final Duration elapsedTime;
    private final DataSize userMemoryReservation;
    private final DataSize revocableMemoryReservation;
    private final DataSize systemMemoryReservation;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize totalAllocation;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final Duration rawInputReadTime;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final DataSize physicalWrittenDataSize;
    private final List<OperatorStats> operatorStats;

    public DriverStats() {
        this.lifespan = null;
        this.createTime = DateTime.now();
        this.startTime = null;
        this.endTime = null;
        this.queuedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.elapsedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.userMemoryReservation = new DataSize(0.0, DataSize.Unit.BYTE);
        this.revocableMemoryReservation = new DataSize(0.0, DataSize.Unit.BYTE);
        this.systemMemoryReservation = new DataSize(0.0, DataSize.Unit.BYTE);
        this.totalScheduledTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.totalCpuTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.totalBlockedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.fullyBlocked = false;
        this.blockedReasons = ImmutableSet.of();
        this.totalAllocation = new DataSize(0.0, DataSize.Unit.BYTE);
        this.rawInputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
        this.rawInputPositions = 0L;
        this.rawInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.processedInputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
        this.processedInputPositions = 0L;
        this.outputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
        this.outputPositions = 0L;
        this.physicalWrittenDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
        this.operatorStats = ImmutableList.of();
    }

    @JsonCreator
    @ThriftConstructor
    public DriverStats(@JsonProperty(value="lifespan") Lifespan lifespan, @JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="startTime") DateTime startTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="revocableMemoryReservation") DataSize revocableMemoryReservation, @JsonProperty(value="systemMemoryReservation") DataSize systemMemoryReservation, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="totalAllocation") DataSize totalAllocation, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="rawInputReadTime") Duration rawInputReadTime, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="operatorStats") List<OperatorStats> operatorStats) {
        this.lifespan = lifespan;
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.startTime = startTime;
        this.endTime = endTime;
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.revocableMemoryReservation = Objects.requireNonNull(revocableMemoryReservation, "revocableMemoryReservation is null");
        this.systemMemoryReservation = Objects.requireNonNull(systemMemoryReservation, "systemMemoryReservation is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.totalAllocation = Objects.requireNonNull(totalAllocation, "totalAllocation is null");
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.rawInputReadTime = Objects.requireNonNull(rawInputReadTime, "rawInputReadTime is null");
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "writtenDataSize is null");
        this.operatorStats = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorStats, "operatorStats is null"));
    }

    @JsonProperty
    @ThriftField(value=1)
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    @JsonProperty
    @ThriftField(value=2)
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @Nullable
    @JsonProperty
    @ThriftField(value=3)
    public DateTime getStartTime() {
        return this.startTime;
    }

    @Nullable
    @JsonProperty
    @ThriftField(value=4)
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    @ThriftField(value=5)
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    @ThriftField(value=6)
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    @ThriftField(value=7)
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    @ThriftField(value=8)
    public DataSize getRevocableMemoryReservation() {
        return this.revocableMemoryReservation;
    }

    @JsonProperty
    @ThriftField(value=9)
    public DataSize getSystemMemoryReservation() {
        return this.systemMemoryReservation;
    }

    @JsonProperty
    @ThriftField(value=10)
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    @ThriftField(value=11)
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    @ThriftField(value=12)
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    @ThriftField(value=13)
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    @ThriftField(value=14)
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    @ThriftField(value=15)
    public DataSize getTotalAllocation() {
        return this.totalAllocation;
    }

    @JsonProperty
    @ThriftField(value=16)
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    @ThriftField(value=17)
    public Duration getRawInputReadTime() {
        return this.rawInputReadTime;
    }

    @JsonProperty
    @ThriftField(value=18)
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    @ThriftField(value=19)
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    @ThriftField(value=20)
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    @ThriftField(value=21)
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    @ThriftField(value=22)
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    @ThriftField(value=23)
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    @ThriftField(value=24)
    public List<OperatorStats> getOperatorStats() {
        return this.operatorStats;
    }
}

