/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Work;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ChannelSet {
    private final GroupByHash hash;
    private final boolean containsNull;
    private final int[] hashChannels;

    public ChannelSet(GroupByHash hash, boolean containsNull, int[] hashChannels) {
        this.hash = hash;
        this.containsNull = containsNull;
        this.hashChannels = hashChannels;
    }

    public Type getType() {
        return this.hash.getTypes().get(0);
    }

    public long getEstimatedSizeInBytes() {
        return this.hash.getEstimatedSize();
    }

    public int size() {
        return this.hash.getGroupCount();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public boolean contains(int position, Page page) {
        return this.hash.contains(position, page, this.hashChannels);
    }

    public boolean contains(int position, Page page, long rawHash) {
        return this.hash.contains(position, page, this.hashChannels, rawHash);
    }

    public static class ChannelSetBuilder {
        private static final int[] HASH_CHANNELS = new int[]{0};
        private final GroupByHash hash;
        private final Page nullBlockPage;
        private final OperatorContext operatorContext;
        private final LocalMemoryContext localMemoryContext;

        public ChannelSetBuilder(Type type, Optional<Integer> hashChannel, int expectedPositions, OperatorContext operatorContext, JoinCompiler joinCompiler) {
            ImmutableList types = ImmutableList.of((Object)type);
            this.hash = GroupByHash.createGroupByHash((List<? extends Type>)types, HASH_CHANNELS, hashChannel, expectedPositions, SystemSessionProperties.isDictionaryAggregationEnabled(operatorContext.getSession()), joinCompiler, this::updateMemoryReservation);
            this.nullBlockPage = new Page(new Block[]{type.createBlockBuilder(null, 1, UnknownType.UNKNOWN.getFixedSize()).appendNull().build()});
            this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
            this.localMemoryContext = operatorContext.localUserMemoryContext();
        }

        public ChannelSet build() {
            return new ChannelSet(this.hash, this.hash.contains(0, this.nullBlockPage, HASH_CHANNELS), HASH_CHANNELS);
        }

        public long getEstimatedSize() {
            return this.hash.getEstimatedSize();
        }

        public int size() {
            return this.hash.getGroupCount();
        }

        public Work<?> addPage(Page page) {
            return this.hash.addPage(page);
        }

        public boolean updateMemoryReservation() {
            this.localMemoryContext.setBytes(this.hash.getEstimatedSize());
            return this.operatorContext.isWaitingForMemory().isDone();
        }

        @VisibleForTesting
        public int getCapacity() {
            return this.hash.getCapacity();
        }
    }
}

