/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TableLayout {
    private final ConnectorId connectorId;
    private final ConnectorTableHandle connectorTableHandle;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorTableLayout layout;

    public TableLayout(ConnectorId connectorId, ConnectorTableHandle connectorTableHandle, ConnectorTransactionHandle transactionHandle, ConnectorTableLayout layout) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(connectorTableHandle, "connectorTableHandle is null");
        Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        Objects.requireNonNull(layout, "layout is null");
        this.connectorTableHandle = connectorTableHandle;
        this.connectorId = connectorId;
        this.transactionHandle = transactionHandle;
        this.layout = layout;
    }

    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    public Optional<List<ColumnHandle>> getColumns() {
        return this.layout.getColumns();
    }

    public TupleDomain<ColumnHandle> getPredicate() {
        return this.layout.getPredicate();
    }

    public Optional<RowExpression> getRemainingPredicate() {
        return this.layout.getRemainingPredicate();
    }

    public List<LocalProperty<ColumnHandle>> getLocalProperties() {
        return this.layout.getLocalProperties();
    }

    public ConnectorTableLayoutHandle getLayoutHandle() {
        return this.layout.getHandle();
    }

    public TableHandle getNewTableHandle() {
        return new TableHandle(this.connectorId, this.connectorTableHandle, this.transactionHandle, Optional.of(this.layout.getHandle()));
    }

    public Optional<TablePartitioning> getTablePartitioning() {
        return this.layout.getTablePartitioning().map(nodePartitioning -> new TablePartitioning(new PartitioningHandle(Optional.of(this.connectorId), Optional.of(this.transactionHandle), nodePartitioning.getPartitioningHandle()), nodePartitioning.getPartitioningColumns()));
    }

    public Optional<Set<ColumnHandle>> getStreamPartitioningColumns() {
        return this.layout.getStreamPartitioningColumns();
    }

    public Optional<DiscretePredicates> getDiscretePredicates() {
        return this.layout.getDiscretePredicates();
    }

    public static TableLayout fromConnectorLayout(ConnectorId connectorId, ConnectorTableHandle connectorTableHandle, ConnectorTransactionHandle transactionHandle, ConnectorTableLayout layout) {
        return new TableLayout(connectorId, connectorTableHandle, transactionHandle, layout);
    }

    public static class TablePartitioning {
        private final PartitioningHandle partitioningHandle;
        private final List<ColumnHandle> partitioningColumns;

        public TablePartitioning(PartitioningHandle partitioningHandle, List<ColumnHandle> partitioningColumns) {
            this.partitioningHandle = Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
            this.partitioningColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitioningColumns, "partitioningColumns is null"));
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle;
        }

        public List<ColumnHandle> getPartitioningColumns() {
            return this.partitioningColumns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TablePartitioning that = (TablePartitioning)o;
            return Objects.equals(this.partitioningHandle, that.partitioningHandle) && Objects.equals(this.partitioningColumns, that.partitioningColumns);
        }

        public int hashCode() {
            return Objects.hash(this.partitioningHandle, this.partitioningColumns);
        }
    }
}

