/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.geospatial.aggregation.GeometryState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.GroupedAccumulatorState;

public class GeometryStateFactory
implements AccumulatorStateFactory<GeometryState> {
    public GeometryState createSingleState() {
        return new SingleGeometryState();
    }

    public Class<? extends GeometryState> getSingleStateClass() {
        return SingleGeometryState.class;
    }

    public GeometryState createGroupedState() {
        return new GroupedGeometryState();
    }

    public Class<? extends GeometryState> getGroupedStateClass() {
        return GroupedGeometryState.class;
    }

    public static class SingleGeometryState
    implements GeometryState {
        private OGCGeometry geometry;

        @Override
        public OGCGeometry getGeometry() {
            return this.geometry;
        }

        @Override
        public void setGeometry(OGCGeometry geometry, long previousMemorySize) {
            this.geometry = geometry;
        }

        public long getEstimatedSize() {
            return this.geometry != null ? this.geometry.estimateMemorySize() : 0L;
        }
    }

    public static class GroupedGeometryState
    implements GeometryState,
    GroupedAccumulatorState {
        private long groupId;
        private ObjectBigArray<OGCGeometry> geometries = new ObjectBigArray();
        private long size;

        @Override
        public OGCGeometry getGeometry() {
            return (OGCGeometry)this.geometries.get(this.groupId);
        }

        @Override
        public void setGeometry(OGCGeometry geometry, long previousMemorySize) {
            this.geometries.set(this.groupId, (Object)geometry);
            this.size -= previousMemorySize;
            if (geometry != null) {
                this.size += geometry.estimateMemorySize();
            }
        }

        public void ensureCapacity(long size) {
            this.geometries.ensureCapacity(size);
        }

        public long getEstimatedSize() {
            return this.size + this.geometries.sizeOf();
        }

        public final void setGroupId(long groupId) {
            this.groupId = groupId;
        }
    }
}

