/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.esri.core.geometry.Envelope;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.geospatial.KdbTree;
import com.facebook.presto.geospatial.KdbTreeUtils;
import com.facebook.presto.geospatial.Rectangle;
import com.facebook.presto.geospatial.SpatialPartitioningState;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

@AggregationFunction(value="spatial_partitioning", decomposable=false, visibility=SqlFunctionVisibility.HIDDEN)
public class SpatialPartitioningInternalAggregateFunction {
    private static final int MAX_SAMPLE_COUNT = 1000000;

    private SpatialPartitioningInternalAggregateFunction() {
    }

    @InputFunction
    public static void input(SpatialPartitioningState state, @SqlType(value="Geometry") Slice slice, @SqlType(value="integer") long partitionCount) {
        Envelope envelope = EsriGeometrySerde.deserializeEnvelope((Slice)slice);
        if (envelope.isEmpty()) {
            return;
        }
        if (state.getCount() == 0L) {
            state.setPartitionCount(Math.toIntExact(partitionCount));
            state.setSamples(new ArrayList<Rectangle>());
        }
        Rectangle extent = new Rectangle(envelope.getXMin(), envelope.getYMin(), envelope.getXMax(), envelope.getYMax());
        List<Rectangle> samples = state.getSamples();
        if (samples.size() <= 1000000) {
            samples.add(extent);
        } else {
            long sampleIndex = ThreadLocalRandom.current().nextLong(state.getCount());
            if (sampleIndex < 1000000L) {
                samples.set(Math.toIntExact(sampleIndex), extent);
            }
        }
        state.setCount(state.getCount() + 1L);
    }

    @CombineFunction
    public static void combine(SpatialPartitioningState state, SpatialPartitioningState otherState) {
        throw new UnsupportedOperationException("spatial_partitioning must run on a single node");
    }

    @OutputFunction(value="varchar")
    public static void output(SpatialPartitioningState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "No rows supplied to spatial partition.");
        }
        List<Rectangle> samples = state.getSamples();
        int partitionCount = state.getPartitionCount();
        int maxItemsPerNode = (samples.size() + partitionCount - 1) / partitionCount;
        VarcharType.VARCHAR.writeString(out, KdbTreeUtils.toJson((KdbTree)KdbTree.buildKdbTree((int)maxItemsPerNode, samples)));
    }
}

