/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.airlift.configuration.LegacyConfig;
import com.facebook.presto.execution.scheduler.NodeSelectionHashStrategy;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"node-scheduler.location-aware-scheduling-enabled", "node-scheduler.multiple-tasks-per-node-enabled"})
public class NodeSchedulerConfig {
    private int minCandidates = 10;
    private boolean includeCoordinator = true;
    private int maxSplitsPerNode = 100;
    private int maxPendingSplitsPerTask = 10;
    private int maxUnacknowledgedSplitsPerTask = 500;
    private String networkTopology = "legacy";
    private NodeSelectionHashStrategy nodeSelectionHashStrategy = NodeSelectionHashStrategy.MODULAR_HASHING;
    private int minVirtualNodeCount = 1000;
    private ResourceAwareSchedulingStrategy resourceAwareSchedulingStrategy = ResourceAwareSchedulingStrategy.RANDOM;

    @NotNull
    public String getNetworkTopology() {
        return this.networkTopology;
    }

    @Config(value="node-scheduler.network-topology")
    public NodeSchedulerConfig setNetworkTopology(String networkTopology) {
        this.networkTopology = networkTopology;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinCandidates() {
        return this.minCandidates;
    }

    @Config(value="node-scheduler.min-candidates")
    public NodeSchedulerConfig setMinCandidates(int candidates) {
        this.minCandidates = candidates;
        return this;
    }

    public boolean isIncludeCoordinator() {
        return this.includeCoordinator;
    }

    @Config(value="node-scheduler.include-coordinator")
    public NodeSchedulerConfig setIncludeCoordinator(boolean includeCoordinator) {
        this.includeCoordinator = includeCoordinator;
        return this;
    }

    @Config(value="node-scheduler.max-pending-splits-per-task")
    @LegacyConfig(value={"node-scheduler.max-pending-splits-per-node-per-task", "node-scheduler.max-pending-splits-per-node-per-stage"})
    @ConfigDescription(value="The number of splits weighted at the standard split weight that can be assigned and queued for each task")
    public NodeSchedulerConfig setMaxPendingSplitsPerTask(int maxPendingSplitsPerTask) {
        this.maxPendingSplitsPerTask = maxPendingSplitsPerTask;
        return this;
    }

    public int getMaxPendingSplitsPerTask() {
        return this.maxPendingSplitsPerTask;
    }

    public int getMaxSplitsPerNode() {
        return this.maxSplitsPerNode;
    }

    @Config(value="node-scheduler.max-splits-per-node")
    @ConfigDescription(value="The number of splits weighted at the standard split weight that are allowed to be scheduled on each node")
    public NodeSchedulerConfig setMaxSplitsPerNode(int maxSplitsPerNode) {
        this.maxSplitsPerNode = maxSplitsPerNode;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxUnacknowledgedSplitsPerTask() {
        return this.maxUnacknowledgedSplitsPerTask;
    }

    @Config(value="node-scheduler.max-unacknowledged-splits-per-task")
    @ConfigDescription(value="Maximum number of leaf splits not yet delivered to a given task")
    public NodeSchedulerConfig setMaxUnacknowledgedSplitsPerTask(int maxUnacknowledgedSplitsPerTask) {
        this.maxUnacknowledgedSplitsPerTask = maxUnacknowledgedSplitsPerTask;
        return this;
    }

    public NodeSelectionHashStrategy getNodeSelectionHashStrategy() {
        return this.nodeSelectionHashStrategy;
    }

    @Config(value="node-scheduler.node-selection-hash-strategy")
    @ConfigDescription(value="Hashing strategy used for node selection when scheduling splits to nodes. Options are MODULAR_HASHING, CONSISTENT_HASHING")
    public NodeSchedulerConfig setNodeSelectionHashStrategy(NodeSelectionHashStrategy nodeSelectionHashStrategy) {
        this.nodeSelectionHashStrategy = nodeSelectionHashStrategy;
        return this;
    }

    public int getMinVirtualNodeCount() {
        return this.minVirtualNodeCount;
    }

    @Config(value="node-scheduler.consistent-hashing-min-virtual-node-count")
    @ConfigDescription(value="When CONSISTENT_HASHING node selection hash strategy is used, the minimum number of virtual node count. Default 1000. The actual virtual node count is guaranteed to be larger than this number. When number is smaller than physical node count, physical node is used, otherwise the smallest multiplier of physical node count that is greater than this value is used.")
    public NodeSchedulerConfig setMinVirtualNodeCount(int minVirtualNodeCount) {
        this.minVirtualNodeCount = minVirtualNodeCount;
        return this;
    }

    public ResourceAwareSchedulingStrategy getResourceAwareSchedulingStrategy() {
        return this.resourceAwareSchedulingStrategy;
    }

    @Config(value="experimental.resource-aware-scheduling-strategy")
    public NodeSchedulerConfig setResourceAwareSchedulingStrategy(ResourceAwareSchedulingStrategy resourceAwareSchedulingStrategy) {
        this.resourceAwareSchedulingStrategy = resourceAwareSchedulingStrategy;
        return this;
    }

    public static enum ResourceAwareSchedulingStrategy {
        RANDOM,
        TTL;

    }

    public static class NetworkTopologyType {
        public static final String LEGACY = "legacy";
        public static final String FLAT = "flat";
        public static final String BENCHMARK = "benchmark";
    }
}

