/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerContext;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerFactory;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.spi.resourceGroups.SelectionCriteria;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LegacyResourceGroupConfigurationManager
implements ResourceGroupConfigurationManager<VoidContext> {
    public static final String NAME = "legacy";
    public static final String HARD_CONCURRENCY_LIMIT = "hard_concurrency_limit";
    public static final String MAX_QUEUED_QUERIES = "max_queued_queries";
    private static final ResourceGroupId GLOBAL = new ResourceGroupId("global");
    private final int hardConcurrencyLimit;
    private final int maxQueued;

    public LegacyResourceGroupConfigurationManager(int hardConcurrencyLimit, int maxQueued) {
        Preconditions.checkArgument((hardConcurrencyLimit > 0 ? 1 : 0) != 0, (Object)"hardConcurrencyLimit must be greater than 0");
        Preconditions.checkArgument((maxQueued > 0 ? 1 : 0) != 0, (Object)"maxQueued must be greater than 0");
        this.hardConcurrencyLimit = hardConcurrencyLimit;
        this.maxQueued = maxQueued;
    }

    public void configure(ResourceGroup group, SelectionContext<VoidContext> criteria) {
        Preconditions.checkArgument((boolean)group.getId().equals((Object)GLOBAL), (String)"Unexpected resource group: %s", (Object)group.getId());
        group.setMaxQueuedQueries(this.maxQueued);
        group.setHardConcurrencyLimit(this.hardConcurrencyLimit);
    }

    public Optional<SelectionContext<VoidContext>> match(SelectionCriteria criteria) {
        return Optional.of(new SelectionContext(GLOBAL, (Object)VoidContext.NONE));
    }

    public static class Factory
    implements ResourceGroupConfigurationManagerFactory {
        public String getName() {
            return LegacyResourceGroupConfigurationManager.NAME;
        }

        public ResourceGroupConfigurationManager<?> create(Map<String, String> config, ResourceGroupConfigurationManagerContext context) {
            String hardConcurrencyLimitString = Objects.requireNonNull(config.get(LegacyResourceGroupConfigurationManager.HARD_CONCURRENCY_LIMIT), "LegacyResourceGroupConfigurationManager must have config hard_concurrency_liimt");
            int hardConcurrencyLimit = Integer.parseInt(hardConcurrencyLimitString);
            String maxQueuedString = Objects.requireNonNull(config.get(LegacyResourceGroupConfigurationManager.MAX_QUEUED_QUERIES), "LegacyResourceGroupConfigurationManager must have config max_queued_queries");
            int maxQueued = Integer.parseInt(maxQueuedString);
            return new LegacyResourceGroupConfigurationManager(hardConcurrencyLimit, maxQueued);
        }
    }

    static enum VoidContext {
        NONE;

    }
}

