/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.spi.QueryId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

@ThriftStruct
public class TaskId {
    private final StageExecutionId stageExecutionId;
    private final int id;
    private final int attemptNumber;

    @JsonCreator
    public static TaskId valueOf(String taskId) {
        List parts = QueryId.parseDottedId((String)taskId, (int)5, (String)"taskId");
        return new TaskId((String)parts.get(0), Integer.parseInt((String)parts.get(1)), Integer.parseInt((String)parts.get(2)), Integer.parseInt((String)parts.get(3)), Integer.parseInt((String)parts.get(4)));
    }

    public TaskId(String queryId, int stageId, int stageExecutionId, int id, int attemptNumber) {
        this(new StageExecutionId(new StageId(new QueryId(queryId), stageId), stageExecutionId), id, attemptNumber);
    }

    @ThriftConstructor
    public TaskId(StageExecutionId stageExecutionId, int id, int attemptNumber) {
        this.stageExecutionId = Objects.requireNonNull(stageExecutionId, "stageExecutionId");
        this.attemptNumber = attemptNumber;
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id is negative");
        this.id = id;
    }

    @ThriftField(value=1)
    public StageExecutionId getStageExecutionId() {
        return this.stageExecutionId;
    }

    @ThriftField(value=2)
    public int getId() {
        return this.id;
    }

    @ThriftField(value=3)
    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public QueryId getQueryId() {
        return this.stageExecutionId.getStageId().getQueryId();
    }

    @JsonValue
    public String toString() {
        return this.stageExecutionId + "." + this.id + "." + this.attemptNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskId taskId = (TaskId)o;
        return this.attemptNumber == taskId.attemptNumber && this.id == taskId.id && Objects.equals(this.stageExecutionId, taskId.stageExecutionId);
    }

    public int hashCode() {
        return Objects.hash(this.stageExecutionId, this.id, this.attemptNumber);
    }
}

