/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.analyzer.PreparedQuery;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.execution.ForTimeoutThread;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TimeoutThread;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AnalyzerContext;
import com.facebook.presto.spi.analyzer.AnalyzerProvider;
import com.facebook.presto.spi.analyzer.QueryAnalysis;
import com.facebook.presto.spi.analyzer.QueryAnalyzer;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.resourceGroups.ResourceGroupQueryLimits;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.AnalyzerUtil;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class AccessControlCheckerExecution
implements QueryExecution {
    protected final QueryAnalyzer queryAnalyzer;
    protected final PreparedQuery preparedQuery;
    protected final TransactionManager transactionManager;
    protected final Metadata metadata;
    protected final AccessControl accessControl;
    protected final QueryStateMachine stateMachine;
    protected final ScheduledExecutorService timeoutThreadExecutor;
    private final String slug;
    private final int retryCount;
    private final AtomicReference<Optional<ResourceGroupQueryLimits>> resourceGroupQueryLimits = new AtomicReference(Optional.empty());
    private final AnalyzerContext analyzerContext;

    public AccessControlCheckerExecution(QueryAnalyzer queryAnalyzer, PreparedQuery preparedQuery, String slug, int retryCount, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, ScheduledExecutorService timeoutThreadExecutor) {
        this.queryAnalyzer = Objects.requireNonNull(queryAnalyzer, "queryAnalyzer is null");
        this.preparedQuery = Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.slug = Objects.requireNonNull(slug, "slug is null");
        this.retryCount = retryCount;
        this.timeoutThreadExecutor = Objects.requireNonNull(timeoutThreadExecutor, "timeoutThreadExecutor is null");
        this.analyzerContext = AnalyzerUtil.getAnalyzerContext(queryAnalyzer, metadata.getMetadataResolver(stateMachine.getSession()), new PlanNodeIdAllocator(), new VariableAllocator(), stateMachine.getSession());
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return new DataSize(0.0, DataSize.Unit.BYTE);
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return new DataSize(0.0, DataSize.Unit.BYTE);
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        return new Duration(0.0, TimeUnit.NANOSECONDS);
    }

    @Override
    public DataSize getRawInputDataSize() {
        return DataSize.succinctBytes((long)0L);
    }

    @Override
    public long getOutputPositions() {
        return 0L;
    }

    @Override
    public DataSize getOutputDataSize() {
        return DataSize.succinctBytes((long)0L);
    }

    @Override
    public Optional<ResourceGroupQueryLimits> getResourceGroupQueryLimits() {
        return this.resourceGroupQueryLimits.get();
    }

    @Override
    public void setResourceGroupQueryLimits(ResourceGroupQueryLimits resourceGroupQueryLimits) {
        if (!this.resourceGroupQueryLimits.compareAndSet(Optional.empty(), Optional.of(Objects.requireNonNull(resourceGroupQueryLimits, "resourceGroupQueryLimits is null")))) {
            throw new IllegalStateException("Cannot set resourceGroupQueryLimits more than once");
        }
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().map(BasicQueryInfo::new).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.empty()));
    }

    @Override
    public int getRunningTaskCount() {
        return this.stateMachine.getCurrentRunningTaskCount();
    }

    @Override
    public void start() {
        try {
            if (!this.stateMachine.transitionToRunning()) {
                return;
            }
            ListenableFuture<?> future = this.executeTask();
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object result) {
                    AccessControlCheckerExecution.this.stateMachine.transitionToFinishing();
                }

                public void onFailure(Throwable throwable) {
                    AccessControlCheckerExecution.this.fail(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (Throwable e) {
            this.fail(e);
            Throwables.throwIfInstanceOf((Throwable)e, Error.class);
        }
    }

    private ListenableFuture<?> executeTask() {
        QueryAnalysis queryAnalysis;
        this.stateMachine.beginSemanticAnalyzing();
        try (TimeoutThread unused = new TimeoutThread(Thread.currentThread(), this.timeoutThreadExecutor, SystemSessionProperties.getQueryAnalyzerTimeout(this.getSession()));){
            queryAnalysis = this.queryAnalyzer.analyze(this.analyzerContext, this.preparedQuery);
        }
        this.stateMachine.beginColumnAccessPermissionChecking();
        AnalyzerUtil.checkAccessPermissions(queryAnalysis.getAccessControlReferences());
        this.stateMachine.endColumnAccessPermissionChecking();
        return Futures.immediateFuture(null);
    }

    @Override
    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.stateMachine.getStateChange(currentState);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    @Override
    public void fail(Throwable cause) {
        this.stateMachine.transitionToFailed(cause);
        this.stateMachine.updateQueryInfo(Optional.empty());
    }

    @Override
    public boolean isDone() {
        return this.getState().isDone();
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().orElseGet(() -> this.stateMachine.updateQueryInfo(Optional.empty()));
    }

    @Override
    public Plan getQueryPlan() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    public static class AccessControlCheckerExecutionFactory
    implements QueryExecution.QueryExecutionFactory<AccessControlCheckerExecution> {
        private final TransactionManager transactionManager;
        private final Metadata metadata;
        private final AccessControl accessControl;
        private final ScheduledExecutorService timeoutThreadExecutor;

        @Inject
        public AccessControlCheckerExecutionFactory(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl, @ForTimeoutThread ScheduledExecutorService timeoutThreadExecutor) {
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.timeoutThreadExecutor = Objects.requireNonNull(timeoutThreadExecutor, "timeoutThreadExecutor is null");
        }

        @Override
        public AccessControlCheckerExecution createQueryExecution(AnalyzerProvider analyzerProvider, PreparedQuery preparedQuery, QueryStateMachine stateMachine, String slug, int retryCount, WarningCollector warningCollector, Optional<QueryType> queryType) {
            return this.createAccessControlChecker(analyzerProvider.getQueryAnalyzer(), preparedQuery, stateMachine, slug, retryCount);
        }

        private AccessControlCheckerExecution createAccessControlChecker(QueryAnalyzer queryAnalyzer, PreparedQuery preparedQuery, QueryStateMachine stateMachine, String slug, int retryCount) {
            return new AccessControlCheckerExecution(queryAnalyzer, preparedQuery, slug, retryCount, this.transactionManager, this.metadata, this.accessControl, stateMachine, this.timeoutThreadExecutor);
        }
    }
}

