/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.presto.Session;
import com.facebook.presto.common.analyzer.PreparedQuery;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.dispatcher.DispatchExecutor;
import com.facebook.presto.dispatcher.DispatchQuery;
import com.facebook.presto.dispatcher.DispatchQueryFactory;
import com.facebook.presto.dispatcher.LocalDispatchQuery;
import com.facebook.presto.dispatcher.QueryPrerequisitesManager;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.execution.ExecutionFactoriesManager;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AnalyzerProvider;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.tracing.Tracer;
import com.facebook.presto.tracing.NoopTracerProvider;
import com.facebook.presto.tracing.QueryStateTracingListener;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.inject.Inject;

public class LocalDispatchQueryFactory
implements DispatchQueryFactory {
    private final QueryManager queryManager;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final ExecutionFactoriesManager executionFactoriesManager;
    private final ListeningExecutorService executor;
    private final QueryPrerequisitesManager queryPrerequisitesManager;

    @Inject
    public LocalDispatchQueryFactory(QueryManager queryManager, TransactionManager transactionManager, AccessControl accessControl, Metadata metadata, QueryMonitor queryMonitor, LocationFactory locationFactory, ExecutionFactoriesManager executionFactoriesManager, ClusterSizeMonitor clusterSizeMonitor, DispatchExecutor dispatchExecutor, QueryPrerequisitesManager queryPrerequisitesManager) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.executionFactoriesManager = Objects.requireNonNull(executionFactoriesManager, "executionFactoriesManager is null");
        this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
        this.executor = Objects.requireNonNull(dispatchExecutor, "executorService is null").getExecutor();
        this.queryPrerequisitesManager = Objects.requireNonNull(queryPrerequisitesManager, "queryPrerequisitesManager is null");
    }

    @Override
    public DispatchQuery createDispatchQuery(Session session, AnalyzerProvider analyzerProvider, String query, PreparedQuery preparedQuery, String slug, int retryCount, ResourceGroupId resourceGroup, Optional<QueryType> queryType, WarningCollector warningCollector, Consumer<DispatchQuery> queryQueuer) {
        QueryStateMachine stateMachine = QueryStateMachine.begin(query, preparedQuery.getPrepareSql(), session, this.locationFactory.createQueryLocation(session.getQueryId()), resourceGroup, queryType, preparedQuery.isTransactionControlStatement(), this.transactionManager, this.accessControl, (Executor)this.executor, this.metadata, warningCollector);
        stateMachine.addStateChangeListener(new QueryStateTracingListener(stateMachine.getSession().getTracer().orElse((Tracer)NoopTracerProvider.NOOP_TRACER)));
        this.queryMonitor.queryCreatedEvent(stateMachine.getBasicQueryInfo(Optional.empty()));
        ListenableFuture queryExecutionFuture = this.executor.submit(() -> {
            QueryExecution.QueryExecutionFactory<?> queryExecutionFactory = this.executionFactoriesManager.getExecutionFactory(preparedQuery);
            if (queryExecutionFactory == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type: " + preparedQuery.getStatementClass().getSimpleName());
            }
            return queryExecutionFactory.createQueryExecution(analyzerProvider, preparedQuery, stateMachine, slug, retryCount, warningCollector, queryType);
        });
        return new LocalDispatchQuery(stateMachine, this.queryMonitor, (ListenableFuture<QueryExecution>)queryExecutionFuture, this.clusterSizeMonitor, (Executor)this.executor, queryQueuer, this.queryManager::createQuery, retryCount > 0, this.queryPrerequisitesManager);
    }
}

