/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class StatsNormalizer {
    public PlanNodeStatsEstimate normalize(PlanNodeStatsEstimate stats) {
        return this.normalize(stats, Optional.empty());
    }

    public PlanNodeStatsEstimate normalize(PlanNodeStatsEstimate stats, Collection<VariableReferenceExpression> outputVariables) {
        return this.normalize(stats, Optional.of(outputVariables));
    }

    private PlanNodeStatsEstimate normalize(PlanNodeStatsEstimate stats, Optional<Collection<VariableReferenceExpression>> outputVariables) {
        if (stats.isOutputRowCountUnknown() && stats.isTotalSizeUnknown()) {
            return PlanNodeStatsEstimate.unknown();
        }
        PlanNodeStatsEstimate.Builder normalized = PlanNodeStatsEstimate.buildFrom(stats).setTotalSize(stats.getOutputSizeInBytes());
        Predicate<VariableReferenceExpression> variableFilter = outputVariables.map(ImmutableSet::copyOf).map(set -> arg_0 -> ((ImmutableSet)set).contains(arg_0)).orElse(variable -> true);
        for (VariableReferenceExpression variable2 : stats.getVariablesWithKnownStatistics()) {
            VariableStatsEstimate normalizedSymbolStats;
            if (!variableFilter.test(variable2)) {
                normalized.removeVariableStatistics(variable2);
                continue;
            }
            VariableStatsEstimate variableStats = stats.getVariableStatistics(variable2);
            VariableStatsEstimate variableStatsEstimate = normalizedSymbolStats = stats.getOutputRowCount() == 0.0 ? VariableStatsEstimate.zero() : this.normalizeVariableStats(variable2, variableStats, stats);
            if (normalizedSymbolStats.isUnknown()) {
                normalized.removeVariableStatistics(variable2);
                continue;
            }
            if (Objects.equals(normalizedSymbolStats, variableStats)) continue;
            normalized.addVariableStatistics(variable2, normalizedSymbolStats);
        }
        return normalized.build();
    }

    private VariableStatsEstimate normalizeVariableStats(VariableReferenceExpression variable, VariableStatsEstimate variableStats, PlanNodeStatsEstimate stats) {
        if (variableStats.isUnknown()) {
            return VariableStatsEstimate.unknown();
        }
        double outputRowCount = stats.getOutputRowCount();
        Preconditions.checkArgument((outputRowCount > 0.0 ? 1 : 0) != 0, (String)"outputRowCount must be greater than zero: %s", (Object)outputRowCount);
        double distinctValuesCount = variableStats.getDistinctValuesCount();
        double nullsFraction = variableStats.getNullsFraction();
        if (!Double.isNaN(distinctValuesCount)) {
            double nonNullValues;
            Type type = variable.getType();
            double maxDistinctValuesByLowHigh = this.maxDistinctValuesByLowHigh(variableStats, type);
            if (distinctValuesCount > maxDistinctValuesByLowHigh) {
                distinctValuesCount = maxDistinctValuesByLowHigh;
            }
            if (distinctValuesCount > outputRowCount) {
                distinctValuesCount = outputRowCount;
            }
            if (distinctValuesCount > (nonNullValues = outputRowCount * (1.0 - nullsFraction))) {
                double difference = distinctValuesCount - nonNullValues;
                distinctValuesCount -= difference / 2.0;
                nullsFraction = 1.0 - (nonNullValues += difference / 2.0) / outputRowCount;
            }
        }
        if (distinctValuesCount == 0.0) {
            return VariableStatsEstimate.zero();
        }
        return VariableStatsEstimate.buildFrom(variableStats).setDistinctValuesCount(distinctValuesCount).setNullsFraction(nullsFraction).build();
    }

    private double maxDistinctValuesByLowHigh(VariableStatsEstimate variableStats, Type type) {
        if (variableStats.statisticRange().length() == 0.0) {
            return 1.0;
        }
        if (!StatsNormalizer.isDiscrete(type)) {
            return Double.NaN;
        }
        double length = variableStats.getHighValue() - variableStats.getLowValue();
        if (Double.isNaN(length)) {
            return Double.NaN;
        }
        if (type instanceof DecimalType) {
            length *= Math.pow(10.0, ((DecimalType)type).getScale());
        }
        return Math.floor(length + 1.0);
    }

    private static boolean isDiscrete(Type type) {
        return type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type.equals(BooleanType.BOOLEAN) || type.equals(DateType.DATE) || type instanceof DecimalType;
    }
}

