/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Traverser;
import java.util.Map;
import java.util.Objects;

public class StatsAndCosts {
    private static final StatsAndCosts EMPTY = new StatsAndCosts((Map<PlanNodeId, PlanNodeStatsEstimate>)ImmutableMap.of(), (Map<PlanNodeId, PlanCostEstimate>)ImmutableMap.of());
    private final Map<PlanNodeId, PlanNodeStatsEstimate> stats;
    private final Map<PlanNodeId, PlanCostEstimate> costs;

    public static StatsAndCosts empty() {
        return EMPTY;
    }

    @JsonCreator
    public StatsAndCosts(@JsonProperty(value="stats") Map<PlanNodeId, PlanNodeStatsEstimate> stats, @JsonProperty(value="costs") Map<PlanNodeId, PlanCostEstimate> costs) {
        this.stats = ImmutableMap.copyOf(Objects.requireNonNull(stats, "stats is null"));
        this.costs = ImmutableMap.copyOf(Objects.requireNonNull(costs, "costs is null"));
    }

    @JsonProperty
    public Map<PlanNodeId, PlanNodeStatsEstimate> getStats() {
        return this.stats;
    }

    @JsonProperty
    public Map<PlanNodeId, PlanCostEstimate> getCosts() {
        return this.costs;
    }

    public StatsAndCosts getForSubplan(PlanNode root) {
        Iterable planIterator = Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root);
        ImmutableMap.Builder filteredStats = ImmutableMap.builder();
        ImmutableMap.Builder filteredCosts = ImmutableMap.builder();
        for (PlanNode node : planIterator) {
            if (this.stats.containsKey(node.getId())) {
                filteredStats.put((Object)node.getId(), (Object)this.stats.get(node.getId()));
            }
            if (!this.costs.containsKey(node.getId())) continue;
            filteredCosts.put((Object)node.getId(), (Object)this.costs.get(node.getId()));
        }
        return new StatsAndCosts((Map<PlanNodeId, PlanNodeStatsEstimate>)filteredStats.build(), (Map<PlanNodeId, PlanCostEstimate>)filteredCosts.build());
    }

    public static StatsAndCosts create(PlanNode root, StatsProvider statsProvider, CostProvider costProvider) {
        Iterable planIterator = Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root);
        ImmutableMap.Builder stats = ImmutableMap.builder();
        ImmutableMap.Builder costs = ImmutableMap.builder();
        for (PlanNode node : planIterator) {
            stats.put((Object)node.getId(), (Object)statsProvider.getStats(node));
            costs.put((Object)node.getId(), (Object)costProvider.getCost(node));
        }
        return new StatsAndCosts((Map<PlanNodeId, PlanNodeStatsEstimate>)stats.build(), (Map<PlanNodeId, PlanCostEstimate>)costs.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsAndCosts other = (StatsAndCosts)o;
        return Objects.equals(this.stats, other.stats) && Objects.equals(this.costs, other.costs);
    }

    public int hashCode() {
        return Objects.hash(this.stats, this.costs);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stats", this.stats).add("costs", this.costs).toString();
    }
}

