/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class JoinNodeStatsEstimate {
    private static final JoinNodeStatsEstimate UNKNOWN = new JoinNodeStatsEstimate(Double.NaN, Double.NaN);
    private final double nullJoinBuildKeyCount;
    private final double joinBuildKeyCount;

    public JoinNodeStatsEstimate(double nullJoinBuildKeyCount, double joinBuildKeyCount) {
        this.nullJoinBuildKeyCount = nullJoinBuildKeyCount;
        this.joinBuildKeyCount = joinBuildKeyCount;
    }

    public static JoinNodeStatsEstimate unknown() {
        return UNKNOWN;
    }

    public double getNullJoinBuildKeyCount() {
        return this.nullJoinBuildKeyCount;
    }

    public double getJoinBuildKeyCount() {
        return this.joinBuildKeyCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nullJoinBuildKeyCount", this.nullJoinBuildKeyCount).add("joinBuildKeyCount", this.joinBuildKeyCount).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinNodeStatsEstimate that = (JoinNodeStatsEstimate)o;
        return Double.compare(this.nullJoinBuildKeyCount, that.nullJoinBuildKeyCount) == 0 && Double.compare(this.joinBuildKeyCount, that.joinBuildKeyCount) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.nullJoinBuildKeyCount, this.joinBuildKeyCount);
    }
}

