/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.plan.PlanNodeWithHash;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.sql.planner.CachingPlanCanonicalInfoProvider;
import com.facebook.presto.sql.planner.PlanNodeCanonicalInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class HistoryBasedStatisticsCacheManager {
    private final Map<QueryId, LoadingCache<PlanNodeWithHash, HistoricalPlanStatistics>> statisticsCache = new ConcurrentHashMap<QueryId, LoadingCache<PlanNodeWithHash, HistoricalPlanStatistics>>();
    private final Map<QueryId, Map<CachingPlanCanonicalInfoProvider.CacheKey, PlanNodeCanonicalInfo>> canonicalInfoCache = new ConcurrentHashMap<QueryId, Map<CachingPlanCanonicalInfoProvider.CacheKey, PlanNodeCanonicalInfo>>();
    private final Map<QueryId, Map<CachingPlanCanonicalInfoProvider.InputTableCacheKey, PlanStatistics>> inputTableStatistics = new ConcurrentHashMap<QueryId, Map<CachingPlanCanonicalInfoProvider.InputTableCacheKey, PlanStatistics>>();
    private final Set<QueryId> invalidQueryId = ConcurrentHashMap.newKeySet();

    public LoadingCache<PlanNodeWithHash, HistoricalPlanStatistics> getStatisticsCache(final QueryId queryId, final Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider, final long timeoutInMilliSeconds) {
        return this.statisticsCache.computeIfAbsent(queryId, ignored -> CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<PlanNodeWithHash, HistoricalPlanStatistics>(){

            public HistoricalPlanStatistics load(PlanNodeWithHash key) {
                if (HistoryBasedStatisticsCacheManager.this.invalidQueryId.contains(queryId)) {
                    return HistoricalPlanStatistics.empty();
                }
                return this.loadAll(Collections.singleton(key)).values().stream().findAny().orElseGet(HistoricalPlanStatistics::empty);
            }

            public Map<PlanNodeWithHash, HistoricalPlanStatistics> loadAll(Iterable<? extends PlanNodeWithHash> keys) {
                if (HistoryBasedStatisticsCacheManager.this.invalidQueryId.contains(queryId)) {
                    HashMap<PlanNodeWithHash, HistoricalPlanStatistics> emptyResult = new HashMap<PlanNodeWithHash, HistoricalPlanStatistics>();
                    keys.forEach(x -> emptyResult.put((PlanNodeWithHash)x, HistoricalPlanStatistics.empty()));
                    return emptyResult;
                }
                HashMap<PlanNodeWithHash, HistoricalPlanStatistics> statistics = new HashMap<PlanNodeWithHash, HistoricalPlanStatistics>(((HistoryBasedPlanStatisticsProvider)historyBasedPlanStatisticsProvider.get()).getStats((List)ImmutableList.copyOf(keys), timeoutInMilliSeconds));
                if (statistics.isEmpty()) {
                    HistoryBasedStatisticsCacheManager.this.invalidQueryId.add(queryId);
                }
                for (PlanNodeWithHash planNodeWithHash : keys) {
                    statistics.putIfAbsent(planNodeWithHash, HistoricalPlanStatistics.empty());
                }
                return ImmutableMap.copyOf(statistics);
            }
        }));
    }

    public Map<CachingPlanCanonicalInfoProvider.CacheKey, PlanNodeCanonicalInfo> getCanonicalInfoCache(QueryId queryId) {
        return this.canonicalInfoCache.computeIfAbsent(queryId, ignored -> new ConcurrentHashMap());
    }

    public Map<CachingPlanCanonicalInfoProvider.InputTableCacheKey, PlanStatistics> getInputTableStatistics(QueryId queryId) {
        return this.inputTableStatistics.computeIfAbsent(queryId, ignored -> new ConcurrentHashMap());
    }

    public void invalidate(QueryId queryId) {
        this.statisticsCache.remove(queryId);
        this.canonicalInfoCache.remove(queryId);
        this.inputTableStatistics.remove(queryId);
        this.invalidQueryId.remove(queryId);
    }

    @VisibleForTesting
    public Map<QueryId, Map<CachingPlanCanonicalInfoProvider.CacheKey, PlanNodeCanonicalInfo>> getCanonicalInfoCache() {
        return this.canonicalInfoCache;
    }

    public boolean loadHistoryFailed(QueryId queryId) {
        return this.invalidQueryId.contains(queryId);
    }
}

