/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.cost.HistoricalPlanStatisticsUtil;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.cost.HistoryBasedStatisticsCacheManager;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeWithHash;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.HistoryBasedSourceInfo;
import com.facebook.presto.spi.statistics.JoinNodeStatistics;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.spi.statistics.PlanStatisticsWithSourceInfo;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.planner.CanonicalPlan;
import com.facebook.presto.sql.planner.PlanNodeCanonicalInfo;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStats;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStatsSummarizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Traverser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class HistoryBasedPlanStatisticsTracker {
    private static final Logger LOG = Logger.get(HistoryBasedPlanStatisticsTracker.class);
    private static final Set<QueryType> ALLOWED_QUERY_TYPES = ImmutableSet.of((Object)QueryType.SELECT, (Object)QueryType.INSERT);
    private final Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider;
    private final HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager;
    private final SessionPropertyManager sessionPropertyManager;
    private final HistoryBasedOptimizationConfig config;

    public HistoryBasedPlanStatisticsTracker(Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider, HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager, SessionPropertyManager sessionPropertyManager, HistoryBasedOptimizationConfig config) {
        this.historyBasedPlanStatisticsProvider = Objects.requireNonNull(historyBasedPlanStatisticsProvider, "historyBasedPlanStatisticsProvider is null");
        this.historyBasedStatisticsCacheManager = Objects.requireNonNull(historyBasedStatisticsCacheManager, "historyBasedStatisticsCacheManager is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.config = Objects.requireNonNull(config, "config is null");
    }

    public void updateStatistics(QueryExecution queryExecution) {
        queryExecution.addFinalQueryInfoListener(this::updateStatistics);
    }

    @VisibleForTesting
    public HistoryBasedPlanStatisticsProvider getHistoryBasedPlanStatisticsProvider() {
        return this.historyBasedPlanStatisticsProvider.get();
    }

    public Map<PlanNodeWithHash, PlanStatisticsWithSourceInfo> getQueryStats(QueryInfo queryInfo) {
        Session session = queryInfo.getSession().toSession(this.sessionPropertyManager);
        if (!SystemSessionProperties.trackHistoryBasedPlanStatisticsEnabled(session)) {
            return ImmutableMap.of();
        }
        if (queryInfo.getFailureInfo() != null || !queryInfo.getOutputStage().isPresent() || !queryInfo.getOutputStage().get().getPlan().isPresent()) {
            return ImmutableMap.of();
        }
        if (!queryInfo.getQueryType().isPresent() || !ALLOWED_QUERY_TYPES.contains(queryInfo.getQueryType().get())) {
            return ImmutableMap.of();
        }
        if (!queryInfo.isFinalQueryInfo()) {
            LOG.error("Expected final query info when updating history based statistics: %s", new Object[]{queryInfo});
            return ImmutableMap.of();
        }
        StageInfo outputStage = queryInfo.getOutputStage().get();
        List<StageInfo> allStages = outputStage.getAllStages();
        Map<PlanNodeId, PlanNodeStats> planNodeStatsMap = PlanNodeStatsSummarizer.aggregateStageStats(allStages);
        HashMap<PlanNodeWithHash, PlanStatisticsWithSourceInfo> planStatistics = new HashMap<PlanNodeWithHash, PlanStatisticsWithSourceInfo>();
        HashMap canonicalInfoMap = new HashMap();
        queryInfo.getPlanCanonicalInfo().forEach(canonicalPlanWithInfo -> canonicalInfoMap.putIfAbsent(canonicalPlanWithInfo.getCanonicalPlan(), canonicalPlanWithInfo.getInfo()));
        for (StageInfo stageInfo : allStages) {
            if (!stageInfo.getPlan().isPresent()) continue;
            PlanNode root = stageInfo.getPlan().get().getRoot();
            for (PlanNode planNode : Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root)) {
                PlanNodeStats planNodeStats;
                if (!planNode.getStatsEquivalentPlanNode().isPresent() || (planNodeStats = planNodeStatsMap.get(planNode.getId())) == null) continue;
                double outputPositions = planNodeStats.getPlanNodeOutputPositions();
                double outputBytes = this.adjustedOutputBytes(planNode, planNodeStats);
                double nullJoinBuildKeyCount = planNodeStats.getPlanNodeNullJoinBuildKeyCount();
                double joinBuildKeyCount = planNodeStats.getPlanNodeJoinBuildKeyCount();
                PlanNode statsEquivalentPlanNode = (PlanNode)planNode.getStatsEquivalentPlanNode().get();
                for (PlanCanonicalizationStrategy strategy : PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList()) {
                    Optional planNodeCanonicalInfo = Optional.ofNullable(canonicalInfoMap.get(new CanonicalPlan(statsEquivalentPlanNode, strategy)));
                    if (!planNodeCanonicalInfo.isPresent()) continue;
                    String hash = ((PlanNodeCanonicalInfo)planNodeCanonicalInfo.get()).getHash();
                    List<PlanStatistics> inputTableStatistics = ((PlanNodeCanonicalInfo)planNodeCanonicalInfo.get()).getInputTableStatistics();
                    PlanNodeWithHash planNodeWithHash = new PlanNodeWithHash(statsEquivalentPlanNode, Optional.of(hash));
                    if (planStatistics.containsKey(planNodeWithHash) && !(nullJoinBuildKeyCount > 0.0) && !(joinBuildKeyCount > 0.0)) continue;
                    planStatistics.put(planNodeWithHash, new PlanStatisticsWithSourceInfo(planNode.getId(), new PlanStatistics(Estimate.of((double)outputPositions), Double.isNaN(outputBytes) ? Estimate.unknown() : Estimate.of((double)outputBytes), 1.0, new JoinNodeStatistics(Estimate.of((double)nullJoinBuildKeyCount), Estimate.of((double)joinBuildKeyCount))), (SourceInfo)new HistoryBasedSourceInfo(Optional.of(hash), Optional.of(inputTableStatistics))));
                }
            }
        }
        return ImmutableMap.copyOf(planStatistics);
    }

    private double adjustedOutputBytes(PlanNode planNode, PlanNodeStats planNodeStats) {
        double outputPositions = planNodeStats.getPlanNodeOutputPositions();
        double outputBytes = planNodeStats.getPlanNodeOutputDataSize().toBytes();
        outputBytes -= planNode.getOutputVariables().stream().mapToDouble(variable -> variable.getType() instanceof FixedWidthType ? outputPositions * (double)((FixedWidthType)variable.getType()).getFixedSize() : 0.0).sum();
        if ((outputBytes += ((PlanNode)planNode.getStatsEquivalentPlanNode().get()).getOutputVariables().stream().mapToDouble(variable -> variable.getType() instanceof FixedWidthType ? outputPositions * (double)((FixedWidthType)variable.getType()).getFixedSize() : 0.0).sum()) < 0.0 || outputPositions > 0.0 && outputBytes < 1.0) {
            outputBytes = Double.NaN;
        }
        return outputBytes;
    }

    public void updateStatistics(QueryInfo queryInfo) {
        Session session = queryInfo.getSession().toSession(this.sessionPropertyManager);
        if (!SystemSessionProperties.trackHistoryBasedPlanStatisticsEnabled(session)) {
            this.historyBasedStatisticsCacheManager.invalidate(queryInfo.getQueryId());
            return;
        }
        Map<PlanNodeWithHash, PlanStatisticsWithSourceInfo> planStatistics = this.getQueryStats(queryInfo);
        Map historicalPlanStatisticsMap = this.historyBasedPlanStatisticsProvider.get().getStats((List)planStatistics.keySet().stream().collect(ImmutableList.toImmutableList()), SystemSessionProperties.getHistoryBasedOptimizerTimeoutLimit(session).toMillis());
        Map newPlanStatistics = (Map)planStatistics.entrySet().stream().filter(entry -> ((PlanNodeWithHash)entry.getKey()).getHash().isPresent() && ((PlanStatisticsWithSourceInfo)entry.getValue()).getSourceInfo() instanceof HistoryBasedSourceInfo && ((HistoryBasedSourceInfo)((PlanStatisticsWithSourceInfo)entry.getValue()).getSourceInfo()).getInputTableStatistics().isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            HistoricalPlanStatistics historicalPlanStatistics = Optional.ofNullable(historicalPlanStatisticsMap.get(entry.getKey())).orElseGet(HistoricalPlanStatistics::empty);
            HistoryBasedSourceInfo historyBasedSourceInfo = (HistoryBasedSourceInfo)((PlanStatisticsWithSourceInfo)entry.getValue()).getSourceInfo();
            return HistoricalPlanStatisticsUtil.updatePlanStatistics(historicalPlanStatistics, (List)historyBasedSourceInfo.getInputTableStatistics().get(), ((PlanStatisticsWithSourceInfo)entry.getValue()).getPlanStatistics(), this.config);
        }));
        if (!newPlanStatistics.isEmpty()) {
            this.historyBasedPlanStatisticsProvider.get().putStats((Map)ImmutableMap.copyOf((Map)newPlanStatistics));
        }
        this.historyBasedStatisticsCacheManager.invalidate(queryInfo.getQueryId());
    }
}

