/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.catalogserver;

import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.address.SimpleAddressSelector;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.HostAddress;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import javax.inject.Inject;

public class RandomCatalogServerAddressSelector
implements AddressSelector<SimpleAddressSelector.SimpleAddress> {
    private final InternalNodeManager internalNodeManager;
    private final Function<List<HostAndPort>, Optional<HostAndPort>> hostSelector;

    @Inject
    public RandomCatalogServerAddressSelector(InternalNodeManager internalNodeManager) {
        this(internalNodeManager, RandomCatalogServerAddressSelector::selectRandomHost);
    }

    @VisibleForTesting
    RandomCatalogServerAddressSelector(InternalNodeManager internalNodeManager, Function<List<HostAndPort>, Optional<HostAndPort>> hostSelector) {
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.hostSelector = Objects.requireNonNull(hostSelector, "hostSelector is null");
    }

    public Optional<SimpleAddressSelector.SimpleAddress> selectAddress(Optional<String> addressSelectionContext) {
        if (addressSelectionContext.isPresent()) {
            return addressSelectionContext.map(HostAndPort::fromString).map(SimpleAddressSelector.SimpleAddress::new);
        }
        List catalogServers = (List)this.internalNodeManager.getCatalogServers().stream().filter(node -> node.getThriftPort().isPresent()).map(catalogServerNode -> {
            HostAddress hostAndPort = catalogServerNode.getHostAndPort();
            return HostAndPort.fromParts((String)hostAndPort.getHostText(), (int)catalogServerNode.getThriftPort().getAsInt());
        }).collect(ImmutableList.toImmutableList());
        return this.hostSelector.apply(catalogServers).map(SimpleAddressSelector.SimpleAddress::new);
    }

    private static Optional<HostAndPort> selectRandomHost(List<HostAndPort> hostAndPorts) {
        if (hostAndPorts.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(hostAndPorts.get(ThreadLocalRandom.current().nextInt(hostAndPorts.size())));
    }
}

