/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class VerboseOptimizerResultsProperty {
    private boolean isEnabled;
    private boolean isDetailedAllOptimizerResults;
    private List<String> optimizerNames;

    public VerboseOptimizerResultsProperty(boolean isEnabled, boolean isDetailedAllOptimizerResults, List<String> optimizerNames) {
        this.isEnabled = isEnabled;
        this.isDetailedAllOptimizerResults = isDetailedAllOptimizerResults;
        this.optimizerNames = Objects.requireNonNull(optimizerNames, "optimizerNames is null");
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isDetailedAllOptimizerResults() {
        return this.isDetailedAllOptimizerResults;
    }

    public boolean containsOptimizer(String optimizerName) {
        return this.isDetailedAllOptimizerResults || this.optimizerNames.contains(optimizerName);
    }

    public static VerboseOptimizerResultsProperty disabled() {
        return new VerboseOptimizerResultsProperty(false, false, new ArrayList<String>());
    }

    public static VerboseOptimizerResultsProperty valueOf(String value) {
        if (value.equalsIgnoreCase("none")) {
            return VerboseOptimizerResultsProperty.disabled();
        }
        if (value.equalsIgnoreCase("all")) {
            return new VerboseOptimizerResultsProperty(true, true, new ArrayList<String>());
        }
        List optimizerNames = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)value);
        return new VerboseOptimizerResultsProperty(true, false, optimizerNames);
    }
}

