/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;
import com.facebook.presto.VerboseOptimizerResultsProperty;
import com.facebook.presto.common.WarningHandlingLevel;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.server.security.SecurityConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.tracing.TracingConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class SystemSessionProperties {
    public static final String OPTIMIZE_HASH_GENERATION = "optimize_hash_generation";
    public static final String JOIN_DISTRIBUTION_TYPE = "join_distribution_type";
    public static final String JOIN_MAX_BROADCAST_TABLE_SIZE = "join_max_broadcast_table_size";
    public static final String SIZE_BASED_JOIN_DISTRIBUTION_TYPE = "size_based_join_distribution_type";
    public static final String DISTRIBUTED_JOIN = "distributed_join";
    public static final String DISTRIBUTED_INDEX_JOIN = "distributed_index_join";
    public static final String HASH_PARTITION_COUNT = "hash_partition_count";
    public static final String PARTITIONING_PROVIDER_CATALOG = "partitioning_provider_catalog";
    public static final String EXCHANGE_MATERIALIZATION_STRATEGY = "exchange_materialization_strategy";
    public static final String USE_STREAMING_EXCHANGE_FOR_MARK_DISTINCT = "use_stream_exchange_for_mark_distinct";
    public static final String GROUPED_EXECUTION = "grouped_execution";
    public static final String RECOVERABLE_GROUPED_EXECUTION = "recoverable_grouped_execution";
    public static final String MAX_FAILED_TASK_PERCENTAGE = "max_failed_task_percentage";
    public static final String MAX_STAGE_RETRIES = "max_stage_retries";
    public static final String PREFER_STREAMING_OPERATORS = "prefer_streaming_operators";
    public static final String TASK_WRITER_COUNT = "task_writer_count";
    public static final String TASK_PARTITIONED_WRITER_COUNT = "task_partitioned_writer_count";
    public static final String TASK_CONCURRENCY = "task_concurrency";
    public static final String TASK_SHARE_INDEX_LOADING = "task_share_index_loading";
    public static final String QUERY_MAX_MEMORY = "query_max_memory";
    public static final String QUERY_MAX_MEMORY_PER_NODE = "query_max_memory_per_node";
    public static final String QUERY_MAX_BROADCAST_MEMORY = "query_max_broadcast_memory";
    public static final String QUERY_MAX_TOTAL_MEMORY = "query_max_total_memory";
    public static final String QUERY_MAX_TOTAL_MEMORY_PER_NODE = "query_max_total_memory_per_node";
    public static final String QUERY_MAX_EXECUTION_TIME = "query_max_execution_time";
    public static final String QUERY_MAX_RUN_TIME = "query_max_run_time";
    public static final String RESOURCE_OVERCOMMIT = "resource_overcommit";
    public static final String QUERY_MAX_CPU_TIME = "query_max_cpu_time";
    public static final String QUERY_MAX_SCAN_RAW_INPUT_BYTES = "query_max_scan_raw_input_bytes";
    public static final String QUERY_MAX_OUTPUT_POSITIONS = "query_max_output_positions";
    public static final String QUERY_MAX_OUTPUT_SIZE = "query_max_output_size";
    public static final String QUERY_MAX_STAGE_COUNT = "query_max_stage_count";
    public static final String REDISTRIBUTE_WRITES = "redistribute_writes";
    public static final String SCALE_WRITERS = "scale_writers";
    public static final String WRITER_MIN_SIZE = "writer_min_size";
    public static final String OPTIMIZED_SCALE_WRITER_PRODUCER_BUFFER = "optimized_scale_writer_producer_buffer";
    public static final String PUSH_TABLE_WRITE_THROUGH_UNION = "push_table_write_through_union";
    public static final String EXECUTION_POLICY = "execution_policy";
    public static final String DICTIONARY_AGGREGATION = "dictionary_aggregation";
    public static final String PLAN_WITH_TABLE_NODE_PARTITIONING = "plan_with_table_node_partitioning";
    public static final String SPATIAL_JOIN = "spatial_join";
    public static final String SPATIAL_PARTITIONING_TABLE_NAME = "spatial_partitioning_table_name";
    public static final String COLOCATED_JOIN = "colocated_join";
    public static final String CONCURRENT_LIFESPANS_PER_NODE = "concurrent_lifespans_per_task";
    public static final String REORDER_JOINS = "reorder_joins";
    public static final String JOIN_REORDERING_STRATEGY = "join_reordering_strategy";
    public static final String PARTIAL_MERGE_PUSHDOWN_STRATEGY = "partial_merge_pushdown_strategy";
    public static final String MAX_REORDERED_JOINS = "max_reordered_joins";
    public static final String INITIAL_SPLITS_PER_NODE = "initial_splits_per_node";
    public static final String SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL = "split_concurrency_adjustment_interval";
    public static final String OPTIMIZE_METADATA_QUERIES = "optimize_metadata_queries";
    public static final String OPTIMIZE_METADATA_QUERIES_IGNORE_STATS = "optimize_metadata_queries_ignore_stats";
    public static final String OPTIMIZE_METADATA_QUERIES_CALL_THRESHOLD = "optimize_metadata_queries_call_threshold";
    public static final String FAST_INEQUALITY_JOINS = "fast_inequality_joins";
    public static final String QUERY_PRIORITY = "query_priority";
    public static final String SPILL_ENABLED = "spill_enabled";
    public static final String JOIN_SPILL_ENABLED = "join_spill_enabled";
    public static final String AGGREGATION_SPILL_ENABLED = "aggregation_spill_enabled";
    public static final String TOPN_SPILL_ENABLED = "topn_spill_enabled";
    public static final String DISTINCT_AGGREGATION_SPILL_ENABLED = "distinct_aggregation_spill_enabled";
    public static final String DEDUP_BASED_DISTINCT_AGGREGATION_SPILL_ENABLED = "dedup_based_distinct_aggregation_spill_enabled";
    public static final String DISTINCT_AGGREGATION_LARGE_BLOCK_SPILL_ENABLED = "distinct_aggregation_large_block_spill_enabled";
    public static final String DISTINCT_AGGREGATION_LARGE_BLOCK_SIZE_THRESHOLD = "distinct_aggregation_large_block_size_threshold";
    public static final String ORDER_BY_AGGREGATION_SPILL_ENABLED = "order_by_aggregation_spill_enabled";
    public static final String WINDOW_SPILL_ENABLED = "window_spill_enabled";
    public static final String ORDER_BY_SPILL_ENABLED = "order_by_spill_enabled";
    public static final String AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT = "aggregation_operator_unspill_memory_limit";
    public static final String TOPN_OPERATOR_UNSPILL_MEMORY_LIMIT = "topn_operator_unspill_memory_limit";
    public static final String QUERY_MAX_REVOCABLE_MEMORY_PER_NODE = "query_max_revocable_memory_per_node";
    public static final String TEMP_STORAGE_SPILLER_BUFFER_SIZE = "temp_storage_spiller_buffer_size";
    public static final String OPTIMIZE_DISTINCT_AGGREGATIONS = "optimize_mixed_distinct_aggregations";
    public static final String LEGACY_ROW_FIELD_ORDINAL_ACCESS = "legacy_row_field_ordinal_access";
    public static final String LEGACY_MAP_SUBSCRIPT = "do_not_use_legacy_map_subscript";
    public static final String ITERATIVE_OPTIMIZER = "iterative_optimizer_enabled";
    public static final String ITERATIVE_OPTIMIZER_TIMEOUT = "iterative_optimizer_timeout";
    public static final String QUERY_ANALYZER_TIMEOUT = "query_analyzer_timeout";
    public static final String RUNTIME_OPTIMIZER_ENABLED = "runtime_optimizer_enabled";
    public static final String EXCHANGE_COMPRESSION = "exchange_compression";
    public static final String EXCHANGE_CHECKSUM = "exchange_checksum";
    public static final String LEGACY_TIMESTAMP = "legacy_timestamp";
    public static final String ENABLE_INTERMEDIATE_AGGREGATIONS = "enable_intermediate_aggregations";
    public static final String PUSH_AGGREGATION_THROUGH_JOIN = "push_aggregation_through_join";
    public static final String PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN = "push_partial_aggregation_through_join";
    public static final String PARSE_DECIMAL_LITERALS_AS_DOUBLE = "parse_decimal_literals_as_double";
    public static final String FORCE_SINGLE_NODE_OUTPUT = "force_single_node_output";
    public static final String FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE = "filter_and_project_min_output_page_size";
    public static final String FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT = "filter_and_project_min_output_page_row_count";
    public static final String DISTRIBUTED_SORT = "distributed_sort";
    public static final String USE_MARK_DISTINCT = "use_mark_distinct";
    public static final String EXPLOIT_CONSTRAINTS = "exploit_constraints";
    public static final String PREFER_PARTIAL_AGGREGATION = "prefer_partial_aggregation";
    public static final String PARTIAL_AGGREGATION_STRATEGY = "partial_aggregation_strategy";
    public static final String PARTIAL_AGGREGATION_BYTE_REDUCTION_THRESHOLD = "partial_aggregation_byte_reduction_threshold";
    public static final String OPTIMIZE_TOP_N_ROW_NUMBER = "optimize_top_n_row_number";
    public static final String OPTIMIZE_CASE_EXPRESSION_PREDICATE = "optimize_case_expression_predicate";
    public static final String MAX_GROUPING_SETS = "max_grouping_sets";
    public static final String LEGACY_UNNEST = "legacy_unnest";
    public static final String STATISTICS_CPU_TIMER_ENABLED = "statistics_cpu_timer_enabled";
    public static final String ENABLE_STATS_CALCULATOR = "enable_stats_calculator";
    public static final String ENABLE_STATS_COLLECTION_FOR_TEMPORARY_TABLE = "enable_stats_collection_for_temporary_table";
    public static final String IGNORE_STATS_CALCULATOR_FAILURES = "ignore_stats_calculator_failures";
    public static final String PRINT_STATS_FOR_NON_JOIN_QUERY = "print_stats_for_non_join_query";
    public static final String MAX_DRIVERS_PER_TASK = "max_drivers_per_task";
    public static final String MAX_TASKS_PER_STAGE = "max_tasks_per_stage";
    public static final String DEFAULT_FILTER_FACTOR_ENABLED = "default_filter_factor_enabled";
    public static final String DEFAULT_JOIN_SELECTIVITY_COEFFICIENT = "default_join_selectivity_coefficient";
    public static final String PUSH_LIMIT_THROUGH_OUTER_JOIN = "push_limit_through_outer_join";
    public static final String OPTIMIZE_CONSTANT_GROUPING_KEYS = "optimize_constant_grouping_keys";
    public static final String MAX_CONCURRENT_MATERIALIZATIONS = "max_concurrent_materializations";
    public static final String PUSHDOWN_SUBFIELDS_ENABLED = "pushdown_subfields_enabled";
    public static final String TABLE_WRITER_MERGE_OPERATOR_ENABLED = "table_writer_merge_operator_enabled";
    public static final String INDEX_LOADER_TIMEOUT = "index_loader_timeout";
    public static final String OPTIMIZED_REPARTITIONING_ENABLED = "optimized_repartitioning";
    public static final String AGGREGATION_PARTITIONING_MERGING_STRATEGY = "aggregation_partitioning_merging_strategy";
    public static final String LIST_BUILT_IN_FUNCTIONS_ONLY = "list_built_in_functions_only";
    public static final String PARTITIONING_PRECISION_STRATEGY = "partitioning_precision_strategy";
    public static final String EXPERIMENTAL_FUNCTIONS_ENABLED = "experimental_functions_enabled";
    public static final String USE_LEGACY_SCHEDULER = "use_legacy_scheduler";
    public static final String OPTIMIZE_COMMON_SUB_EXPRESSIONS = "optimize_common_sub_expressions";
    public static final String PREFER_DISTRIBUTED_UNION = "prefer_distributed_union";
    public static final String WARNING_HANDLING = "warning_handling";
    public static final String OPTIMIZE_NULLS_IN_JOINS = "optimize_nulls_in_join";
    public static final String OPTIMIZE_PAYLOAD_JOINS = "optimize_payload_joins";
    public static final String TARGET_RESULT_SIZE = "target_result_size";
    public static final String PUSHDOWN_DEREFERENCE_ENABLED = "pushdown_dereference_enabled";
    public static final String ENABLE_DYNAMIC_FILTERING = "enable_dynamic_filtering";
    public static final String DYNAMIC_FILTERING_MAX_PER_DRIVER_ROW_COUNT = "dynamic_filtering_max_per_driver_row_count";
    public static final String DYNAMIC_FILTERING_MAX_PER_DRIVER_SIZE = "dynamic_filtering_max_per_driver_size";
    public static final String DYNAMIC_FILTERING_RANGE_ROW_LIMIT_PER_DRIVER = "dynamic_filtering_range_row_limit_per_driver";
    public static final String FRAGMENT_RESULT_CACHING_ENABLED = "fragment_result_caching_enabled";
    public static final String INLINE_SQL_FUNCTIONS = "inline_sql_functions";
    public static final String REMOTE_FUNCTIONS_ENABLED = "remote_functions_enabled";
    public static final String CHECK_ACCESS_CONTROL_ON_UTILIZED_COLUMNS_ONLY = "check_access_control_on_utilized_columns_only";
    public static final String CHECK_ACCESS_CONTROL_WITH_SUBFIELDS = "check_access_control_with_subfields";
    public static final String SKIP_REDUNDANT_SORT = "skip_redundant_sort";
    public static final String ALLOW_WINDOW_ORDER_BY_LITERALS = "allow_window_order_by_literals";
    public static final String ENFORCE_FIXED_DISTRIBUTION_FOR_OUTPUT_OPERATOR = "enforce_fixed_distribution_for_output_operator";
    public static final String MAX_UNACKNOWLEDGED_SPLITS_PER_TASK = "max_unacknowledged_splits_per_task";
    public static final String OPTIMIZE_JOINS_WITH_EMPTY_SOURCES = "optimize_joins_with_empty_sources";
    public static final String SPOOLING_OUTPUT_BUFFER_ENABLED = "spooling_output_buffer_enabled";
    public static final String SPARK_ASSIGN_BUCKET_TO_PARTITION_FOR_PARTITIONED_TABLE_WRITE_ENABLED = "spark_assign_bucket_to_partition_for_partitioned_table_write_enabled";
    public static final String LOG_FORMATTED_QUERY_ENABLED = "log_formatted_query_enabled";
    public static final String LOG_INVOKED_FUNCTION_NAMES_ENABLED = "log_invoked_function_names_enabled";
    public static final String QUERY_RETRY_LIMIT = "query_retry_limit";
    public static final String QUERY_RETRY_MAX_EXECUTION_TIME = "query_retry_max_execution_time";
    public static final String PARTIAL_RESULTS_ENABLED = "partial_results_enabled";
    public static final String PARTIAL_RESULTS_COMPLETION_RATIO_THRESHOLD = "partial_results_completion_ratio_threshold";
    public static final String PARTIAL_RESULTS_MAX_EXECUTION_TIME_MULTIPLIER = "partial_results_max_execution_time_multiplier";
    public static final String OFFSET_CLAUSE_ENABLED = "offset_clause_enabled";
    public static final String VERBOSE_EXCEEDED_MEMORY_LIMIT_ERRORS_ENABLED = "verbose_exceeded_memory_limit_errors_enabled";
    public static final String MATERIALIZED_VIEW_DATA_CONSISTENCY_ENABLED = "materialized_view_data_consistency_enabled";
    public static final String CONSIDER_QUERY_FILTERS_FOR_MATERIALIZED_VIEW_PARTITIONS = "consider-query-filters-for-materialized-view-partitions";
    public static final String QUERY_OPTIMIZATION_WITH_MATERIALIZED_VIEW_ENABLED = "query_optimization_with_materialized_view_enabled";
    public static final String AGGREGATION_IF_TO_FILTER_REWRITE_STRATEGY = "aggregation_if_to_filter_rewrite_strategy";
    public static final String JOINS_NOT_NULL_INFERENCE_STRATEGY = "joins_not_null_inference_strategy";
    public static final String RESOURCE_AWARE_SCHEDULING_STRATEGY = "resource_aware_scheduling_strategy";
    public static final String HEAP_DUMP_ON_EXCEEDED_MEMORY_LIMIT_ENABLED = "heap_dump_on_exceeded_memory_limit_enabled";
    public static final String EXCEEDED_MEMORY_LIMIT_HEAP_DUMP_FILE_DIRECTORY = "exceeded_memory_limit_heap_dump_file_directory";
    public static final String DISTRIBUTED_TRACING_MODE = "distributed_tracing_mode";
    public static final String VERBOSE_RUNTIME_STATS_ENABLED = "verbose_runtime_stats_enabled";
    public static final String OPTIMIZERS_TO_ENABLE_VERBOSE_RUNTIME_STATS = "optimizers_to_enable_verbose_runtime_stats";
    public static final String VERBOSE_OPTIMIZER_INFO_ENABLED = "verbose_optimizer_info_enabled";
    public static final String VERBOSE_OPTIMIZER_RESULTS = "verbose_optimizer_results";
    public static final String STREAMING_FOR_PARTIAL_AGGREGATION_ENABLED = "streaming_for_partial_aggregation_enabled";
    public static final String MAX_STAGE_COUNT_FOR_EAGER_SCHEDULING = "max_stage_count_for_eager_scheduling";
    public static final String HYPERLOGLOG_STANDARD_ERROR_WARNING_THRESHOLD = "hyperloglog_standard_error_warning_threshold";
    public static final String PREFER_MERGE_JOIN_FOR_SORTED_INPUTS = "prefer_merge_join_for_sorted_inputs";
    public static final String SEGMENTED_AGGREGATION_ENABLED = "segmented_aggregation_enabled";
    public static final String USE_HISTORY_BASED_PLAN_STATISTICS = "use_history_based_plan_statistics";
    public static final String TRACK_HISTORY_BASED_PLAN_STATISTICS = "track_history_based_plan_statistics";
    public static final String USE_PERFECTLY_CONSISTENT_HISTORIES = "use_perfectly_consistent_histories";
    public static final String HISTORY_CANONICAL_PLAN_NODE_LIMIT = "history_canonical_plan_node_limit";
    public static final String HISTORY_BASED_OPTIMIZER_TIMEOUT_LIMIT = "history_based_optimizer_timeout_limit";
    public static final String RESTRICT_HISTORY_BASED_OPTIMIZATION_TO_COMPLEX_QUERY = "restrict_history_based_optimization_to_complex_query";
    public static final String MAX_LEAF_NODES_IN_PLAN = "max_leaf_nodes_in_plan";
    public static final String LEAF_NODE_LIMIT_ENABLED = "leaf_node_limit_enabled";
    public static final String PUSH_REMOTE_EXCHANGE_THROUGH_GROUP_ID = "push_remote_exchange_through_group_id";
    public static final String OPTIMIZE_MULTIPLE_APPROX_PERCENTILE_ON_SAME_FIELD = "optimize_multiple_approx_percentile_on_same_field";
    public static final String RANDOMIZE_OUTER_JOIN_NULL_KEY = "randomize_outer_join_null_key";
    public static final String RANDOMIZE_OUTER_JOIN_NULL_KEY_STRATEGY = "randomize_outer_join_null_key_strategy";
    public static final String RANDOMIZE_OUTER_JOIN_NULL_KEY_NULL_RATIO_THRESHOLD = "randomize_outer_join_null_key_null_ratio_threshold";
    public static final String SHARDED_JOINS_STRATEGY = "sharded_joins_strategy";
    public static final String JOIN_SHARD_COUNT = "join_shard_count";
    public static final String IN_PREDICATES_AS_INNER_JOINS_ENABLED = "in_predicates_as_inner_joins_enabled";
    public static final String PUSH_AGGREGATION_BELOW_JOIN_BYTE_REDUCTION_THRESHOLD = "push_aggregation_below_join_byte_reduction_threshold";
    public static final String KEY_BASED_SAMPLING_ENABLED = "key_based_sampling_enabled";
    public static final String KEY_BASED_SAMPLING_PERCENTAGE = "key_based_sampling_percentage";
    public static final String KEY_BASED_SAMPLING_FUNCTION = "key_based_sampling_function";
    public static final String QUICK_DISTINCT_LIMIT_ENABLED = "quick_distinct_limit_enabled";
    public static final String OPTIMIZE_CONDITIONAL_AGGREGATION_ENABLED = "optimize_conditional_aggregation_enabled";
    public static final String ANALYZER_TYPE = "analyzer_type";
    public static final String PRE_PROCESS_METADATA_CALLS = "pre_process_metadata_calls";
    public static final String REMOVE_REDUNDANT_DISTINCT_AGGREGATION_ENABLED = "remove_redundant_distinct_aggregation_enabled";
    public static final String PREFILTER_FOR_GROUPBY_LIMIT = "prefilter_for_groupby_limit";
    public static final String PREFILTER_FOR_GROUPBY_LIMIT_TIMEOUT_MS = "prefilter_for_groupby_limit_timeout_ms";
    public static final String OPTIMIZE_JOIN_PROBE_FOR_EMPTY_BUILD_RUNTIME = "optimize_join_probe_for_empty_build_runtime";
    public static final String USE_DEFAULTS_FOR_CORRELATED_AGGREGATION_PUSHDOWN_THROUGH_OUTER_JOINS = "use_defaults_for_correlated_aggregation_pushdown_through_outer_joins";
    public static final String MERGE_DUPLICATE_AGGREGATIONS = "merge_duplicate_aggregations";
    public static final String MERGE_AGGREGATIONS_WITH_AND_WITHOUT_FILTER = "merge_aggregations_with_and_without_filter";
    public static final String SIMPLIFY_PLAN_WITH_EMPTY_INPUT = "simplify_plan_with_empty_input";
    public static final String PUSH_DOWN_FILTER_EXPRESSION_EVALUATION_THROUGH_CROSS_JOIN = "push_down_filter_expression_evaluation_through_cross_join";
    public static final String REWRITE_CROSS_JOIN_OR_TO_INNER_JOIN = "rewrite_cross_join_or_to_inner_join";
    public static final String REWRITE_CROSS_JOIN_ARRAY_CONTAINS_TO_INNER_JOIN = "rewrite_cross_join_array_contains_to_inner_join";
    public static final String REWRITE_CROSS_JOIN_ARRAY_NOT_CONTAINS_TO_ANTI_JOIN = "rewrite_cross_join_array_not_contains_to_anti_join";
    public static final String REWRITE_LEFT_JOIN_NULL_FILTER_TO_SEMI_JOIN = "rewrite_left_join_null_filter_to_semi_join";
    public static final String USE_BROADCAST_WHEN_BUILDSIZE_SMALL_PROBESIDE_UNKNOWN = "use_broadcast_when_buildsize_small_probeside_unknown";
    public static final String ADD_PARTIAL_NODE_FOR_ROW_NUMBER_WITH_LIMIT = "add_partial_node_for_row_number_with_limit";
    public static final String REWRITE_CASE_TO_MAP_ENABLED = "rewrite_case_to_map_enabled";
    public static final String FIELD_NAMES_IN_JSON_CAST_ENABLED = "field_names_in_json_cast_enabled";
    public static final String PULL_EXPRESSION_FROM_LAMBDA_ENABLED = "pull_expression_from_lambda_enabled";
    public static final String REWRITE_CONSTANT_ARRAY_CONTAINS_TO_IN_EXPRESSION = "rewrite_constant_array_contains_to_in_expression";
    public static final String INFER_INEQUALITY_PREDICATES = "infer_inequality_predicates";
    public static final String NATIVE_SIMPLIFIED_EXPRESSION_EVALUATION_ENABLED = "simplified_expression_evaluation_enabled";
    public static final String NATIVE_AGGREGATION_SPILL_MEMORY_THRESHOLD = "aggregation_spill_memory_threshold";
    public static final String NATIVE_JOIN_SPILL_MEMORY_THRESHOLD = "join_spill_memory_threshold";
    public static final String NATIVE_ORDER_BY_SPILL_MEMORY_THRESHOLD = "order_by_spill_memory_threshold";
    public static final String NATIVE_EXECUTION_ENABLED = "native_execution_enabled";
    public static final String NATIVE_EXECUTION_EXECUTABLE_PATH = "native_execution_executable_path";
    public static final String NATIVE_EXECUTION_PROGRAM_ARGUMENTS = "native_execution_program_arguments";
    public static final String NATIVE_EXECUTION_PROCESS_REUSE_ENABLED = "native_execution_process_reuse_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    public SystemSessionProperties() {
        this(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), new FeaturesConfig(), new NodeMemoryConfig(), new WarningCollectorConfig(), new NodeSchedulerConfig(), new NodeSpillConfig(), new TracingConfig(), new CompilerConfig(), new SecurityConfig());
    }

    @Inject
    public SystemSessionProperties(QueryManagerConfig queryManagerConfig, TaskManagerConfig taskManagerConfig, MemoryManagerConfig memoryManagerConfig, FeaturesConfig featuresConfig, NodeMemoryConfig nodeMemoryConfig, WarningCollectorConfig warningCollectorConfig, NodeSchedulerConfig nodeSchedulerConfig, NodeSpillConfig nodeSpillConfig, TracingConfig tracingConfig, CompilerConfig compilerConfig, SecurityConfig securityConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)EXECUTION_POLICY, (String)"Policy used for scheduling query tasks", (String)queryManagerConfig.getQueryExecutionPolicy(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)OPTIMIZE_HASH_GENERATION, (String)"Compute hash codes for distribution, joins, and aggregations early in query plan", (Boolean)featuresConfig.isOptimizeHashGeneration(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)DISTRIBUTED_JOIN, (String)"(DEPRECATED) Use a distributed join instead of a broadcast join. If this is set, join_distribution_type is ignored.", null, (boolean)false), (Object)new PropertyMetadata(JOIN_DISTRIBUTION_TYPE, String.format("The join method to use. Options are %s", Stream.of(FeaturesConfig.JoinDistributionType.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.JoinDistributionType.class, (Object)featuresConfig.getJoinDistributionType(), false, value -> FeaturesConfig.JoinDistributionType.valueOf(((String)value).toUpperCase()), Enum::name), (Object)new PropertyMetadata(JOIN_MAX_BROADCAST_TABLE_SIZE, "Maximum estimated size of a table that can be broadcast for JOIN.", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getJoinMaxBroadcastTableSize(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), (Object)PropertyMetadata.booleanProperty((String)SIZE_BASED_JOIN_DISTRIBUTION_TYPE, (String)"Consider source table size when determining join distribution type when CBO fails", (Boolean)featuresConfig.isSizeBasedJoinDistributionTypeEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)DISTRIBUTED_INDEX_JOIN, (String)"Distribute index joins on join keys instead of executing inline", (Boolean)featuresConfig.isDistributedIndexJoinsEnabled(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)HASH_PARTITION_COUNT, (String)"Number of partitions for distributed joins and aggregations", (Integer)queryManagerConfig.getHashPartitionCount(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)PARTITIONING_PROVIDER_CATALOG, (String)"Name of the catalog providing custom partitioning", (String)queryManagerConfig.getPartitioningProviderCatalog(), (boolean)false), (Object)new PropertyMetadata(EXCHANGE_MATERIALIZATION_STRATEGY, String.format("The exchange materialization strategy to use. Options are %s", Stream.of(QueryManagerConfig.ExchangeMaterializationStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, QueryManagerConfig.ExchangeMaterializationStrategy.class, (Object)queryManagerConfig.getExchangeMaterializationStrategy(), false, value -> QueryManagerConfig.ExchangeMaterializationStrategy.valueOf(((String)value).toUpperCase()), Enum::name), (Object)PropertyMetadata.booleanProperty((String)USE_STREAMING_EXCHANGE_FOR_MARK_DISTINCT, (String)"Use streaming instead of materialization for mark distinct with materialized exchange enabled", (Boolean)queryManagerConfig.getUseStreamingExchangeForMarkDistinct(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)GROUPED_EXECUTION, (String)"Use grouped execution when possible", (Boolean)featuresConfig.isGroupedExecutionEnabled(), (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.doubleProperty((String)MAX_FAILED_TASK_PERCENTAGE, (String)"Max percentage of failed tasks that are retryable for recoverable dynamic scheduling", (Double)featuresConfig.getMaxFailedTaskPercentage(), (boolean)false), PropertyMetadata.booleanProperty((String)RECOVERABLE_GROUPED_EXECUTION, (String)"Experimental: Use recoverable grouped execution when possible", (Boolean)featuresConfig.isRecoverableGroupedExecutionEnabled(), (boolean)false), PropertyMetadata.integerProperty((String)MAX_STAGE_RETRIES, (String)"Maximum number of times that stages can be retried", (Integer)featuresConfig.getMaxStageRetries(), (boolean)false), PropertyMetadata.booleanProperty((String)PREFER_STREAMING_OPERATORS, (String)"Prefer source table layouts that produce streaming operators", (Boolean)false, (boolean)false), new PropertyMetadata(TASK_WRITER_COUNT, "Default number of local parallel table writer jobs per worker", (Type)BigintType.BIGINT, Integer.class, (Object)taskManagerConfig.getWriterCount(), false, value -> SystemSessionProperties.validateValueIsPowerOfTwo(Objects.requireNonNull(value, "value is null"), TASK_WRITER_COUNT), value -> value), new PropertyMetadata(TASK_PARTITIONED_WRITER_COUNT, "Number of writers per task for partitioned writes. If not set, the number set by task.writer-count will be used", (Type)BigintType.BIGINT, Integer.class, (Object)taskManagerConfig.getPartitionedWriterCount(), false, value -> SystemSessionProperties.validateValueIsPowerOfTwo(value, TASK_PARTITIONED_WRITER_COUNT), value -> value), PropertyMetadata.booleanProperty((String)REDISTRIBUTE_WRITES, (String)"Force parallel distributed writes", (Boolean)featuresConfig.isRedistributeWrites(), (boolean)false), PropertyMetadata.booleanProperty((String)SCALE_WRITERS, (String)"Scale out writers based on throughput (use minimum necessary)", (Boolean)featuresConfig.isScaleWriters(), (boolean)false), new PropertyMetadata(WRITER_MIN_SIZE, "Target minimum size of writer output when scaling writers", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getWriterMinSize(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)OPTIMIZED_SCALE_WRITER_PRODUCER_BUFFER, (String)"Optimize scale writer creation based on producer buffer", (Boolean)featuresConfig.isOptimizedScaleWriterProducerBuffer(), (boolean)true), PropertyMetadata.booleanProperty((String)PUSH_TABLE_WRITE_THROUGH_UNION, (String)"Parallelize writes when using UNION ALL in queries that write data", (Boolean)featuresConfig.isPushTableWriteThroughUnion(), (boolean)false), new PropertyMetadata(TASK_CONCURRENCY, "Default number of local parallel jobs per worker", (Type)BigintType.BIGINT, Integer.class, (Object)taskManagerConfig.getTaskConcurrency(), false, value -> SystemSessionProperties.validateValueIsPowerOfTwo(Objects.requireNonNull(value, "value is null"), TASK_CONCURRENCY), value -> value), PropertyMetadata.booleanProperty((String)TASK_SHARE_INDEX_LOADING, (String)"Share index join lookups and caching within a task", (Boolean)taskManagerConfig.isShareIndexLoading(), (boolean)false), new PropertyMetadata(QUERY_MAX_RUN_TIME, "Maximum run time of a query (includes the queueing time)", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getQueryMaxRunTime(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(QUERY_MAX_EXECUTION_TIME, "Maximum execution time of a query", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getQueryMaxExecutionTime(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(QUERY_MAX_CPU_TIME, "Maximum CPU time of a query", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getQueryMaxCpuTime(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(QUERY_MAX_MEMORY, "Maximum amount of distributed memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)memoryManagerConfig.getSoftMaxQueryMemory(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(QUERY_MAX_MEMORY_PER_NODE, "Maximum amount of user task memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)nodeMemoryConfig.getSoftMaxQueryMemoryPerNode(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(QUERY_MAX_BROADCAST_MEMORY, "Maximum amount of memory a query can use for broadcast join", (Type)VarcharType.VARCHAR, DataSize.class, (Object)nodeMemoryConfig.getMaxQueryBroadcastMemory(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(QUERY_MAX_TOTAL_MEMORY, "Maximum amount of distributed total memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)memoryManagerConfig.getSoftMaxQueryTotalMemory(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(QUERY_MAX_TOTAL_MEMORY_PER_NODE, "Maximum amount of total (user + system) task memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)nodeMemoryConfig.getSoftMaxQueryTotalMemoryPerNode(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)RESOURCE_OVERCOMMIT, (String)"Use resources which are not guaranteed to be available to the query", (Boolean)false, (boolean)false), PropertyMetadata.dataSizeProperty((String)QUERY_MAX_SCAN_RAW_INPUT_BYTES, (String)"Maximum scan raw input bytes of a query", (DataSize)queryManagerConfig.getQueryMaxScanRawInputBytes(), (boolean)false), PropertyMetadata.longProperty((String)QUERY_MAX_OUTPUT_POSITIONS, (String)"Maximum number of output rows that can be fetched by a query", (Long)queryManagerConfig.getQueryMaxOutputPositions(), (boolean)false), PropertyMetadata.dataSizeProperty((String)QUERY_MAX_OUTPUT_SIZE, (String)"Maximum data that can be fetched by a query", (DataSize)queryManagerConfig.getQueryMaxOutputSize(), (boolean)false), PropertyMetadata.integerProperty((String)QUERY_MAX_STAGE_COUNT, (String)"Temporary: Maximum number of stages a query can have", (Integer)queryManagerConfig.getMaxStageCount(), (boolean)true), PropertyMetadata.booleanProperty((String)DICTIONARY_AGGREGATION, (String)"Enable optimization for aggregations on dictionaries", (Boolean)featuresConfig.isDictionaryAggregation(), (boolean)false), PropertyMetadata.integerProperty((String)INITIAL_SPLITS_PER_NODE, (String)"The number of splits each node will run per task, initially", (Integer)taskManagerConfig.getInitialSplitsPerNode(), (boolean)false), new PropertyMetadata(SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL, "Experimental: Interval between changes to the number of concurrent splits per node", (Type)VarcharType.VARCHAR, Duration.class, (Object)taskManagerConfig.getSplitConcurrencyAdjustmentInterval(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), PropertyMetadata.booleanProperty((String)OPTIMIZE_METADATA_QUERIES, (String)"Enable optimization for metadata queries if the resulting partitions are not empty according to the partition stats", (Boolean)featuresConfig.isOptimizeMetadataQueries(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_METADATA_QUERIES_IGNORE_STATS, (String)"Enable optimization for metadata queries. Note if metadata entry has empty data, the result might be different (e.g. empty Hive partition)", (Boolean)featuresConfig.isOptimizeMetadataQueriesIgnoreStats(), (boolean)false), PropertyMetadata.integerProperty((String)OPTIMIZE_METADATA_QUERIES_CALL_THRESHOLD, (String)"The threshold number of service calls to metastore, used in optimization for metadata queries", (Integer)featuresConfig.getOptimizeMetadataQueriesCallThreshold(), (boolean)false), PropertyMetadata.integerProperty((String)QUERY_PRIORITY, (String)"The priority of queries. Larger numbers are higher priority", (Integer)1, (boolean)false), PropertyMetadata.booleanProperty((String)PLAN_WITH_TABLE_NODE_PARTITIONING, (String)"Experimental: Adapt plan to pre-partitioned tables", (Boolean)true, (boolean)false), PropertyMetadata.booleanProperty((String)REORDER_JOINS, (String)"(DEPRECATED) Reorder joins to remove unnecessary cross joins. If this is set, join_reordering_strategy will be ignored", null, (boolean)false), new PropertyMetadata(JOIN_REORDERING_STRATEGY, String.format("The join reordering strategy to use. Options are %s", Stream.of(FeaturesConfig.JoinReorderingStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.JoinReorderingStrategy.class, (Object)featuresConfig.getJoinReorderingStrategy(), false, value -> FeaturesConfig.JoinReorderingStrategy.valueOf(((String)value).toUpperCase()), Enum::name), new PropertyMetadata(PARTIAL_MERGE_PUSHDOWN_STRATEGY, String.format("Experimental: Partial merge pushdown strategy to use. Options are %s", Stream.of(FeaturesConfig.PartialMergePushdownStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.PartialMergePushdownStrategy.class, (Object)featuresConfig.getPartialMergePushdownStrategy(), false, value -> FeaturesConfig.PartialMergePushdownStrategy.valueOf(((String)value).toUpperCase()), Enum::name), new PropertyMetadata(MAX_REORDERED_JOINS, "The maximum number of joins to reorder as one group in cost-based join reordering", (Type)BigintType.BIGINT, Integer.class, (Object)featuresConfig.getMaxReorderedJoins(), false, value -> {
            int intValue = ((Number)Objects.requireNonNull(value, "value is null")).intValue();
            if (intValue < 2) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be greater than or equal to 2: %s", MAX_REORDERED_JOINS, intValue));
            }
            return intValue;
        }, value -> value), PropertyMetadata.booleanProperty((String)FAST_INEQUALITY_JOINS, (String)"Use faster handling of inequality join if it is possible", (Boolean)featuresConfig.isFastInequalityJoins(), (boolean)false), PropertyMetadata.booleanProperty((String)COLOCATED_JOIN, (String)"Experimental: Use a colocated join when possible", (Boolean)featuresConfig.isColocatedJoinsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SPATIAL_JOIN, (String)"Use spatial index for spatial join when possible", (Boolean)featuresConfig.isSpatialJoinsEnabled(), (boolean)false), PropertyMetadata.stringProperty((String)SPATIAL_PARTITIONING_TABLE_NAME, (String)"Name of the table containing spatial partitioning scheme", null, (boolean)false), PropertyMetadata.integerProperty((String)CONCURRENT_LIFESPANS_PER_NODE, (String)"Experimental: Run a fixed number of groups concurrently for eligible JOINs", (Integer)featuresConfig.getConcurrentLifespansPerTask(), (boolean)false), new PropertyMetadata(SPILL_ENABLED, "Experimental: Enable spilling", (Type)BooleanType.BOOLEAN, Boolean.class, (Object)featuresConfig.isSpillEnabled(), false, value -> {
            boolean spillEnabled = (Boolean)value;
            if (spillEnabled && featuresConfig.getSingleStreamSpillerChoice() == FeaturesConfig.SingleStreamSpillerChoice.LOCAL_FILE && featuresConfig.getSpillerSpillPaths().isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s cannot be set to true; no spill paths configured", SPILL_ENABLED));
            }
            return spillEnabled;
        }, value -> value), PropertyMetadata.booleanProperty((String)JOIN_SPILL_ENABLED, (String)"Enable join spilling", (Boolean)featuresConfig.isJoinSpillingEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)AGGREGATION_SPILL_ENABLED, (String)"Enable aggregate spilling if spill_enabled", (Boolean)featuresConfig.isAggregationSpillEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)TOPN_SPILL_ENABLED, (String)"Enable topN spilling if spill_enabled", (Boolean)featuresConfig.isTopNSpillEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)DISTINCT_AGGREGATION_SPILL_ENABLED, (String)"Enable spill for distinct aggregations if spill_enabled and aggregation_spill_enabled", (Boolean)featuresConfig.isDistinctAggregationSpillEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)DEDUP_BASED_DISTINCT_AGGREGATION_SPILL_ENABLED, (String)"Perform deduplication of input data for distinct aggregates before spilling", (Boolean)featuresConfig.isDedupBasedDistinctAggregationSpillEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)DISTINCT_AGGREGATION_LARGE_BLOCK_SPILL_ENABLED, (String)"Spill large block to a separate spill file", (Boolean)featuresConfig.isDistinctAggregationLargeBlockSpillEnabled(), (boolean)false), new PropertyMetadata(DISTINCT_AGGREGATION_LARGE_BLOCK_SIZE_THRESHOLD, "Block size threshold beyond which it will be spilled into a separate spill file", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getDistinctAggregationLargeBlockSizeThreshold(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)ORDER_BY_AGGREGATION_SPILL_ENABLED, (String)"Enable spill for order-by aggregations if spill_enabled and aggregation_spill_enabled", (Boolean)featuresConfig.isOrderByAggregationSpillEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)WINDOW_SPILL_ENABLED, (String)"Enable window spilling if spill_enabled", (Boolean)featuresConfig.isWindowSpillEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ORDER_BY_SPILL_ENABLED, (String)"Enable order by spilling if spill_enabled", (Boolean)featuresConfig.isOrderBySpillEnabled(), (boolean)false), new PropertyMetadata(AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT, "Experimental: How much memory can should be allocated per aggregation operator in unspilling process", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getAggregationOperatorUnspillMemoryLimit(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(TOPN_OPERATOR_UNSPILL_MEMORY_LIMIT, "How much memory can should be allocated per topN operator in unspilling process", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getTopNOperatorUnspillMemoryLimit(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(QUERY_MAX_REVOCABLE_MEMORY_PER_NODE, "Maximum amount of revocable memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)nodeSpillConfig.getMaxRevocableMemoryPerNode(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(TEMP_STORAGE_SPILLER_BUFFER_SIZE, "Experimental: Buffer size used by TempStorageSingleStreamSpiller", (Type)VarcharType.VARCHAR, DataSize.class, (Object)nodeSpillConfig.getTempStorageBufferSize(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)OPTIMIZE_DISTINCT_AGGREGATIONS, (String)"Optimize mixed non-distinct and distinct aggregations", (Boolean)featuresConfig.isOptimizeMixedDistinctAggregations(), (boolean)false), PropertyMetadata.booleanProperty((String)LEGACY_ROW_FIELD_ORDINAL_ACCESS, (String)"Allow accessing anonymous row field with .field0, .field1, ...", (Boolean)featuresConfig.isLegacyRowFieldOrdinalAccess(), (boolean)false), PropertyMetadata.booleanProperty((String)LEGACY_MAP_SUBSCRIPT, (String)"Do not fail the query if map key is missing", (Boolean)featuresConfig.isLegacyMapSubscript(), (boolean)true), PropertyMetadata.booleanProperty((String)ITERATIVE_OPTIMIZER, (String)"Experimental: enable iterative optimizer", (Boolean)featuresConfig.isIterativeOptimizerEnabled(), (boolean)false), new PropertyMetadata(ITERATIVE_OPTIMIZER_TIMEOUT, "Timeout for plan optimization in iterative optimizer", (Type)VarcharType.VARCHAR, Duration.class, (Object)featuresConfig.getIterativeOptimizerTimeout(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(QUERY_ANALYZER_TIMEOUT, "Maximum processing time for query analyzer", (Type)VarcharType.VARCHAR, Duration.class, (Object)featuresConfig.getQueryAnalyzerTimeout(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), PropertyMetadata.booleanProperty((String)RUNTIME_OPTIMIZER_ENABLED, (String)"Experimental: enable runtime optimizer", (Boolean)featuresConfig.isRuntimeOptimizerEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)EXCHANGE_COMPRESSION, (String)"Enable compression in exchanges", (Boolean)featuresConfig.isExchangeCompressionEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)EXCHANGE_CHECKSUM, (String)"Enable checksum in exchanges", (Boolean)featuresConfig.isExchangeChecksumEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)LEGACY_TIMESTAMP, (String)"Use legacy TIME & TIMESTAMP semantics (warning: this will be removed)", (Boolean)featuresConfig.isLegacyTimestamp(), (boolean)true), PropertyMetadata.booleanProperty((String)ENABLE_INTERMEDIATE_AGGREGATIONS, (String)"Enable the use of intermediate aggregations", (Boolean)featuresConfig.isEnableIntermediateAggregations(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_AGGREGATION_THROUGH_JOIN, (String)"Allow pushing aggregations below joins", (Boolean)featuresConfig.isPushAggregationThroughJoin(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN, (String)"Push partial aggregations below joins", (Boolean)false, (boolean)false), PropertyMetadata.booleanProperty((String)PARSE_DECIMAL_LITERALS_AS_DOUBLE, (String)"Parse decimal literals as DOUBLE instead of DECIMAL", (Boolean)featuresConfig.isParseDecimalLiteralsAsDouble(), (boolean)false), PropertyMetadata.booleanProperty((String)FORCE_SINGLE_NODE_OUTPUT, (String)"Force single node output", (Boolean)featuresConfig.isForceSingleNodeOutput(), (boolean)true), new PropertyMetadata(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, "Experimental: Minimum output page size for filter and project operators", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getFilterAndProjectMinOutputPageSize(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.integerProperty((String)FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT, (String)"Experimental: Minimum output page row count for filter and project operators", (Integer)featuresConfig.getFilterAndProjectMinOutputPageRowCount(), (boolean)false), PropertyMetadata.booleanProperty((String)DISTRIBUTED_SORT, (String)"Parallelize sort across multiple nodes", (Boolean)featuresConfig.isDistributedSortEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_MARK_DISTINCT, (String)"Implement DISTINCT aggregations using MarkDistinct", (Boolean)featuresConfig.isUseMarkDistinct(), (boolean)false), PropertyMetadata.booleanProperty((String)EXPLOIT_CONSTRAINTS, (String)"Exploit table constraints.", (Boolean)featuresConfig.isExploitConstraints(), (boolean)false), PropertyMetadata.booleanProperty((String)PREFER_PARTIAL_AGGREGATION, (String)"Prefer splitting aggregations into partial and final stages", null, (boolean)false), new PropertyMetadata(PARTIAL_AGGREGATION_STRATEGY, String.format("Partial aggregation strategy to use. Options are %s", Stream.of(FeaturesConfig.PartialAggregationStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.PartialAggregationStrategy.class, (Object)featuresConfig.getPartialAggregationStrategy(), false, value -> FeaturesConfig.PartialAggregationStrategy.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.doubleProperty((String)PARTIAL_AGGREGATION_BYTE_REDUCTION_THRESHOLD, (String)"Byte reduction ratio threshold at which to disable partial aggregation", (Double)featuresConfig.getPartialAggregationByteReductionThreshold(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_TOP_N_ROW_NUMBER, (String)"Use top N row number optimization", (Boolean)featuresConfig.isOptimizeTopNRowNumber(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_CASE_EXPRESSION_PREDICATE, (String)"Optimize case expression predicates", (Boolean)featuresConfig.isOptimizeCaseExpressionPredicate(), (boolean)false), PropertyMetadata.integerProperty((String)MAX_GROUPING_SETS, (String)"Maximum number of grouping sets in a GROUP BY", (Integer)featuresConfig.getMaxGroupingSets(), (boolean)true), PropertyMetadata.booleanProperty((String)LEGACY_UNNEST, (String)"Using legacy unnest semantic, where unnest(array(row)) will create one column of type row", (Boolean)featuresConfig.isLegacyUnnestArrayRows(), (boolean)false), PropertyMetadata.booleanProperty((String)STATISTICS_CPU_TIMER_ENABLED, (String)"Experimental: Enable cpu time tracking for automatic column statistics collection on write", (Boolean)taskManagerConfig.isStatisticsCpuTimerEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_STATS_CALCULATOR, (String)"Experimental: Enable statistics calculator", (Boolean)featuresConfig.isEnableStatsCalculator(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_STATS_COLLECTION_FOR_TEMPORARY_TABLE, (String)"Experimental: Enable statistics collection of temporary tables created for materialized exchange", (Boolean)featuresConfig.isEnableStatsCollectionForTemporaryTable(), (boolean)false), PropertyMetadata.integerProperty((String)MAX_TASKS_PER_STAGE, (String)"Maximum number of tasks for a non source distributed stage", (Integer)taskManagerConfig.getMaxTasksPerStage(), (boolean)false), new PropertyMetadata(MAX_DRIVERS_PER_TASK, "Maximum number of drivers per task", (Type)IntegerType.INTEGER, Integer.class, null, false, value -> Math.min(taskManagerConfig.getMaxDriversPerTask(), SystemSessionProperties.validateNullablePositiveIntegerValue(value, MAX_DRIVERS_PER_TASK)), object -> object), PropertyMetadata.booleanProperty((String)IGNORE_STATS_CALCULATOR_FAILURES, (String)"Ignore statistics calculator failures", (Boolean)featuresConfig.isIgnoreStatsCalculatorFailures(), (boolean)false), PropertyMetadata.booleanProperty((String)PRINT_STATS_FOR_NON_JOIN_QUERY, (String)"Print stats and cost for non-join-query in plan", (Boolean)featuresConfig.isPrintStatsForNonJoinQuery(), (boolean)false), PropertyMetadata.booleanProperty((String)DEFAULT_FILTER_FACTOR_ENABLED, (String)"use a default filter factor for unknown filters in a filter node", (Boolean)featuresConfig.isDefaultFilterFactorEnabled(), (boolean)false), new PropertyMetadata(DEFAULT_JOIN_SELECTIVITY_COEFFICIENT, "use a default join selectivity coefficient factor when column statistics are not available in a join node", (Type)DoubleType.DOUBLE, Double.class, (Object)featuresConfig.getDefaultJoinSelectivityCoefficient(), false, value -> SystemSessionProperties.validateDoubleValueWithinSelectivityRange(value, DEFAULT_JOIN_SELECTIVITY_COEFFICIENT), object -> object), PropertyMetadata.booleanProperty((String)PUSH_LIMIT_THROUGH_OUTER_JOIN, (String)"push limits to the outer side of an outer join", (Boolean)featuresConfig.isPushLimitThroughOuterJoin(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_CONSTANT_GROUPING_KEYS, (String)"Pull constant grouping keys above the group by", (Boolean)featuresConfig.isOptimizeConstantGroupingKeys(), (boolean)false), PropertyMetadata.integerProperty((String)MAX_CONCURRENT_MATERIALIZATIONS, (String)"Maximum number of materializing plan sections that can run concurrently", (Integer)featuresConfig.getMaxConcurrentMaterializations(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSHDOWN_SUBFIELDS_ENABLED, (String)"Experimental: enable subfield pruning", (Boolean)featuresConfig.isPushdownSubfieldsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSHDOWN_DEREFERENCE_ENABLED, (String)"Experimental: enable dereference pushdown", (Boolean)featuresConfig.isPushdownDereferenceEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)TABLE_WRITER_MERGE_OPERATOR_ENABLED, (String)"Experimental: enable table writer merge operator", (Boolean)featuresConfig.isTableWriterMergeOperatorEnabled(), (boolean)false), new PropertyMetadata(INDEX_LOADER_TIMEOUT, "Timeout for loading indexes for index joins", (Type)VarcharType.VARCHAR, Duration.class, (Object)featuresConfig.getIndexLoaderTimeout(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), PropertyMetadata.booleanProperty((String)OPTIMIZED_REPARTITIONING_ENABLED, (String)"Experimental: Use optimized repartitioning", (Boolean)featuresConfig.isOptimizedRepartitioningEnabled(), (boolean)false), new PropertyMetadata(AGGREGATION_PARTITIONING_MERGING_STRATEGY, String.format("Strategy to merge partition preference in aggregation node. Options are %s", Stream.of(FeaturesConfig.AggregationPartitioningMergingStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.AggregationPartitioningMergingStrategy.class, (Object)featuresConfig.getAggregationPartitioningMergingStrategy(), false, value -> FeaturesConfig.AggregationPartitioningMergingStrategy.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.booleanProperty((String)LIST_BUILT_IN_FUNCTIONS_ONLY, (String)"Only List built-in functions in SHOW FUNCTIONS", (Boolean)featuresConfig.isListBuiltInFunctionsOnly(), (boolean)false), new PropertyMetadata(PARTITIONING_PRECISION_STRATEGY, String.format("The strategy to use to pick when to repartition. Options are %s", Stream.of(FeaturesConfig.PartitioningPrecisionStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.PartitioningPrecisionStrategy.class, (Object)featuresConfig.getPartitioningPrecisionStrategy(), false, value -> FeaturesConfig.PartitioningPrecisionStrategy.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.booleanProperty((String)EXPERIMENTAL_FUNCTIONS_ENABLED, (String)"Enable listing of functions marked as experimental", (Boolean)featuresConfig.isExperimentalFunctionsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_LEGACY_SCHEDULER, (String)"Use version of scheduler before refactorings for section retries", (Boolean)featuresConfig.isUseLegacyScheduler(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_COMMON_SUB_EXPRESSIONS, (String)"Extract and compute common sub-expressions in projection", (Boolean)featuresConfig.isOptimizeCommonSubExpressions(), (boolean)false), PropertyMetadata.booleanProperty((String)PREFER_DISTRIBUTED_UNION, (String)"Prefer distributed union", (Boolean)featuresConfig.isPreferDistributedUnion(), (boolean)true), new PropertyMetadata(WARNING_HANDLING, String.format("The level of warning handling. Levels are %s", Stream.of(WarningHandlingLevel.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, WarningHandlingLevel.class, (Object)warningCollectorConfig.getWarningHandlingLevel(), false, value -> WarningHandlingLevel.valueOf((String)((String)value).toUpperCase()), Enum::name), PropertyMetadata.booleanProperty((String)OPTIMIZE_NULLS_IN_JOINS, (String)"(DEPRECATED) Filter nulls from inner side of join. If this is set, joins_not_null_inference_strategy = 'INFER_FROM_STANDARD_OPERATORS' is assumed", (Boolean)false, (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_PAYLOAD_JOINS, (String)"Optimize joins with payload columns", (Boolean)featuresConfig.isOptimizePayloadJoins(), (boolean)false), new PropertyMetadata(TARGET_RESULT_SIZE, "Target result size for results being streamed from coordinator", (Type)VarcharType.VARCHAR, DataSize.class, null, false, value -> value != null ? DataSize.valueOf((String)((String)value)) : null, value -> value != null ? value.toString() : null), PropertyMetadata.booleanProperty((String)ENABLE_DYNAMIC_FILTERING, (String)"Enable dynamic filtering", (Boolean)featuresConfig.isEnableDynamicFiltering(), (boolean)false), PropertyMetadata.integerProperty((String)DYNAMIC_FILTERING_MAX_PER_DRIVER_ROW_COUNT, (String)"Maximum number of build-side rows to be collected for dynamic filtering per-driver", (Integer)featuresConfig.getDynamicFilteringMaxPerDriverRowCount(), (boolean)false), new PropertyMetadata(DYNAMIC_FILTERING_MAX_PER_DRIVER_SIZE, "Maximum number of bytes to be collected for dynamic filtering per-driver", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getDynamicFilteringMaxPerDriverSize(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.integerProperty((String)DYNAMIC_FILTERING_RANGE_ROW_LIMIT_PER_DRIVER, (String)"Maximum number of build-side rows per driver up to which min and max values will be collected for dynamic filtering", (Integer)featuresConfig.getDynamicFilteringRangeRowLimitPerDriver(), (boolean)false), PropertyMetadata.booleanProperty((String)FRAGMENT_RESULT_CACHING_ENABLED, (String)"Enable fragment result caching and read/write leaf fragment result pages from/to cache when applicable", (Boolean)featuresConfig.isFragmentResultCachingEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SKIP_REDUNDANT_SORT, (String)"Skip redundant sort operations", (Boolean)featuresConfig.isSkipRedundantSort(), (boolean)false), PropertyMetadata.booleanProperty((String)INLINE_SQL_FUNCTIONS, (String)"Inline SQL function definition at plan time", (Boolean)featuresConfig.isInlineSqlFunctions(), (boolean)false), PropertyMetadata.booleanProperty((String)REMOTE_FUNCTIONS_ENABLED, (String)"Allow remote functions", (Boolean)false, (boolean)false), PropertyMetadata.booleanProperty((String)CHECK_ACCESS_CONTROL_ON_UTILIZED_COLUMNS_ONLY, (String)"Apply access control rules on only those columns that are required to produce the query output", (Boolean)featuresConfig.isCheckAccessControlOnUtilizedColumnsOnly(), (boolean)false), PropertyMetadata.booleanProperty((String)CHECK_ACCESS_CONTROL_WITH_SUBFIELDS, (String)"Apply access control rules with subfield information from columns containing row types", (Boolean)featuresConfig.isCheckAccessControlWithSubfields(), (boolean)false), PropertyMetadata.booleanProperty((String)ALLOW_WINDOW_ORDER_BY_LITERALS, (String)"Allow ORDER BY literals in window functions", (Boolean)featuresConfig.isAllowWindowOrderByLiterals(), (boolean)false), PropertyMetadata.booleanProperty((String)ENFORCE_FIXED_DISTRIBUTION_FOR_OUTPUT_OPERATOR, (String)"Enforce fixed distribution for output operator", (Boolean)featuresConfig.isEnforceFixedDistributionForOutputOperator(), (boolean)true), new PropertyMetadata(MAX_UNACKNOWLEDGED_SPLITS_PER_TASK, "Maximum number of leaf splits awaiting delivery to a given task", (Type)IntegerType.INTEGER, Integer.class, (Object)nodeSchedulerConfig.getMaxUnacknowledgedSplitsPerTask(), false, value -> SystemSessionProperties.validateIntegerValue(value, MAX_UNACKNOWLEDGED_SPLITS_PER_TASK, 1, false), object -> object), PropertyMetadata.booleanProperty((String)OPTIMIZE_JOINS_WITH_EMPTY_SOURCES, (String)"(Deprecated) Simplify joins with one or more empty sources", (Boolean)featuresConfig.isEmptyJoinOptimization(), (boolean)false), PropertyMetadata.booleanProperty((String)SPOOLING_OUTPUT_BUFFER_ENABLED, (String)"Enable spooling output buffer for terminal task", (Boolean)featuresConfig.isSpoolingOutputBufferEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SPARK_ASSIGN_BUCKET_TO_PARTITION_FOR_PARTITIONED_TABLE_WRITE_ENABLED, (String)"Assign bucket to partition map for partitioned table write when adding an exchange", (Boolean)featuresConfig.isPrestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled(), (boolean)true), PropertyMetadata.booleanProperty((String)LOG_FORMATTED_QUERY_ENABLED, (String)"Log formatted prepared query instead of raw query when enabled", (Boolean)featuresConfig.isLogFormattedQueryEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)LOG_INVOKED_FUNCTION_NAMES_ENABLED, (String)"Log the names of the functions invoked by the query when enabled.", (Boolean)featuresConfig.isLogInvokedFunctionNamesEnabled(), (boolean)false), new PropertyMetadata(QUERY_RETRY_LIMIT, "Query retry limit due to communication failures", (Type)IntegerType.INTEGER, Integer.class, (Object)queryManagerConfig.getPerQueryRetryLimit(), true, value -> SystemSessionProperties.validateIntegerValue(value, QUERY_RETRY_LIMIT, 0, false), object -> object), new PropertyMetadata(QUERY_RETRY_MAX_EXECUTION_TIME, "Maximum execution time of a query allowed for retry", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getPerQueryRetryMaxExecutionTime(), true, value -> Duration.valueOf((String)((String)value)), Duration::toString), PropertyMetadata.booleanProperty((String)PARTIAL_RESULTS_ENABLED, (String)"Enable returning partial results. Please note that queries might not read all the data when this is enabled", (Boolean)featuresConfig.isPartialResultsEnabled(), (boolean)false), PropertyMetadata.doubleProperty((String)PARTIAL_RESULTS_COMPLETION_RATIO_THRESHOLD, (String)"Minimum query completion ratio threshold for partial results", (Double)featuresConfig.getPartialResultsCompletionRatioThreshold(), (boolean)false), PropertyMetadata.booleanProperty((String)OFFSET_CLAUSE_ENABLED, (String)"Enable support for OFFSET clause", (Boolean)featuresConfig.isOffsetClauseEnabled(), (boolean)true), PropertyMetadata.doubleProperty((String)PARTIAL_RESULTS_MAX_EXECUTION_TIME_MULTIPLIER, (String)"This value is multiplied by the time taken to reach the completion ratio threshold and is set as max task end time", (Double)featuresConfig.getPartialResultsMaxExecutionTimeMultiplier(), (boolean)false), PropertyMetadata.booleanProperty((String)VERBOSE_EXCEEDED_MEMORY_LIMIT_ERRORS_ENABLED, (String)"When enabled the error message for exceeded memory limit errors will contain additional operator memory allocation details", (Boolean)nodeMemoryConfig.isVerboseExceededMemoryLimitErrorsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)MATERIALIZED_VIEW_DATA_CONSISTENCY_ENABLED, (String)"When enabled and reading from materialized view, partition stitching is applied to achieve data consistency", (Boolean)featuresConfig.isMaterializedViewDataConsistencyEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)CONSIDER_QUERY_FILTERS_FOR_MATERIALIZED_VIEW_PARTITIONS, (String)"When enabled and counting materialized view partitions, filters partition domains not in base query", (Boolean)featuresConfig.isMaterializedViewPartitionFilteringEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)QUERY_OPTIMIZATION_WITH_MATERIALIZED_VIEW_ENABLED, (String)"Enable query optimization with materialized view", (Boolean)featuresConfig.isQueryOptimizationWithMaterializedViewEnabled(), (boolean)true), PropertyMetadata.stringProperty((String)DISTRIBUTED_TRACING_MODE, (String)"Mode for distributed tracing. NO_TRACE, ALWAYS_TRACE, or SAMPLE_BASED", (String)tracingConfig.getDistributedTracingMode().name(), (boolean)false), PropertyMetadata.booleanProperty((String)VERBOSE_RUNTIME_STATS_ENABLED, (String)"Enable logging all runtime stats", (Boolean)featuresConfig.isVerboseRuntimeStatsEnabled(), (boolean)false), PropertyMetadata.stringProperty((String)OPTIMIZERS_TO_ENABLE_VERBOSE_RUNTIME_STATS, (String)"Optimizers to enable verbose runtime stats", (String)"", (boolean)false), PropertyMetadata.booleanProperty((String)VERBOSE_OPTIMIZER_INFO_ENABLED, (String)"Enable logging of verbose information about applied optimizations", (Boolean)featuresConfig.isVerboseOptimizerInfoEnabled(), (boolean)false), new PropertyMetadata(VERBOSE_OPTIMIZER_RESULTS, "Print result of selected optimizer(s), allowed values are ALL | NONE | <OptimizerClassName>[,<OptimizerClassName>...]", (Type)VarcharType.VARCHAR, VerboseOptimizerResultsProperty.class, (Object)VerboseOptimizerResultsProperty.disabled(), false, value -> VerboseOptimizerResultsProperty.valueOf((String)value), object -> object), PropertyMetadata.booleanProperty((String)STREAMING_FOR_PARTIAL_AGGREGATION_ENABLED, (String)"Enable streaming for partial aggregation", (Boolean)featuresConfig.isStreamingForPartialAggregationEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)PREFER_MERGE_JOIN_FOR_SORTED_INPUTS, (String)"Prefer merge join for sorted join inputs, e.g., tables pre-sorted, pre-partitioned by join columns.To make it work, the connector needs to guarantee and expose the data properties of the underlying table.", (Boolean)featuresConfig.isPreferMergeJoinForSortedInputs(), (boolean)true), PropertyMetadata.booleanProperty((String)SEGMENTED_AGGREGATION_ENABLED, (String)"Enable segmented aggregation.", (Boolean)featuresConfig.isSegmentedAggregationEnabled(), (boolean)false), new PropertyMetadata(AGGREGATION_IF_TO_FILTER_REWRITE_STRATEGY, String.format("Set the strategy used to rewrite AGG IF to AGG FILTER. Options are %s", Stream.of(FeaturesConfig.AggregationIfToFilterRewriteStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.AggregationIfToFilterRewriteStrategy.class, (Object)featuresConfig.getAggregationIfToFilterRewriteStrategy(), false, value -> FeaturesConfig.AggregationIfToFilterRewriteStrategy.valueOf(((String)value).toUpperCase()), Enum::name), new PropertyMetadata(RESOURCE_AWARE_SCHEDULING_STRATEGY, String.format("Task assignment strategy to use. Options are %s", Stream.of(NodeSchedulerConfig.ResourceAwareSchedulingStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, NodeSchedulerConfig.ResourceAwareSchedulingStrategy.class, (Object)nodeSchedulerConfig.getResourceAwareSchedulingStrategy(), false, value -> NodeSchedulerConfig.ResourceAwareSchedulingStrategy.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.stringProperty((String)ANALYZER_TYPE, (String)"Analyzer type to use.", (String)featuresConfig.getAnalyzerType(), (boolean)true), PropertyMetadata.booleanProperty((String)PRE_PROCESS_METADATA_CALLS, (String)"Pre-process metadata calls before analyzer invocation.", (Boolean)featuresConfig.isPreProcessMetadataCalls(), (boolean)false), PropertyMetadata.booleanProperty((String)HEAP_DUMP_ON_EXCEEDED_MEMORY_LIMIT_ENABLED, (String)"Trigger heap dump to `EXCEEDED_MEMORY_LIMIT_HEAP_DUMP_FILE_PATH` on exceeded memory limit exceptions", (Boolean)false, (boolean)true), PropertyMetadata.stringProperty((String)EXCEEDED_MEMORY_LIMIT_HEAP_DUMP_FILE_DIRECTORY, (String)"Directory to which heap snapshot will be dumped, if heap_dump_on_exceeded_memory_limit_enabled", (String)System.getProperty("java.io.tmpdir"), (boolean)true), PropertyMetadata.booleanProperty((String)KEY_BASED_SAMPLING_ENABLED, (String)"Key based sampling of tables enabled", (Boolean)false, (boolean)false), PropertyMetadata.doubleProperty((String)KEY_BASED_SAMPLING_PERCENTAGE, (String)"Percentage of keys to be sampled", (Double)0.01, (boolean)false), PropertyMetadata.stringProperty((String)KEY_BASED_SAMPLING_FUNCTION, (String)"Sampling function for key based sampling", (String)"key_sampling_percent", (boolean)false), PropertyMetadata.integerProperty((String)MAX_STAGE_COUNT_FOR_EAGER_SCHEDULING, (String)"Maximum stage count to use eager scheduling when using the adaptive scheduling policy", (Integer)featuresConfig.getMaxStageCountForEagerScheduling(), (boolean)false), PropertyMetadata.doubleProperty((String)HYPERLOGLOG_STANDARD_ERROR_WARNING_THRESHOLD, (String)"Threshold for obtaining precise results from aggregation functions", (Double)featuresConfig.getHyperloglogStandardErrorWarningThreshold(), (boolean)false), PropertyMetadata.booleanProperty((String)QUICK_DISTINCT_LIMIT_ENABLED, (String)"Enable quick distinct limit queries that give results as soon as a new distinct value is found", (Boolean)featuresConfig.isQuickDistinctLimitEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_HISTORY_BASED_PLAN_STATISTICS, (String)"Use history based plan statistics service in query optimizer", (Boolean)featuresConfig.isUseHistoryBasedPlanStatistics(), (boolean)false), PropertyMetadata.booleanProperty((String)TRACK_HISTORY_BASED_PLAN_STATISTICS, (String)"Track history based plan statistics service in query optimizer", (Boolean)featuresConfig.isTrackHistoryBasedPlanStatistics(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_PERFECTLY_CONSISTENT_HISTORIES, (String)"Use perfectly consistent histories for history based optimizations, even when parts of a query are re-ordered.", (Boolean)featuresConfig.isUsePerfectlyConsistentHistories(), (boolean)false), PropertyMetadata.integerProperty((String)HISTORY_CANONICAL_PLAN_NODE_LIMIT, (String)"Use history based optimizations only when number of nodes in canonical plan is within this limit. Size of canonical plan can become much larger than original plan leading to increased planning time, particularly in cases when limiting nodes like LimitNode, TopNNode etc. are present.", (Integer)featuresConfig.getHistoryCanonicalPlanNodeLimit(), (boolean)false), new PropertyMetadata(HISTORY_BASED_OPTIMIZER_TIMEOUT_LIMIT, "Timeout in milliseconds for history based optimizer", (Type)VarcharType.VARCHAR, Duration.class, (Object)featuresConfig.getHistoryBasedOptimizerTimeout(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), PropertyMetadata.booleanProperty((String)RESTRICT_HISTORY_BASED_OPTIMIZATION_TO_COMPLEX_QUERY, (String)"Enable history based optimization only for complex queries, i.e. queries with join and aggregation", (Boolean)true, (boolean)false), new PropertyMetadata(MAX_LEAF_NODES_IN_PLAN, "Maximum number of leaf nodes in the logical plan of SQL statement", (Type)IntegerType.INTEGER, Integer.class, (Object)compilerConfig.getLeafNodeLimit(), false, value -> SystemSessionProperties.validateIntegerValue(value, MAX_LEAF_NODES_IN_PLAN, 0, false), object -> object), PropertyMetadata.booleanProperty((String)LEAF_NODE_LIMIT_ENABLED, (String)"Throw exception if the number of leaf nodes in logical plan exceeds threshold set in max_leaf_nodes_in_plan", (Boolean)compilerConfig.getLeafNodeLimitEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_REMOTE_EXCHANGE_THROUGH_GROUP_ID, (String)"Enable optimization rule to push remote exchange through GroupId", (Boolean)featuresConfig.isPushRemoteExchangeThroughGroupId(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_MULTIPLE_APPROX_PERCENTILE_ON_SAME_FIELD, (String)"Combine individual approx_percentile calls on individual field to evaluation on an array", (Boolean)featuresConfig.isOptimizeMultipleApproxPercentileOnSameFieldEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)NATIVE_SIMPLIFIED_EXPRESSION_EVALUATION_ENABLED, (String)"Native Execution only. Enable simplified path in expression evaluation", (Boolean)false, (boolean)false), PropertyMetadata.integerProperty((String)NATIVE_AGGREGATION_SPILL_MEMORY_THRESHOLD, (String)"Native Execution only. The max memory that a final aggregation can use before spilling. If it is 0, then there is no limit", (Integer)0, (boolean)false), PropertyMetadata.integerProperty((String)NATIVE_JOIN_SPILL_MEMORY_THRESHOLD, (String)"Native Execution only. The max memory that hash join can use before spilling. If it is 0, then there is no limit", (Integer)0, (boolean)false), PropertyMetadata.integerProperty((String)NATIVE_ORDER_BY_SPILL_MEMORY_THRESHOLD, (String)"Native Execution only. The max memory that order by can use before spilling. If it is 0, then there is no limit", (Integer)0, (boolean)false), PropertyMetadata.booleanProperty((String)NATIVE_EXECUTION_ENABLED, (String)"Enable execution on native engine", (Boolean)featuresConfig.isNativeExecutionEnabled(), (boolean)false), PropertyMetadata.stringProperty((String)NATIVE_EXECUTION_EXECUTABLE_PATH, (String)"The native engine executable file path for native engine execution", (String)featuresConfig.getNativeExecutionExecutablePath(), (boolean)false), PropertyMetadata.stringProperty((String)NATIVE_EXECUTION_PROGRAM_ARGUMENTS, (String)"Program arguments for native engine execution. The main target use case for this property is to control logging levels using glog flags. E,g, to enable verbose mode, add '--v 1'. More advanced glog gflags usage can be found at https://rpg.ifi.uzh.ch/docs/glog.html\ne.g. --vmodule=mapreduce=2,file=1,gfs*=3 --v=0\nwill:\n\na. Print VLOG(2) and lower messages from mapreduce.{h,cc}\nb. Print VLOG(1) and lower messages from file.{h,cc}\nc. Print VLOG(3) and lower messages from files prefixed with \"gfs\"\nd. Print VLOG(0) and lower messages from elsewhere", (String)featuresConfig.getNativeExecutionProgramArguments(), (boolean)false), PropertyMetadata.booleanProperty((String)NATIVE_EXECUTION_PROCESS_REUSE_ENABLED, (String)"Enable reuse the native process within the same JVM", (Boolean)true, (boolean)false), PropertyMetadata.booleanProperty((String)RANDOMIZE_OUTER_JOIN_NULL_KEY, (String)"(Deprecated) Randomize null join key for outer join", (Boolean)false, (boolean)false), new PropertyMetadata(RANDOMIZE_OUTER_JOIN_NULL_KEY_STRATEGY, String.format("When to apply randomization to join keys in outer joins to mitigate null skew", Stream.of(FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.class, (Object)featuresConfig.getRandomizeOuterJoinNullKeyStrategy(), false, value -> FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.doubleProperty((String)RANDOMIZE_OUTER_JOIN_NULL_KEY_NULL_RATIO_THRESHOLD, (String)"Enable randomizing null join key for outer join when ratio of null join keys exceed the threshold", (Double)0.02, (boolean)false), new PropertyMetadata(SHARDED_JOINS_STRATEGY, String.format("When to shard joins to mitigate skew", Stream.of(FeaturesConfig.ShardedJoinStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.ShardedJoinStrategy.class, (Object)featuresConfig.getShardedJoinStrategy(), false, value -> FeaturesConfig.ShardedJoinStrategy.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.integerProperty((String)JOIN_SHARD_COUNT, (String)"Number of shards to use in sharded joins optimization", (Integer)featuresConfig.getJoinShardCount(), (boolean)true), PropertyMetadata.booleanProperty((String)OPTIMIZE_CONDITIONAL_AGGREGATION_ENABLED, (String)"Enable rewriting IF(condition, AGG(x)) to AGG(x) with condition included in mask", (Boolean)featuresConfig.isOptimizeConditionalAggregationEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)REMOVE_REDUNDANT_DISTINCT_AGGREGATION_ENABLED, (String)"Enable removing distinct aggregation node if input is already distinct", (Boolean)featuresConfig.isRemoveRedundantDistinctAggregationEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)IN_PREDICATES_AS_INNER_JOINS_ENABLED, (String)"Enable transformation of IN predicates to inner joins", (Boolean)featuresConfig.isInPredicatesAsInnerJoinsEnabled(), (boolean)false), PropertyMetadata.doubleProperty((String)PUSH_AGGREGATION_BELOW_JOIN_BYTE_REDUCTION_THRESHOLD, (String)"Byte reduction ratio threshold at which to disable pushdown of aggregation below inner join", (Double)featuresConfig.getPushAggregationBelowJoinByteReductionThreshold(), (boolean)false), PropertyMetadata.booleanProperty((String)PREFILTER_FOR_GROUPBY_LIMIT, (String)"Prefilter aggregation source for queries that have aggregations on simple tables with filters", (Boolean)featuresConfig.isPrefilterForGroupbyLimit(), (boolean)false), PropertyMetadata.integerProperty((String)PREFILTER_FOR_GROUPBY_LIMIT_TIMEOUT_MS, (String)"Timeout for finding the LIMIT number of keys for group by", (Integer)10000, (boolean)false), PropertyMetadata.booleanProperty((String)FIELD_NAMES_IN_JSON_CAST_ENABLED, (String)"Include field names in json output when casting rows", (Boolean)featuresConfig.isFieldNamesInJsonCastEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_JOIN_PROBE_FOR_EMPTY_BUILD_RUNTIME, (String)"Optimize join probe at runtime if build side is empty", (Boolean)featuresConfig.isOptimizeJoinProbeForEmptyBuildRuntimeEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_DEFAULTS_FOR_CORRELATED_AGGREGATION_PUSHDOWN_THROUGH_OUTER_JOINS, (String)"Coalesce with defaults for correlated aggregations", (Boolean)featuresConfig.isUseDefaultsForCorrelatedAggregationPushdownThroughOuterJoins(), (boolean)false), PropertyMetadata.booleanProperty((String)MERGE_DUPLICATE_AGGREGATIONS, (String)"Merge identical aggregation functions within the same aggregation node", (Boolean)featuresConfig.isMergeDuplicateAggregationsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)MERGE_AGGREGATIONS_WITH_AND_WITHOUT_FILTER, (String)"Merge aggregations that are same except for filter", (Boolean)featuresConfig.isMergeAggregationsWithAndWithoutFilter(), (boolean)false), PropertyMetadata.booleanProperty((String)SIMPLIFY_PLAN_WITH_EMPTY_INPUT, (String)"Simplify the query plan with empty input", (Boolean)featuresConfig.isSimplifyPlanWithEmptyInput(), (boolean)false), new PropertyMetadata(PUSH_DOWN_FILTER_EXPRESSION_EVALUATION_THROUGH_CROSS_JOIN, String.format("Push down expression evaluation in filter through cross join", Stream.of(FeaturesConfig.PushDownFilterThroughCrossJoinStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.PushDownFilterThroughCrossJoinStrategy.class, (Object)featuresConfig.getPushDownFilterExpressionEvaluationThroughCrossJoin(), false, value -> FeaturesConfig.PushDownFilterThroughCrossJoinStrategy.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.booleanProperty((String)REWRITE_CROSS_JOIN_OR_TO_INNER_JOIN, (String)"Rewrite cross join with or filter to inner join", (Boolean)featuresConfig.isRewriteCrossJoinWithOrFilterToInnerJoin(), (boolean)false), PropertyMetadata.booleanProperty((String)REWRITE_CROSS_JOIN_ARRAY_CONTAINS_TO_INNER_JOIN, (String)"Rewrite cross join with array contains filter to inner join", (Boolean)featuresConfig.isRewriteCrossJoinWithArrayContainsFilterToInnerJoin(), (boolean)false), PropertyMetadata.booleanProperty((String)REWRITE_CROSS_JOIN_ARRAY_NOT_CONTAINS_TO_ANTI_JOIN, (String)"Rewrite cross join with array not contains filter to anti join", (Boolean)featuresConfig.isRewriteCrossJoinWithArrayNotContainsFilterToAntiJoin(), (boolean)false), new PropertyMetadata(JOINS_NOT_NULL_INFERENCE_STRATEGY, String.format("Set the strategy used NOT NULL filter inference on Join Nodes. Options are: %s", Stream.of(FeaturesConfig.JoinNotNullInferenceStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.JoinNotNullInferenceStrategy.class, (Object)featuresConfig.getJoinsNotNullInferenceStrategy(), false, value -> FeaturesConfig.JoinNotNullInferenceStrategy.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.booleanProperty((String)REWRITE_LEFT_JOIN_NULL_FILTER_TO_SEMI_JOIN, (String)"Rewrite left join with is null check to semi join", (Boolean)featuresConfig.isLeftJoinNullFilterToSemiJoin(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_BROADCAST_WHEN_BUILDSIZE_SMALL_PROBESIDE_UNKNOWN, (String)"Experimental: When probe side size is unknown but build size is within broadcast limit, choose broadcast join", (Boolean)featuresConfig.isBroadcastJoinWithSmallBuildUnknownProbe(), (boolean)false), PropertyMetadata.booleanProperty((String)ADD_PARTIAL_NODE_FOR_ROW_NUMBER_WITH_LIMIT, (String)"Add partial row number node for row number node with limit", (Boolean)featuresConfig.isAddPartialNodeForRowNumberWithLimitEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)REWRITE_CASE_TO_MAP_ENABLED, (String)"Rewrite case with constant WHEN/THEN/ELSE clauses to use map literals", (Boolean)Boolean.TRUE, (boolean)false), PropertyMetadata.booleanProperty((String)PULL_EXPRESSION_FROM_LAMBDA_ENABLED, (String)"Rewrite case with constant WHEN/THEN/ELSE clauses to use map literals", (Boolean)featuresConfig.isPullUpExpressionFromLambdaEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)REWRITE_CONSTANT_ARRAY_CONTAINS_TO_IN_EXPRESSION, (String)"Rewrite contsant array contains to IN expression", (Boolean)featuresConfig.isRewriteConstantArrayContainsToInEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)INFER_INEQUALITY_PREDICATES, (String)"Infer nonequality predicates for joins", (Boolean)featuresConfig.getInferInequalityPredicates(), (boolean)false)});
    }

    public static boolean isSpoolingOutputBufferEnabled(Session session) {
        return session.getSystemProperty(SPOOLING_OUTPUT_BUFFER_ENABLED, Boolean.class);
    }

    public static boolean isSkipRedundantSort(Session session) {
        return session.getSystemProperty(SKIP_REDUNDANT_SORT, Boolean.class);
    }

    public static boolean isAllowWindowOrderByLiterals(Session session) {
        return session.getSystemProperty(ALLOW_WINDOW_ORDER_BY_LITERALS, Boolean.class);
    }

    public static boolean isKeyBasedSamplingEnabled(Session session) {
        return session.getSystemProperty(KEY_BASED_SAMPLING_ENABLED, Boolean.class);
    }

    public static double getKeyBasedSamplingPercentage(Session session) {
        return session.getSystemProperty(KEY_BASED_SAMPLING_PERCENTAGE, Double.class);
    }

    public static String getKeyBasedSamplingFunction(Session session) {
        return session.getSystemProperty(KEY_BASED_SAMPLING_FUNCTION, String.class);
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static String getExecutionPolicy(Session session) {
        return session.getSystemProperty(EXECUTION_POLICY, String.class);
    }

    public static boolean isOptimizeHashGenerationEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_HASH_GENERATION, Boolean.class);
    }

    public static FeaturesConfig.JoinDistributionType getJoinDistributionType(Session session) {
        Boolean distributedJoin = session.getSystemProperty(DISTRIBUTED_JOIN, Boolean.class);
        if (distributedJoin != null) {
            if (!distributedJoin.booleanValue()) {
                return FeaturesConfig.JoinDistributionType.BROADCAST;
            }
            return FeaturesConfig.JoinDistributionType.PARTITIONED;
        }
        return session.getSystemProperty(JOIN_DISTRIBUTION_TYPE, FeaturesConfig.JoinDistributionType.class);
    }

    public static DataSize getJoinMaxBroadcastTableSize(Session session) {
        return session.getSystemProperty(JOIN_MAX_BROADCAST_TABLE_SIZE, DataSize.class);
    }

    public static boolean isSizeBasedJoinDistributionTypeEnabled(Session session) {
        return session.getSystemProperty(SIZE_BASED_JOIN_DISTRIBUTION_TYPE, Boolean.class);
    }

    public static boolean isDistributedIndexJoinEnabled(Session session) {
        return session.getSystemProperty(DISTRIBUTED_INDEX_JOIN, Boolean.class);
    }

    public static int getHashPartitionCount(Session session) {
        return session.getSystemProperty(HASH_PARTITION_COUNT, Integer.class);
    }

    public static String getPartitioningProviderCatalog(Session session) {
        return session.getSystemProperty(PARTITIONING_PROVIDER_CATALOG, String.class);
    }

    public static QueryManagerConfig.ExchangeMaterializationStrategy getExchangeMaterializationStrategy(Session session) {
        return session.getSystemProperty(EXCHANGE_MATERIALIZATION_STRATEGY, QueryManagerConfig.ExchangeMaterializationStrategy.class);
    }

    public static boolean isUseStreamingExchangeForMarkDistinctEnabled(Session session) {
        return session.getSystemProperty(USE_STREAMING_EXCHANGE_FOR_MARK_DISTINCT, Boolean.class);
    }

    public static boolean isGroupedExecutionEnabled(Session session) {
        return session.getSystemProperty(GROUPED_EXECUTION, Boolean.class);
    }

    public static boolean isRecoverableGroupedExecutionEnabled(Session session) {
        return session.getSystemProperty(RECOVERABLE_GROUPED_EXECUTION, Boolean.class);
    }

    public static double getMaxFailedTaskPercentage(Session session) {
        return session.getSystemProperty(MAX_FAILED_TASK_PERCENTAGE, Double.class);
    }

    public static int getMaxStageRetries(Session session) {
        return session.getSystemProperty(MAX_STAGE_RETRIES, Integer.class);
    }

    public static boolean preferStreamingOperators(Session session) {
        return session.getSystemProperty(PREFER_STREAMING_OPERATORS, Boolean.class);
    }

    public static int getTaskWriterCount(Session session) {
        return session.getSystemProperty(TASK_WRITER_COUNT, Integer.class);
    }

    public static int getTaskPartitionedWriterCount(Session session) {
        Integer partitionedWriterCount = session.getSystemProperty(TASK_PARTITIONED_WRITER_COUNT, Integer.class);
        if (partitionedWriterCount != null) {
            return partitionedWriterCount;
        }
        return SystemSessionProperties.getTaskWriterCount(session);
    }

    public static boolean isRedistributeWrites(Session session) {
        return session.getSystemProperty(REDISTRIBUTE_WRITES, Boolean.class);
    }

    public static boolean isScaleWriters(Session session) {
        return session.getSystemProperty(SCALE_WRITERS, Boolean.class);
    }

    public static DataSize getWriterMinSize(Session session) {
        return session.getSystemProperty(WRITER_MIN_SIZE, DataSize.class);
    }

    public static boolean isOptimizedScaleWriterProducerBuffer(Session session) {
        return session.getSystemProperty(OPTIMIZED_SCALE_WRITER_PRODUCER_BUFFER, Boolean.class);
    }

    public static boolean isPushTableWriteThroughUnion(Session session) {
        return session.getSystemProperty(PUSH_TABLE_WRITE_THROUGH_UNION, Boolean.class);
    }

    public static int getTaskConcurrency(Session session) {
        return session.getSystemProperty(TASK_CONCURRENCY, Integer.class);
    }

    public static boolean isShareIndexLoading(Session session) {
        return session.getSystemProperty(TASK_SHARE_INDEX_LOADING, Boolean.class);
    }

    public static boolean isDictionaryAggregationEnabled(Session session) {
        return session.getSystemProperty(DICTIONARY_AGGREGATION, Boolean.class);
    }

    public static boolean isOptimizeMetadataQueries(Session session) {
        return session.getSystemProperty(OPTIMIZE_METADATA_QUERIES, Boolean.class);
    }

    public static boolean isOptimizeMetadataQueriesIgnoreStats(Session session) {
        return session.getSystemProperty(OPTIMIZE_METADATA_QUERIES_IGNORE_STATS, Boolean.class);
    }

    public static int getOptimizeMetadataQueriesCallThreshold(Session session) {
        return session.getSystemProperty(OPTIMIZE_METADATA_QUERIES_CALL_THRESHOLD, Integer.class);
    }

    public static DataSize getQueryMaxMemory(Session session) {
        return session.getSystemProperty(QUERY_MAX_MEMORY, DataSize.class);
    }

    public static DataSize getQueryMaxMemoryPerNode(Session session) {
        return session.getSystemProperty(QUERY_MAX_MEMORY_PER_NODE, DataSize.class);
    }

    public static DataSize getQueryMaxBroadcastMemory(Session session) {
        return session.getSystemProperty(QUERY_MAX_BROADCAST_MEMORY, DataSize.class);
    }

    public static DataSize getQueryMaxTotalMemory(Session session) {
        return session.getSystemProperty(QUERY_MAX_TOTAL_MEMORY, DataSize.class);
    }

    public static DataSize getQueryMaxTotalMemoryPerNode(Session session) {
        return session.getSystemProperty(QUERY_MAX_TOTAL_MEMORY_PER_NODE, DataSize.class);
    }

    public static Duration getQueryMaxRunTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_RUN_TIME, Duration.class);
    }

    public static Duration getQueryMaxExecutionTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_EXECUTION_TIME, Duration.class);
    }

    public static boolean resourceOvercommit(Session session) {
        return session.getSystemProperty(RESOURCE_OVERCOMMIT, Boolean.class);
    }

    public static int getQueryMaxStageCount(Session session) {
        return session.getSystemProperty(QUERY_MAX_STAGE_COUNT, Integer.class);
    }

    public static boolean planWithTableNodePartitioning(Session session) {
        return session.getSystemProperty(PLAN_WITH_TABLE_NODE_PARTITIONING, Boolean.class);
    }

    public static boolean isFastInequalityJoin(Session session) {
        return session.getSystemProperty(FAST_INEQUALITY_JOINS, Boolean.class);
    }

    public static FeaturesConfig.JoinReorderingStrategy getJoinReorderingStrategy(Session session) {
        Boolean reorderJoins = session.getSystemProperty(REORDER_JOINS, Boolean.class);
        if (reorderJoins != null) {
            if (!reorderJoins.booleanValue()) {
                return FeaturesConfig.JoinReorderingStrategy.NONE;
            }
            return FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS;
        }
        return session.getSystemProperty(JOIN_REORDERING_STRATEGY, FeaturesConfig.JoinReorderingStrategy.class);
    }

    public static FeaturesConfig.PartialMergePushdownStrategy getPartialMergePushdownStrategy(Session session) {
        return session.getSystemProperty(PARTIAL_MERGE_PUSHDOWN_STRATEGY, FeaturesConfig.PartialMergePushdownStrategy.class);
    }

    public static int getMaxReorderedJoins(Session session) {
        return session.getSystemProperty(MAX_REORDERED_JOINS, Integer.class);
    }

    public static boolean isColocatedJoinEnabled(Session session) {
        return session.getSystemProperty(COLOCATED_JOIN, Boolean.class);
    }

    public static boolean isSpatialJoinEnabled(Session session) {
        return session.getSystemProperty(SPATIAL_JOIN, Boolean.class);
    }

    public static Optional<String> getSpatialPartitioningTableName(Session session) {
        return Optional.ofNullable(session.getSystemProperty(SPATIAL_PARTITIONING_TABLE_NAME, String.class));
    }

    public static OptionalInt getConcurrentLifespansPerNode(Session session) {
        Integer result = session.getSystemProperty(CONCURRENT_LIFESPANS_PER_NODE, Integer.class);
        if (result == 0) {
            return OptionalInt.empty();
        }
        Preconditions.checkArgument((result > 0 ? 1 : 0) != 0, (Object)"Concurrent lifespans per node must be positive if set to non-zero");
        return OptionalInt.of(result);
    }

    public static int getInitialSplitsPerNode(Session session) {
        return session.getSystemProperty(INITIAL_SPLITS_PER_NODE, Integer.class);
    }

    public static int getQueryPriority(Session session) {
        Integer priority = session.getSystemProperty(QUERY_PRIORITY, Integer.class);
        Preconditions.checkArgument((priority > 0 ? 1 : 0) != 0, (Object)"Query priority must be positive");
        return priority;
    }

    public static Duration getSplitConcurrencyAdjustmentInterval(Session session) {
        return session.getSystemProperty(SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL, Duration.class);
    }

    public static Duration getQueryMaxCpuTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_CPU_TIME, Duration.class);
    }

    public static DataSize getQueryMaxScanRawInputBytes(Session session) {
        return session.getSystemProperty(QUERY_MAX_SCAN_RAW_INPUT_BYTES, DataSize.class);
    }

    public static long getQueryMaxOutputPositions(Session session) {
        return session.getSystemProperty(QUERY_MAX_OUTPUT_POSITIONS, Long.class);
    }

    public static DataSize getQueryMaxOutputSize(Session session) {
        return session.getSystemProperty(QUERY_MAX_OUTPUT_SIZE, DataSize.class);
    }

    public static boolean isSpillEnabled(Session session) {
        return session.getSystemProperty(SPILL_ENABLED, Boolean.class);
    }

    public static boolean isJoinSpillingEnabled(Session session) {
        return session.getSystemProperty(JOIN_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isSpillEnabled(session);
    }

    public static boolean isAggregationSpillEnabled(Session session) {
        return session.getSystemProperty(AGGREGATION_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isSpillEnabled(session);
    }

    public static boolean isTopNSpillEnabled(Session session) {
        return session.getSystemProperty(TOPN_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isSpillEnabled(session);
    }

    public static boolean isDistinctAggregationSpillEnabled(Session session) {
        return session.getSystemProperty(DISTINCT_AGGREGATION_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isAggregationSpillEnabled(session);
    }

    public static boolean isDedupBasedDistinctAggregationSpillEnabled(Session session) {
        return session.getSystemProperty(DEDUP_BASED_DISTINCT_AGGREGATION_SPILL_ENABLED, Boolean.class);
    }

    public static boolean isDistinctAggregationLargeBlockSpillEnabled(Session session) {
        return session.getSystemProperty(DISTINCT_AGGREGATION_LARGE_BLOCK_SPILL_ENABLED, Boolean.class);
    }

    public static DataSize getDistinctAggregationLargeBlockSizeThreshold(Session session) {
        return session.getSystemProperty(DISTINCT_AGGREGATION_LARGE_BLOCK_SIZE_THRESHOLD, DataSize.class);
    }

    public static boolean isOrderByAggregationSpillEnabled(Session session) {
        return session.getSystemProperty(ORDER_BY_AGGREGATION_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isAggregationSpillEnabled(session);
    }

    public static boolean isWindowSpillEnabled(Session session) {
        return session.getSystemProperty(WINDOW_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isSpillEnabled(session);
    }

    public static boolean isOrderBySpillEnabled(Session session) {
        return session.getSystemProperty(ORDER_BY_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isSpillEnabled(session);
    }

    public static DataSize getAggregationOperatorUnspillMemoryLimit(Session session) {
        DataSize memoryLimitForMerge = session.getSystemProperty(AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT, DataSize.class);
        Preconditions.checkArgument((memoryLimitForMerge.toBytes() >= 0L ? 1 : 0) != 0, (String)"%s must be positive", (Object)AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT);
        return memoryLimitForMerge;
    }

    public static DataSize getTopNOperatorUnspillMemoryLimit(Session session) {
        DataSize unspillMemoryLimit = session.getSystemProperty(TOPN_OPERATOR_UNSPILL_MEMORY_LIMIT, DataSize.class);
        Preconditions.checkArgument((unspillMemoryLimit.toBytes() >= 0L ? 1 : 0) != 0, (String)"%s must be positive", (Object)TOPN_OPERATOR_UNSPILL_MEMORY_LIMIT);
        return unspillMemoryLimit;
    }

    public static DataSize getQueryMaxRevocableMemoryPerNode(Session session) {
        return session.getSystemProperty(QUERY_MAX_REVOCABLE_MEMORY_PER_NODE, DataSize.class);
    }

    public static DataSize getTempStorageSpillerBufferSize(Session session) {
        DataSize tempStorageSpillerBufferSize = session.getSystemProperty(TEMP_STORAGE_SPILLER_BUFFER_SIZE, DataSize.class);
        Preconditions.checkArgument((tempStorageSpillerBufferSize.toBytes() >= 0L ? 1 : 0) != 0, (String)"%s must be positive", (Object)TEMP_STORAGE_SPILLER_BUFFER_SIZE);
        return tempStorageSpillerBufferSize;
    }

    public static boolean isOptimizeDistinctAggregationEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_DISTINCT_AGGREGATIONS, Boolean.class);
    }

    public static boolean isLegacyRowFieldOrdinalAccessEnabled(Session session) {
        return session.getSystemProperty(LEGACY_ROW_FIELD_ORDINAL_ACCESS, Boolean.class);
    }

    public static boolean isLegacyMapSubscript(Session session) {
        return session.getSystemProperty(LEGACY_MAP_SUBSCRIPT, Boolean.class);
    }

    public static boolean isNewOptimizerEnabled(Session session) {
        return session.getSystemProperty(ITERATIVE_OPTIMIZER, Boolean.class);
    }

    public static boolean isRuntimeOptimizerEnabled(Session session) {
        return session.getSystemProperty(RUNTIME_OPTIMIZER_ENABLED, Boolean.class);
    }

    @Deprecated
    public static boolean isLegacyTimestamp(Session session) {
        return session.getSystemProperty(LEGACY_TIMESTAMP, Boolean.class);
    }

    public static Duration getOptimizerTimeout(Session session) {
        return session.getSystemProperty(ITERATIVE_OPTIMIZER_TIMEOUT, Duration.class);
    }

    public static Duration getQueryAnalyzerTimeout(Session session) {
        return session.getSystemProperty(QUERY_ANALYZER_TIMEOUT, Duration.class);
    }

    public static boolean isExchangeCompressionEnabled(Session session) {
        return session.getSystemProperty(EXCHANGE_COMPRESSION, Boolean.class);
    }

    public static boolean isExchangeChecksumEnabled(Session session) {
        return session.getSystemProperty(EXCHANGE_CHECKSUM, Boolean.class);
    }

    public static boolean isEnableIntermediateAggregations(Session session) {
        return session.getSystemProperty(ENABLE_INTERMEDIATE_AGGREGATIONS, Boolean.class);
    }

    public static boolean shouldPushAggregationThroughJoin(Session session) {
        return session.getSystemProperty(PUSH_AGGREGATION_THROUGH_JOIN, Boolean.class);
    }

    public static boolean isPushAggregationThroughJoin(Session session) {
        return session.getSystemProperty(PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN, Boolean.class);
    }

    public static boolean isParseDecimalLiteralsAsDouble(Session session) {
        return session.getSystemProperty(PARSE_DECIMAL_LITERALS_AS_DOUBLE, Boolean.class);
    }

    public static boolean isFieldNameInJsonCastEnabled(Session session) {
        return session.getSystemProperty(FIELD_NAMES_IN_JSON_CAST_ENABLED, Boolean.class);
    }

    public static boolean isForceSingleNodeOutput(Session session) {
        return session.getSystemProperty(FORCE_SINGLE_NODE_OUTPUT, Boolean.class);
    }

    public static DataSize getFilterAndProjectMinOutputPageSize(Session session) {
        return session.getSystemProperty(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, DataSize.class);
    }

    public static int getFilterAndProjectMinOutputPageRowCount(Session session) {
        return session.getSystemProperty(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT, Integer.class);
    }

    public static boolean useMarkDistinct(Session session) {
        return session.getSystemProperty(USE_MARK_DISTINCT, Boolean.class);
    }

    public static boolean isExploitConstraints(Session session) {
        return session.getSystemProperty(EXPLOIT_CONSTRAINTS, Boolean.class);
    }

    public static FeaturesConfig.PartialAggregationStrategy getPartialAggregationStrategy(Session session) {
        Boolean preferPartialAggregation = session.getSystemProperty(PREFER_PARTIAL_AGGREGATION, Boolean.class);
        if (preferPartialAggregation != null) {
            if (preferPartialAggregation.booleanValue()) {
                return FeaturesConfig.PartialAggregationStrategy.ALWAYS;
            }
            return FeaturesConfig.PartialAggregationStrategy.NEVER;
        }
        return session.getSystemProperty(PARTIAL_AGGREGATION_STRATEGY, FeaturesConfig.PartialAggregationStrategy.class);
    }

    public static double getPartialAggregationByteReductionThreshold(Session session) {
        return session.getSystemProperty(PARTIAL_AGGREGATION_BYTE_REDUCTION_THRESHOLD, Double.class);
    }

    public static boolean isOptimizeTopNRowNumber(Session session) {
        return session.getSystemProperty(OPTIMIZE_TOP_N_ROW_NUMBER, Boolean.class);
    }

    public static boolean isOptimizeCaseExpressionPredicate(Session session) {
        return session.getSystemProperty(OPTIMIZE_CASE_EXPRESSION_PREDICATE, Boolean.class);
    }

    public static boolean isDistributedSortEnabled(Session session) {
        return session.getSystemProperty(DISTRIBUTED_SORT, Boolean.class);
    }

    public static int getMaxGroupingSets(Session session) {
        return session.getSystemProperty(MAX_GROUPING_SETS, Integer.class);
    }

    public static boolean isLegacyUnnest(Session session) {
        return session.getSystemProperty(LEGACY_UNNEST, Boolean.class);
    }

    public static OptionalInt getMaxDriversPerTask(Session session) {
        Integer value = session.getSystemProperty(MAX_DRIVERS_PER_TASK, Integer.class);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    public static int getMaxTasksPerStage(Session session) {
        return session.getSystemProperty(MAX_TASKS_PER_STAGE, Integer.class);
    }

    private static Integer validateValueIsPowerOfTwo(Object value, String property) {
        Number number = (Number)value;
        if (number == null) {
            return null;
        }
        int intValue = number.intValue();
        if (Integer.bitCount(intValue) != 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be a power of 2: %s", property, intValue));
        }
        return intValue;
    }

    private static Integer validateNullablePositiveIntegerValue(Object value, String property) {
        return SystemSessionProperties.validateIntegerValue(value, property, 1, true);
    }

    private static Integer validateIntegerValue(Object value, String property, int lowerBoundIncluded, boolean allowNull) {
        if (value == null && !allowNull) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be non-null", property));
        }
        if (value == null) {
            return null;
        }
        int intValue = ((Number)value).intValue();
        if (intValue < lowerBoundIncluded) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be equal or greater than %s", property, lowerBoundIncluded));
        }
        return intValue;
    }

    private static Double validateDoubleValueWithinSelectivityRange(Object value, String property) {
        Double number = (Double)value;
        if (number == null) {
            return null;
        }
        double doubleValue = number;
        if (doubleValue < 0.0 || doubleValue > 1.0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be within the range of 0 and 1.0: %s", property, doubleValue));
        }
        return doubleValue;
    }

    public static boolean isStatisticsCpuTimerEnabled(Session session) {
        return session.getSystemProperty(STATISTICS_CPU_TIMER_ENABLED, Boolean.class);
    }

    public static boolean isEnableStatsCalculator(Session session) {
        return session.getSystemProperty(ENABLE_STATS_CALCULATOR, Boolean.class);
    }

    public static boolean isEnableStatsCollectionForTemporaryTable(Session session) {
        return session.getSystemProperty(ENABLE_STATS_COLLECTION_FOR_TEMPORARY_TABLE, Boolean.class);
    }

    public static boolean isIgnoreStatsCalculatorFailures(Session session) {
        return session.getSystemProperty(IGNORE_STATS_CALCULATOR_FAILURES, Boolean.class);
    }

    public static boolean isPrintStatsForNonJoinQuery(Session session) {
        return session.getSystemProperty(PRINT_STATS_FOR_NON_JOIN_QUERY, Boolean.class);
    }

    public static boolean isDefaultFilterFactorEnabled(Session session) {
        return session.getSystemProperty(DEFAULT_FILTER_FACTOR_ENABLED, Boolean.class);
    }

    public static double getDefaultJoinSelectivityCoefficient(Session session) {
        return session.getSystemProperty(DEFAULT_JOIN_SELECTIVITY_COEFFICIENT, Double.class);
    }

    public static boolean isPushLimitThroughOuterJoin(Session session) {
        return session.getSystemProperty(PUSH_LIMIT_THROUGH_OUTER_JOIN, Boolean.class);
    }

    public static boolean isOptimizeConstantGroupingKeys(Session session) {
        return session.getSystemProperty(OPTIMIZE_CONSTANT_GROUPING_KEYS, Boolean.class);
    }

    public static int getMaxConcurrentMaterializations(Session session) {
        return session.getSystemProperty(MAX_CONCURRENT_MATERIALIZATIONS, Integer.class);
    }

    public static boolean isPushdownSubfieldsEnabled(Session session) {
        return session.getSystemProperty(PUSHDOWN_SUBFIELDS_ENABLED, Boolean.class);
    }

    public static boolean isPushdownDereferenceEnabled(Session session) {
        return session.getSystemProperty(PUSHDOWN_DEREFERENCE_ENABLED, Boolean.class);
    }

    public static boolean isTableWriterMergeOperatorEnabled(Session session) {
        return session.getSystemProperty(TABLE_WRITER_MERGE_OPERATOR_ENABLED, Boolean.class);
    }

    public static Duration getIndexLoaderTimeout(Session session) {
        return session.getSystemProperty(INDEX_LOADER_TIMEOUT, Duration.class);
    }

    public static boolean isOptimizedRepartitioningEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZED_REPARTITIONING_ENABLED, Boolean.class);
    }

    public static FeaturesConfig.AggregationPartitioningMergingStrategy getAggregationPartitioningMergingStrategy(Session session) {
        return session.getSystemProperty(AGGREGATION_PARTITIONING_MERGING_STRATEGY, FeaturesConfig.AggregationPartitioningMergingStrategy.class);
    }

    public static boolean isListBuiltInFunctionsOnly(Session session) {
        return session.getSystemProperty(LIST_BUILT_IN_FUNCTIONS_ONLY, Boolean.class);
    }

    public static boolean isExactPartitioningPreferred(Session session) {
        return session.getSystemProperty(PARTITIONING_PRECISION_STRATEGY, FeaturesConfig.PartitioningPrecisionStrategy.class) == FeaturesConfig.PartitioningPrecisionStrategy.PREFER_EXACT_PARTITIONING;
    }

    public static boolean isExperimentalFunctionsEnabled(Session session) {
        return session.getSystemProperty(EXPERIMENTAL_FUNCTIONS_ENABLED, Boolean.class);
    }

    public static boolean isUseLegacyScheduler(Session session) {
        return session.getSystemProperty(USE_LEGACY_SCHEDULER, Boolean.class);
    }

    public static boolean isOptimizeCommonSubExpressions(Session session) {
        return session.getSystemProperty(OPTIMIZE_COMMON_SUB_EXPRESSIONS, Boolean.class);
    }

    public static boolean isPreferDistributedUnion(Session session) {
        return session.getSystemProperty(PREFER_DISTRIBUTED_UNION, Boolean.class);
    }

    public static WarningHandlingLevel getWarningHandlingLevel(Session session) {
        return session.getSystemProperty(WARNING_HANDLING, WarningHandlingLevel.class);
    }

    public static boolean isOptimizePayloadJoins(Session session) {
        return session.getSystemProperty(OPTIMIZE_PAYLOAD_JOINS, Boolean.class);
    }

    public static FeaturesConfig.JoinNotNullInferenceStrategy getNotNullInferenceStrategy(Session session) {
        if (session.getSystemProperty(OPTIMIZE_NULLS_IN_JOINS, Boolean.class).booleanValue()) {
            return FeaturesConfig.JoinNotNullInferenceStrategy.INFER_FROM_STANDARD_OPERATORS;
        }
        return session.getSystemProperty(JOINS_NOT_NULL_INFERENCE_STRATEGY, FeaturesConfig.JoinNotNullInferenceStrategy.class);
    }

    public static Optional<DataSize> getTargetResultSize(Session session) {
        return Optional.ofNullable(session.getSystemProperty(TARGET_RESULT_SIZE, DataSize.class));
    }

    public static boolean isEnableDynamicFiltering(Session session) {
        return session.getSystemProperty(ENABLE_DYNAMIC_FILTERING, Boolean.class);
    }

    public static int getDynamicFilteringMaxPerDriverRowCount(Session session) {
        return session.getSystemProperty(DYNAMIC_FILTERING_MAX_PER_DRIVER_ROW_COUNT, Integer.class);
    }

    public static DataSize getDynamicFilteringMaxPerDriverSize(Session session) {
        return session.getSystemProperty(DYNAMIC_FILTERING_MAX_PER_DRIVER_SIZE, DataSize.class);
    }

    public static int getDynamicFilteringRangeRowLimitPerDriver(Session session) {
        return session.getSystemProperty(DYNAMIC_FILTERING_RANGE_ROW_LIMIT_PER_DRIVER, Integer.class);
    }

    public static boolean isFragmentResultCachingEnabled(Session session) {
        return session.getSystemProperty(FRAGMENT_RESULT_CACHING_ENABLED, Boolean.class);
    }

    public static boolean isInlineSqlFunctions(Session session) {
        return session.getSystemProperty(INLINE_SQL_FUNCTIONS, Boolean.class);
    }

    public static boolean isRemoteFunctionsEnabled(Session session) {
        return session.getSystemProperty(REMOTE_FUNCTIONS_ENABLED, Boolean.class);
    }

    public static boolean isCheckAccessControlOnUtilizedColumnsOnly(Session session) {
        return session.getSystemProperty(CHECK_ACCESS_CONTROL_ON_UTILIZED_COLUMNS_ONLY, Boolean.class);
    }

    public static boolean isCheckAccessControlWithSubfields(Session session) {
        return session.getSystemProperty(CHECK_ACCESS_CONTROL_WITH_SUBFIELDS, Boolean.class);
    }

    public static boolean isEnforceFixedDistributionForOutputOperator(Session session) {
        return session.getSystemProperty(ENFORCE_FIXED_DISTRIBUTION_FOR_OUTPUT_OPERATOR, Boolean.class);
    }

    public static int getMaxUnacknowledgedSplitsPerTask(Session session) {
        return session.getSystemProperty(MAX_UNACKNOWLEDGED_SPLITS_PER_TASK, Integer.class);
    }

    public static boolean isPrestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled(Session session) {
        return session.getSystemProperty(SPARK_ASSIGN_BUCKET_TO_PARTITION_FOR_PARTITIONED_TABLE_WRITE_ENABLED, Boolean.class);
    }

    public static boolean isLogFormattedQueryEnabled(Session session) {
        return session.getSystemProperty(LOG_FORMATTED_QUERY_ENABLED, Boolean.class);
    }

    public static boolean isLogInvokedFunctionNamesEnabled(Session session) {
        return session.getSystemProperty(LOG_INVOKED_FUNCTION_NAMES_ENABLED, Boolean.class);
    }

    public static int getQueryRetryLimit(Session session) {
        return session.getSystemProperty(QUERY_RETRY_LIMIT, Integer.class);
    }

    public static Duration getQueryRetryMaxExecutionTime(Session session) {
        return session.getSystemProperty(QUERY_RETRY_MAX_EXECUTION_TIME, Duration.class);
    }

    public static boolean isPartialResultsEnabled(Session session) {
        return session.getSystemProperty(PARTIAL_RESULTS_ENABLED, Boolean.class);
    }

    public static double getPartialResultsCompletionRatioThreshold(Session session) {
        return session.getSystemProperty(PARTIAL_RESULTS_COMPLETION_RATIO_THRESHOLD, Double.class);
    }

    public static double getPartialResultsMaxExecutionTimeMultiplier(Session session) {
        return session.getSystemProperty(PARTIAL_RESULTS_MAX_EXECUTION_TIME_MULTIPLIER, Double.class);
    }

    public static boolean isOffsetClauseEnabled(Session session) {
        return session.getSystemProperty(OFFSET_CLAUSE_ENABLED, Boolean.class);
    }

    public static boolean isVerboseExceededMemoryLimitErrorsEnabled(Session session) {
        return session.getSystemProperty(VERBOSE_EXCEEDED_MEMORY_LIMIT_ERRORS_ENABLED, Boolean.class);
    }

    public static boolean isMaterializedViewDataConsistencyEnabled(Session session) {
        return session.getSystemProperty(MATERIALIZED_VIEW_DATA_CONSISTENCY_ENABLED, Boolean.class);
    }

    public static boolean isMaterializedViewPartitionFilteringEnabled(Session session) {
        return session.getSystemProperty(CONSIDER_QUERY_FILTERS_FOR_MATERIALIZED_VIEW_PARTITIONS, Boolean.class);
    }

    public static boolean isQueryOptimizationWithMaterializedViewEnabled(Session session) {
        return session.getSystemProperty(QUERY_OPTIMIZATION_WITH_MATERIALIZED_VIEW_ENABLED, Boolean.class);
    }

    public static boolean isVerboseRuntimeStatsEnabled(Session session) {
        return session.getSystemProperty(VERBOSE_RUNTIME_STATS_ENABLED, Boolean.class);
    }

    public static String getOptimizersToEnableVerboseRuntimeStats(Session session) {
        return session.getSystemProperty(OPTIMIZERS_TO_ENABLE_VERBOSE_RUNTIME_STATS, String.class);
    }

    public static boolean isVerboseOptimizerResults(Session session) {
        return session.getSystemProperty(VERBOSE_OPTIMIZER_RESULTS, VerboseOptimizerResultsProperty.class).isEnabled();
    }

    public static boolean isVerboseOptimizerResults(Session session, String optimizer) {
        return session.getSystemProperty(VERBOSE_OPTIMIZER_RESULTS, VerboseOptimizerResultsProperty.class).containsOptimizer(optimizer);
    }

    public static boolean isVerboseOptimizerInfoEnabled(Session session) {
        return session.getSystemProperty(VERBOSE_OPTIMIZER_INFO_ENABLED, Boolean.class);
    }

    public static boolean isLeafNodeLimitEnabled(Session session) {
        return session.getSystemProperty(LEAF_NODE_LIMIT_ENABLED, Boolean.class);
    }

    public static int getMaxLeafNodesInPlan(Session session) {
        return session.getSystemProperty(MAX_LEAF_NODES_IN_PLAN, Integer.class);
    }

    public static boolean isStreamingForPartialAggregationEnabled(Session session) {
        return session.getSystemProperty(STREAMING_FOR_PARTIAL_AGGREGATION_ENABLED, Boolean.class);
    }

    public static boolean preferMergeJoinForSortedInputs(Session session) {
        return session.getSystemProperty(PREFER_MERGE_JOIN_FOR_SORTED_INPUTS, Boolean.class);
    }

    public static boolean isSegmentedAggregationEnabled(Session session) {
        return session.getSystemProperty(SEGMENTED_AGGREGATION_ENABLED, Boolean.class);
    }

    public static boolean isCombineApproxPercentileEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_MULTIPLE_APPROX_PERCENTILE_ON_SAME_FIELD, Boolean.class);
    }

    public static FeaturesConfig.AggregationIfToFilterRewriteStrategy getAggregationIfToFilterRewriteStrategy(Session session) {
        return session.getSystemProperty(AGGREGATION_IF_TO_FILTER_REWRITE_STRATEGY, FeaturesConfig.AggregationIfToFilterRewriteStrategy.class);
    }

    public static NodeSchedulerConfig.ResourceAwareSchedulingStrategy getResourceAwareSchedulingStrategy(Session session) {
        return session.getSystemProperty(RESOURCE_AWARE_SCHEDULING_STRATEGY, NodeSchedulerConfig.ResourceAwareSchedulingStrategy.class);
    }

    public static String getAnalyzerType(Session session) {
        return session.getSystemProperty(ANALYZER_TYPE, String.class);
    }

    public static Boolean isPreProcessMetadataCalls(Session session) {
        return session.getSystemProperty(PRE_PROCESS_METADATA_CALLS, Boolean.class);
    }

    public static Boolean isHeapDumpOnExceededMemoryLimitEnabled(Session session) {
        return session.getSystemProperty(HEAP_DUMP_ON_EXCEEDED_MEMORY_LIMIT_ENABLED, Boolean.class);
    }

    public static String getHeapDumpFileDirectory(Session session) {
        return session.getSystemProperty(EXCEEDED_MEMORY_LIMIT_HEAP_DUMP_FILE_DIRECTORY, String.class);
    }

    public static int getMaxStageCountForEagerScheduling(Session session) {
        return session.getSystemProperty(MAX_STAGE_COUNT_FOR_EAGER_SCHEDULING, Integer.class);
    }

    public static double getHyperloglogStandardErrorWarningThreshold(Session session) {
        return session.getSystemProperty(HYPERLOGLOG_STANDARD_ERROR_WARNING_THRESHOLD, Double.class);
    }

    public static boolean isQuickDistinctLimitEnabled(Session session) {
        return session.getSystemProperty(QUICK_DISTINCT_LIMIT_ENABLED, Boolean.class);
    }

    public static boolean useHistoryBasedPlanStatisticsEnabled(Session session) {
        return session.getSystemProperty(USE_HISTORY_BASED_PLAN_STATISTICS, Boolean.class);
    }

    public static boolean trackHistoryBasedPlanStatisticsEnabled(Session session) {
        return session.getSystemProperty(TRACK_HISTORY_BASED_PLAN_STATISTICS, Boolean.class);
    }

    public static boolean usePerfectlyConsistentHistories(Session session) {
        return session.getSystemProperty(USE_PERFECTLY_CONSISTENT_HISTORIES, Boolean.class);
    }

    public static int getHistoryCanonicalPlanNodeLimit(Session session) {
        return session.getSystemProperty(HISTORY_CANONICAL_PLAN_NODE_LIMIT, Integer.class);
    }

    public static Duration getHistoryBasedOptimizerTimeoutLimit(Session session) {
        return session.getSystemProperty(HISTORY_BASED_OPTIMIZER_TIMEOUT_LIMIT, Duration.class);
    }

    public static boolean restrictHistoryBasedOptimizationToComplexQuery(Session session) {
        return session.getSystemProperty(RESTRICT_HISTORY_BASED_OPTIMIZATION_TO_COMPLEX_QUERY, Boolean.class);
    }

    public static boolean shouldPushRemoteExchangeThroughGroupId(Session session) {
        return session.getSystemProperty(PUSH_REMOTE_EXCHANGE_THROUGH_GROUP_ID, Boolean.class);
    }

    public static boolean isNativeExecutionEnabled(Session session) {
        return session.getSystemProperty(NATIVE_EXECUTION_ENABLED, Boolean.class);
    }

    public static String getNativeExecutionExecutablePath(Session session) {
        return session.getSystemProperty(NATIVE_EXECUTION_EXECUTABLE_PATH, String.class);
    }

    public static String getNativeExecutionProgramArguments(Session session) {
        return session.getSystemProperty(NATIVE_EXECUTION_PROGRAM_ARGUMENTS, String.class);
    }

    public static boolean isNativeExecutionProcessReuseEnabled(Session session) {
        return session.getSystemProperty(NATIVE_EXECUTION_PROCESS_REUSE_ENABLED, Boolean.class);
    }

    public static FeaturesConfig.RandomizeOuterJoinNullKeyStrategy getRandomizeOuterJoinNullKeyStrategy(Session session) {
        if (session.getSystemProperty(RANDOMIZE_OUTER_JOIN_NULL_KEY, Boolean.class).booleanValue()) {
            return FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.ALWAYS;
        }
        return session.getSystemProperty(RANDOMIZE_OUTER_JOIN_NULL_KEY_STRATEGY, FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.class);
    }

    public static double getRandomizeOuterJoinNullKeyNullRatioThreshold(Session session) {
        return session.getSystemProperty(RANDOMIZE_OUTER_JOIN_NULL_KEY_NULL_RATIO_THRESHOLD, Double.class);
    }

    public static FeaturesConfig.ShardedJoinStrategy getShardedJoinStrategy(Session session) {
        return session.getSystemProperty(SHARDED_JOINS_STRATEGY, FeaturesConfig.ShardedJoinStrategy.class);
    }

    public static int getJoinShardCount(Session session) {
        return session.getSystemProperty(JOIN_SHARD_COUNT, Integer.class);
    }

    public static boolean isOptimizeConditionalAggregationEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_CONDITIONAL_AGGREGATION_ENABLED, Boolean.class);
    }

    public static boolean isRemoveRedundantDistinctAggregationEnabled(Session session) {
        return session.getSystemProperty(REMOVE_REDUNDANT_DISTINCT_AGGREGATION_ENABLED, Boolean.class);
    }

    public static boolean isPrefilterForGroupbyLimit(Session session) {
        return session.getSystemProperty(PREFILTER_FOR_GROUPBY_LIMIT, Boolean.class);
    }

    public static boolean isMergeAggregationsWithAndWithoutFilter(Session session) {
        return session.getSystemProperty(MERGE_AGGREGATIONS_WITH_AND_WITHOUT_FILTER, Boolean.class);
    }

    public static boolean isInPredicatesAsInnerJoinsEnabled(Session session) {
        return session.getSystemProperty(IN_PREDICATES_AS_INNER_JOINS_ENABLED, Boolean.class);
    }

    public static double getPushAggregationBelowJoinByteReductionThreshold(Session session) {
        return session.getSystemProperty(PUSH_AGGREGATION_BELOW_JOIN_BYTE_REDUCTION_THRESHOLD, Double.class);
    }

    public static int getPrefilterForGroupbyLimitTimeoutMS(Session session) {
        return session.getSystemProperty(PREFILTER_FOR_GROUPBY_LIMIT_TIMEOUT_MS, Integer.class);
    }

    public static boolean isOptimizeJoinProbeForEmptyBuildRuntimeEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_JOIN_PROBE_FOR_EMPTY_BUILD_RUNTIME, Boolean.class);
    }

    public static boolean useDefaultsForCorrelatedAggregationPushdownThroughOuterJoins(Session session) {
        return session.getSystemProperty(USE_DEFAULTS_FOR_CORRELATED_AGGREGATION_PUSHDOWN_THROUGH_OUTER_JOINS, Boolean.class);
    }

    public static boolean isMergeDuplicateAggregationsEnabled(Session session) {
        return session.getSystemProperty(MERGE_DUPLICATE_AGGREGATIONS, Boolean.class);
    }

    public static boolean isSimplifyPlanWithEmptyInputEnabled(Session session) {
        return session.getSystemProperty(SIMPLIFY_PLAN_WITH_EMPTY_INPUT, Boolean.class) != false || session.getSystemProperty(OPTIMIZE_JOINS_WITH_EMPTY_SOURCES, Boolean.class) != false;
    }

    public static FeaturesConfig.PushDownFilterThroughCrossJoinStrategy getPushdownFilterExpressionEvaluationThroughCrossJoinStrategy(Session session) {
        return session.getSystemProperty(PUSH_DOWN_FILTER_EXPRESSION_EVALUATION_THROUGH_CROSS_JOIN, FeaturesConfig.PushDownFilterThroughCrossJoinStrategy.class);
    }

    public static boolean isRewriteCrossJoinOrToInnerJoinEnabled(Session session) {
        return session.getSystemProperty(REWRITE_CROSS_JOIN_OR_TO_INNER_JOIN, Boolean.class);
    }

    public static boolean isRewriteCrossJoinArrayContainsToInnerJoinEnabled(Session session) {
        return session.getSystemProperty(REWRITE_CROSS_JOIN_ARRAY_CONTAINS_TO_INNER_JOIN, Boolean.class);
    }

    public static boolean isRewriteCrossJoinArrayNotContainsToAntiJoinEnabled(Session session) {
        return session.getSystemProperty(REWRITE_CROSS_JOIN_ARRAY_NOT_CONTAINS_TO_ANTI_JOIN, Boolean.class);
    }

    public static boolean isRewriteLeftJoinNullFilterToSemiJoinEnabled(Session session) {
        return session.getSystemProperty(REWRITE_LEFT_JOIN_NULL_FILTER_TO_SEMI_JOIN, Boolean.class);
    }

    public static boolean isUseBroadcastJoinWhenBuildSizeSmallProbeSizeUnknownEnabled(Session session) {
        return session.getSystemProperty(USE_BROADCAST_WHEN_BUILDSIZE_SMALL_PROBESIDE_UNKNOWN, Boolean.class);
    }

    public static boolean isAddPartialNodeForRowNumberWithLimit(Session session) {
        return session.getSystemProperty(ADD_PARTIAL_NODE_FOR_ROW_NUMBER_WITH_LIMIT, Boolean.class);
    }

    public static boolean isRewriteCaseToMapEnabled(Session session) {
        return session.getSystemProperty(REWRITE_CASE_TO_MAP_ENABLED, Boolean.class);
    }

    public static boolean isPullExpressionFromLambdaEnabled(Session session) {
        return session.getSystemProperty(PULL_EXPRESSION_FROM_LAMBDA_ENABLED, Boolean.class);
    }

    public static boolean isRwriteConstantArrayContainsToInExpressionEnabled(Session session) {
        return session.getSystemProperty(REWRITE_CONSTANT_ARRAY_CONTAINS_TO_IN_EXPRESSION, Boolean.class);
    }

    public static boolean shouldInferInequalityPredicates(Session session) {
        return session.getSystemProperty(INFER_INEQUALITY_PREDICATES, Boolean.class);
    }
}

