/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.airlift.http.server.BasicPrincipal;
import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.Session;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.spi.security.TokenAuthenticator;
import com.facebook.presto.spi.session.ResourceEstimates;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@ThriftStruct
public final class SessionRepresentation {
    private final String queryId;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final String user;
    private final Optional<String> principal;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final Optional<String> traceToken;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final Optional<String> clientInfo;
    private final Set<String> clientTags;
    private final long startTime;
    private final ResourceEstimates resourceEstimates;
    private final Map<String, String> systemProperties;
    private final Map<ConnectorId, Map<String, String>> catalogProperties;
    private final Map<String, Map<String, String>> unprocessedCatalogProperties;
    private final Map<String, SelectedRole> roles;
    private final Map<String, String> preparedStatements;
    private final Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions;

    @ThriftConstructor
    @JsonCreator
    public SessionRepresentation(@JsonProperty(value="queryId") String queryId, @JsonProperty(value="transactionId") Optional<TransactionId> transactionId, @JsonProperty(value="clientTransactionSupport") boolean clientTransactionSupport, @JsonProperty(value="user") String user, @JsonProperty(value="principal") Optional<String> principal, @JsonProperty(value="source") Optional<String> source, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="traceToken") Optional<String> traceToken, @JsonProperty(value="timeZoneKey") TimeZoneKey timeZoneKey, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="remoteUserAddress") Optional<String> remoteUserAddress, @JsonProperty(value="userAgent") Optional<String> userAgent, @JsonProperty(value="clientInfo") Optional<String> clientInfo, @JsonProperty(value="clientTags") Set<String> clientTags, @JsonProperty(value="resourceEstimates") ResourceEstimates resourceEstimates, @JsonProperty(value="startTime") long startTime, @JsonProperty(value="systemProperties") Map<String, String> systemProperties, @JsonProperty(value="catalogProperties") Map<ConnectorId, Map<String, String>> catalogProperties, @JsonProperty(value="unprocessedCatalogProperties") Map<String, Map<String, String>> unprocessedCatalogProperties, @JsonProperty(value="roles") Map<String, SelectedRole> roles, @JsonProperty(value="preparedStatements") Map<String, String> preparedStatements, @JsonProperty(value="sessionFunctions") Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.clientTransactionSupport = clientTransactionSupport;
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = Objects.requireNonNull(clientTags, "clientTags is null");
        this.resourceEstimates = Objects.requireNonNull(resourceEstimates, "resourceEstimates is null");
        this.startTime = startTime;
        this.systemProperties = ImmutableMap.copyOf(systemProperties);
        this.roles = ImmutableMap.copyOf(roles);
        this.preparedStatements = ImmutableMap.copyOf(preparedStatements);
        this.sessionFunctions = ImmutableMap.copyOf(sessionFunctions);
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        for (Map.Entry<ConnectorId, Map<String, String>> entry : catalogProperties.entrySet()) {
            catalogPropertiesBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
        }
        this.catalogProperties = catalogPropertiesBuilder.build();
        ImmutableMap.Builder unprocessedCatalogPropertiesBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, String>> entry : unprocessedCatalogProperties.entrySet()) {
            unprocessedCatalogPropertiesBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
        }
        this.unprocessedCatalogProperties = unprocessedCatalogPropertiesBuilder.build();
    }

    @ThriftField(value=1)
    @JsonProperty
    public String getQueryId() {
        return this.queryId;
    }

    @ThriftField(value=2)
    @JsonProperty
    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    @ThriftField(value=3)
    @JsonProperty
    public boolean isClientTransactionSupport() {
        return this.clientTransactionSupport;
    }

    @ThriftField(value=4)
    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @ThriftField(value=5)
    @JsonProperty
    public Optional<String> getPrincipal() {
        return this.principal;
    }

    @ThriftField(value=6)
    @JsonProperty
    public Optional<String> getSource() {
        return this.source;
    }

    @ThriftField(value=7)
    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @ThriftField(value=8)
    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @ThriftField(value=9)
    @JsonProperty
    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    @ThriftField(value=10)
    @JsonProperty
    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @ThriftField(value=11)
    @JsonProperty
    public Locale getLocale() {
        return this.locale;
    }

    @ThriftField(value=12)
    @JsonProperty
    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @ThriftField(value=13)
    @JsonProperty
    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    @ThriftField(value=14)
    @JsonProperty
    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    @ThriftField(value=15)
    @JsonProperty
    public Set<String> getClientTags() {
        return this.clientTags;
    }

    @ThriftField(value=16)
    @JsonProperty
    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    @ThriftField(value=17)
    @JsonProperty
    public long getStartTime() {
        return this.startTime;
    }

    @ThriftField(value=18)
    @JsonProperty
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @ThriftField(value=19)
    @JsonProperty
    public Map<ConnectorId, Map<String, String>> getCatalogProperties() {
        return this.catalogProperties;
    }

    @ThriftField(value=20)
    @JsonProperty
    public Map<String, Map<String, String>> getUnprocessedCatalogProperties() {
        return this.unprocessedCatalogProperties;
    }

    @ThriftField(value=21)
    @JsonProperty
    public Map<String, SelectedRole> getRoles() {
        return this.roles;
    }

    @ThriftField(value=22)
    @JsonProperty
    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    @ThriftField(value=23)
    @JsonProperty
    public Map<SqlFunctionId, SqlInvokedFunction> getSessionFunctions() {
        return this.sessionFunctions;
    }

    public Session toSession(SessionPropertyManager sessionPropertyManager) {
        return this.toSession(sessionPropertyManager, Collections.emptyMap(), Collections.emptyMap());
    }

    public Session toSession(SessionPropertyManager sessionPropertyManager, Map<String, String> extraCredentials) {
        return this.toSession(sessionPropertyManager, extraCredentials, Collections.emptyMap());
    }

    public Session toSession(SessionPropertyManager sessionPropertyManager, Map<String, String> extraCredentials, Map<String, TokenAuthenticator> extraAuthenticators) {
        return new Session(new QueryId(this.queryId), this.transactionId, this.clientTransactionSupport, new Identity(this.user, this.principal.map(BasicPrincipal::new), this.roles, extraCredentials, extraAuthenticators, Optional.empty(), Optional.empty()), this.source, this.catalog, this.schema, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.resourceEstimates, this.startTime, this.systemProperties, this.catalogProperties, this.unprocessedCatalogProperties, sessionPropertyManager, this.preparedStatements, this.sessionFunctions, Optional.empty(), WarningCollector.NOOP);
    }
}

