/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.bytecode.ByteCodeTooLargeException;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.ClassGenerator;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.lang.invoke.MethodHandle;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public final class CompilerUtils {
    private static final Logger log = Logger.get(CompilerUtils.class);
    private static final AtomicLong CLASS_ID = new AtomicLong();
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("YYYYMMdd_HHmmss");
    public static final String ERROR_LARGE_BYTECODE = "Query results in large bytecode exceeding the limits imposed by JVM";

    private CompilerUtils() {
    }

    public static ParameterizedType makeClassName(String baseName, Optional<String> suffix) {
        String className = baseName.length() > 100 ? baseName.substring(0, 100) : baseName + "_" + suffix.orElseGet(() -> Instant.now().atZone(ZoneOffset.UTC).format(TIMESTAMP_FORMAT)) + "_" + CLASS_ID.incrementAndGet();
        return ParameterizedType.typeFromJavaClassName((String)("com.facebook.presto.$gen." + BytecodeUtils.toJavaIdentifierString((String)className)));
    }

    public static ParameterizedType makeClassName(String baseName) {
        return CompilerUtils.makeClassName(baseName, Optional.empty());
    }

    public static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, Map<Long, MethodHandle> callSiteBindings, ClassLoader parentClassLoader) {
        return CompilerUtils.defineClass(classDefinition, superType, new DynamicClassLoader(parentClassLoader, callSiteBindings));
    }

    public static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, DynamicClassLoader classLoader) {
        log.debug("Defining class: %s", new Object[]{classDefinition.getName()});
        try {
            return ClassGenerator.classGenerator((DynamicClassLoader)classLoader).defineClass(classDefinition, superType);
        }
        catch (ByteCodeTooLargeException byteCodeTooLargeException) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERATED_BYTECODE_TOO_LARGE, ERROR_LARGE_BYTECODE);
        }
    }
}

