/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.sql.analyzer.MaterializedViewQueryOptimizer;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MaterializedViewOptimizationRewrite
implements StatementRewrite.Rewrite {
    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector) {
        return (Statement)new Visitor(metadata, session, parser, accessControl).process((Node)node, null);
    }

    private static Query optimizeQueryUsingMaterializedView(Metadata metadata, Session session, SqlParser sqlParser, AccessControl accessControl, Query node) {
        Query rewritten = (Query)new MaterializedViewQueryOptimizer(metadata, session, sqlParser, accessControl, new RowExpressionDomainTranslator(metadata)).process((Node)node);
        if (rewritten != node) {
            session.getRuntimeStats().addMetricValue("optimizedWithMaterializedViewCount", RuntimeUnit.NONE, 1L);
            return rewritten;
        }
        return node;
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Metadata metadata;
        private final Session session;
        private final SqlParser sqlParser;
        private final AccessControl accessControl;

        public Visitor(Metadata metadata, Session session, SqlParser parser, AccessControl accessControl) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.sqlParser = Objects.requireNonNull(parser, "queryPreparer is null");
            this.accessControl = Objects.requireNonNull(accessControl, "access control is null");
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }

        protected Node visitQuery(Query query, Void context) {
            if (SystemSessionProperties.isQueryOptimizationWithMaterializedViewEnabled(this.session)) {
                return MaterializedViewOptimizationRewrite.optimizeQueryUsingMaterializedView(this.metadata, this.session, this.sqlParser, this.accessControl, query);
            }
            return query;
        }
    }
}

