/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.optimizations.ApplyNodeUtil;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ApplyNode
extends InternalPlanNode {
    private final PlanNode input;
    private final PlanNode subquery;
    private final List<VariableReferenceExpression> correlation;
    private final Assignments subqueryAssignments;
    private final String originSubqueryError;

    @JsonCreator
    public ApplyNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="input") PlanNode input, @JsonProperty(value="subquery") PlanNode subquery, @JsonProperty(value="subqueryAssignments") Assignments subqueryAssignments, @JsonProperty(value="correlation") List<VariableReferenceExpression> correlation, @JsonProperty(value="originSubqueryError") String originSubqueryError) {
        this(sourceLocation, id, Optional.empty(), input, subquery, subqueryAssignments, correlation, originSubqueryError);
    }

    public ApplyNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode input, PlanNode subquery, Assignments subqueryAssignments, List<VariableReferenceExpression> correlation, String originSubqueryError) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Preconditions.checkArgument((boolean)input.getOutputVariables().containsAll(correlation), (Object)"Input does not contain symbols from correlation");
        ApplyNodeUtil.verifySubquerySupported(subqueryAssignments);
        this.input = Objects.requireNonNull(input, "input is null");
        this.subquery = Objects.requireNonNull(subquery, "subquery is null");
        this.subqueryAssignments = Objects.requireNonNull(subqueryAssignments, "assignments is null");
        this.correlation = ImmutableList.copyOf((Collection)Objects.requireNonNull(correlation, "correlation is null"));
        this.originSubqueryError = Objects.requireNonNull(originSubqueryError, "originSubqueryError is null");
    }

    @JsonProperty
    public PlanNode getInput() {
        return this.input;
    }

    @JsonProperty
    public PlanNode getSubquery() {
        return this.subquery;
    }

    @JsonProperty
    public Assignments getSubqueryAssignments() {
        return this.subqueryAssignments;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getCorrelation() {
        return this.correlation;
    }

    @JsonProperty
    public String getOriginSubqueryError() {
        return this.originSubqueryError;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.input, (Object)this.subquery);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.builder().addAll((Iterable)this.input.getOutputVariables()).addAll((Iterable)this.subqueryAssignments.getOutputs()).build();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitApply(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new ApplyNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), newChildren.get(1), this.subqueryAssignments, this.correlation, this.originSubqueryError);
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new ApplyNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.input, this.subquery, this.subqueryAssignments, this.correlation, this.originSubqueryError);
    }
}

