/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.StreamPropertyDerivations;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MergeJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class MergeJoinOptimizer
implements PlanOptimizer {
    private final Metadata metadata;
    private final SqlParser parser;

    public MergeJoinOptimizer(Metadata metadata, SqlParser parser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.parser = Objects.requireNonNull(parser, "parser is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider type, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        if (SystemSessionProperties.isGroupedExecutionEnabled(session) && SystemSessionProperties.preferMergeJoin(session)) {
            return SimplePlanRewriter.rewriteWith(new Rewriter(variableAllocator, idAllocator, this.metadata, session), plan, null);
        }
        return plan;
    }

    private class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final Session session;
        private final TypeProvider types;

        private Rewriter(PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = variableAllocator.getTypes();
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (node.getType() != JoinNode.Type.INNER) {
                return node;
            }
            if (this.isMergeJoinEligible(node.getLeft(), node.getRight(), node)) {
                return new MergeJoinNode(node.getSourceLocation(), node.getId(), node.getType(), node.getLeft(), node.getRight(), node.getCriteria(), node.getOutputVariables(), node.getFilter(), node.getLeftHashVariable(), node.getRightHashVariable());
            }
            return node;
        }

        private boolean isMergeJoinEligible(PlanNode left, PlanNode right, JoinNode node) {
            StreamPropertyDerivations.StreamProperties leftProperties = StreamPropertyDerivations.derivePropertiesRecursively(left, this.metadata, this.session, this.types, MergeJoinOptimizer.this.parser);
            StreamPropertyDerivations.StreamProperties rightProperties = StreamPropertyDerivations.derivePropertiesRecursively(right, this.metadata, this.session, this.types, MergeJoinOptimizer.this.parser);
            List leftJoinColumns = (List)node.getCriteria().stream().map(JoinNode.EquiJoinClause::getLeft).collect(ImmutableList.toImmutableList());
            List rightJoinColumns = (List)node.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).collect(ImmutableList.toImmutableList());
            if (!this.verifyStreamProperties(leftProperties, leftJoinColumns) || !this.verifyStreamProperties(rightProperties, rightJoinColumns)) {
                return false;
            }
            return !LocalProperties.match(rightProperties.getLocalProperties(), LocalProperties.sorted(rightJoinColumns, SortOrder.ASC_NULLS_FIRST)).get(0).isPresent() && !LocalProperties.match(leftProperties.getLocalProperties(), LocalProperties.sorted(leftJoinColumns, SortOrder.ASC_NULLS_FIRST)).get(0).isPresent();
        }

        private boolean verifyStreamProperties(StreamPropertyDerivations.StreamProperties streamProperties, List<VariableReferenceExpression> joinColumns) {
            if (!streamProperties.getPartitioningColumns().isPresent()) {
                return false;
            }
            List<VariableReferenceExpression> partitioningColumns = streamProperties.getPartitioningColumns().get();
            return partitioningColumns.size() <= joinColumns.size() && joinColumns.containsAll(partitioningColumns);
        }
    }
}

