/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.StatsEquivalentPlanNodeWithLimit;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;

public class HistoricalStatisticsEquivalentPlanMarkingOptimizer
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        if (!SystemSessionProperties.useHistoryBasedPlanStatisticsEnabled(session) && !SystemSessionProperties.trackHistoryBasedPlanStatisticsEnabled(session)) {
            return plan;
        }
        plan = SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator), plan, new Context());
        return plan;
    }

    private static class Context {
        private final Deque<LimitNode> limits = new ArrayDeque<LimitNode>();

        private Context() {
        }

        public Deque<LimitNode> getLimits() {
            return this.limits;
        }
    }

    private static class Rewriter
    extends SimplePlanRewriter<Context> {
        private final PlanNodeIdAllocator idAllocator;

        public Rewriter(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            if (!node.getStatsEquivalentPlanNode().isPresent()) {
                PlanNode nodeWithLimit = node;
                if (!context.get().getLimits().isEmpty()) {
                    nodeWithLimit = new StatsEquivalentPlanNodeWithLimit(this.idAllocator.getNextId(), node, context.get().getLimits().peekFirst());
                }
                node = node.assignStatsEquivalentPlanNode(Optional.of(nodeWithLimit));
            }
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().getLimits().addLast(node);
            PlanNode result = this.visitPlan((PlanNode)node, context);
            context.get().getLimits().pop();
            return result;
        }
    }
}

