/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.FunctionType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RowExpressionRewriteRuleSet;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranslateExpressions
extends RowExpressionRewriteRuleSet {
    public TranslateExpressions(Metadata metadata, SqlParser sqlParser) {
        super(TranslateExpressions.createRewriter(metadata, sqlParser));
    }

    private static RowExpressionRewriteRuleSet.PlanRowExpressionRewriter createRewriter(final Metadata metadata, final SqlParser sqlParser) {
        return new RowExpressionRewriteRuleSet.PlanRowExpressionRewriter(){

            @Override
            public RowExpression rewrite(RowExpression expression, Rule.Context context) {
                if (expression instanceof CallExpression && ((CallExpression)expression).getArguments().stream().anyMatch(OriginalExpressionUtils::isExpression)) {
                    return this.removeOriginalExpressionArguments((CallExpression)expression, context.getSession(), context.getVariableAllocator());
                }
                return this.removeOriginalExpression(expression, context);
            }

            private RowExpression removeOriginalExpressionArguments(CallExpression callExpression, Session session, PlanVariableAllocator variableAllocator) {
                Map<NodeRef<Expression>, Type> types = this.analyzeCallExpressionTypes(callExpression, session, variableAllocator.getTypes());
                return new CallExpression(callExpression.getSourceLocation(), callExpression.getDisplayName(), callExpression.getFunctionHandle(), callExpression.getType(), (List)callExpression.getArguments().stream().map(expression -> this.removeOriginalExpression((RowExpression)expression, session, types)).collect(ImmutableList.toImmutableList()));
            }

            private Map<NodeRef<Expression>, Type> analyzeCallExpressionTypes(CallExpression callExpression, Session session, TypeProvider typeProvider) {
                List lambdaExpressions = (List)callExpression.getArguments().stream().filter(OriginalExpressionUtils::isExpression).map(OriginalExpressionUtils::castToExpression).filter(LambdaExpression.class::isInstance).map(LambdaExpression.class::cast).collect(ImmutableList.toImmutableList());
                ImmutableMap.Builder builder = ImmutableMap.builder();
                if (!lambdaExpressions.isEmpty()) {
                    List functionTypes = (List)metadata.getFunctionAndTypeManager().getFunctionMetadata(callExpression.getFunctionHandle()).getArgumentTypes().stream().filter(typeSignature -> typeSignature.getBase().equals("function")).map(typeSignature -> (FunctionType)metadata.getFunctionAndTypeManager().getType((TypeSignature)typeSignature)).collect(ImmutableList.toImmutableList());
                    JavaAggregationFunctionImplementation javaAggregateFunctionImplementation = metadata.getFunctionAndTypeManager().getJavaAggregateFunctionImplementation(callExpression.getFunctionHandle());
                    if (javaAggregateFunctionImplementation instanceof BuiltInAggregationFunctionImplementation) {
                        List<Class> lambdaInterfaces = ((BuiltInAggregationFunctionImplementation)javaAggregateFunctionImplementation).getLambdaInterfaces();
                        Verify.verify((lambdaExpressions.size() == functionTypes.size() ? 1 : 0) != 0);
                        Verify.verify((lambdaExpressions.size() == lambdaInterfaces.size() ? 1 : 0) != 0);
                    }
                    for (int i = 0; i < lambdaExpressions.size(); ++i) {
                        LambdaExpression lambdaExpression = (LambdaExpression)lambdaExpressions.get(i);
                        FunctionType functionType = (FunctionType)functionTypes.get(i);
                        Verify.verify((lambdaExpression.getArguments().size() == functionType.getArgumentTypes().size() ? 1 : 0) != 0);
                        HashMap<NodeRef, Type> lambdaArgumentExpressionTypes = new HashMap<NodeRef, Type>();
                        HashMap<String, Type> lambdaArgumentSymbolTypes = new HashMap<String, Type>();
                        for (int j = 0; j < lambdaExpression.getArguments().size(); ++j) {
                            LambdaArgumentDeclaration argument = (LambdaArgumentDeclaration)lambdaExpression.getArguments().get(j);
                            Type type = (Type)functionType.getArgumentTypes().get(j);
                            lambdaArgumentExpressionTypes.put(NodeRef.of((Node)argument), type);
                            lambdaArgumentSymbolTypes.put(argument.getName().getValue(), type);
                        }
                        builder.put((Object)NodeRef.of((Node)lambdaExpression), (Object)functionType).putAll(lambdaArgumentExpressionTypes).putAll(ExpressionAnalyzer.getExpressionTypes(session, metadata, sqlParser, TypeProvider.copyOf(lambdaArgumentSymbolTypes), lambdaExpression.getBody(), Collections.emptyMap(), WarningCollector.NOOP));
                    }
                }
                for (RowExpression argument : callExpression.getArguments()) {
                    if (!OriginalExpressionUtils.isExpression(argument) || OriginalExpressionUtils.castToExpression(argument) instanceof LambdaExpression) continue;
                    builder.putAll(this.analyze(OriginalExpressionUtils.castToExpression(argument), session, typeProvider));
                }
                return builder.build();
            }

            private Map<NodeRef<Expression>, Type> analyze(Expression expression, Session session, TypeProvider typeProvider) {
                return ExpressionAnalyzer.getExpressionTypes(session, metadata, sqlParser, typeProvider, expression, Collections.emptyMap(), WarningCollector.NOOP);
            }

            private RowExpression toRowExpression(Expression expression, Session session, Map<NodeRef<Expression>, Type> types) {
                return SqlToRowExpressionTranslator.translate(expression, types, (Map<VariableReferenceExpression, Integer>)ImmutableMap.of(), metadata.getFunctionAndTypeManager(), session);
            }

            private RowExpression removeOriginalExpression(RowExpression expression, Rule.Context context) {
                if (OriginalExpressionUtils.isExpression(expression)) {
                    return this.toRowExpression(OriginalExpressionUtils.castToExpression(expression), context.getSession(), this.analyze(OriginalExpressionUtils.castToExpression(expression), context.getSession(), context.getVariableAllocator().getTypes()));
                }
                return expression;
            }

            private RowExpression removeOriginalExpression(RowExpression rowExpression, Session session, Map<NodeRef<Expression>, Type> types) {
                if (OriginalExpressionUtils.isExpression(rowExpression)) {
                    Expression expression = OriginalExpressionUtils.castToExpression(rowExpression);
                    return this.toRowExpression(expression, session, types);
                }
                return rowExpression;
            }
        };
    }
}

