/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class PushLimitThroughUnion
implements Rule<LimitNode> {
    private static final Capture<UnionNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.union().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        UnionNode unionNode = (UnionNode)captures.get(CHILD);
        if (unionNode.getSources().stream().allMatch(source -> QueryCardinalityUtil.isAtMost(source, context.getLookup(), parent.getCount()))) {
            return Rule.Result.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PlanNode source2 : unionNode.getSources()) {
            if (QueryCardinalityUtil.isAtMost(source2, context.getLookup(), parent.getCount())) {
                builder.add((Object)source2);
                continue;
            }
            builder.add((Object)new LimitNode(parent.getSourceLocation(), context.getIdAllocator().getNextId(), source2, parent.getCount(), LimitNode.Step.PARTIAL));
        }
        return Rule.Result.ofPlanNode(parent.replaceChildren((List)ImmutableList.of((Object)unionNode.replaceChildren((List)builder.build()))));
    }
}

