/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.Expressions;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public class EliminateEmptyJoins
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();

    public static Assignments buildAssignments(Collection<VariableReferenceExpression> variables, PlanNode nonEmptyChild) {
        Assignments.Builder builder = Assignments.builder();
        for (VariableReferenceExpression variable : variables) {
            if (nonEmptyChild.getOutputVariables().contains(variable)) {
                builder.put(variable, (RowExpression)variable);
                continue;
            }
            builder.put(variable, (RowExpression)Expressions.constantNull(variable.getSourceLocation(), variable.getType()));
        }
        return builder.build();
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        if (!SystemSessionProperties.isEmptyJoinOptimization(context.getSession())) {
            return Rule.Result.empty();
        }
        boolean leftChildEmpty = QueryCardinalityUtil.isAtMost(context.getLookup().resolve(joinNode.getLeft()), context.getLookup(), 0L);
        boolean rightChildEmpty = QueryCardinalityUtil.isAtMost(context.getLookup().resolve(joinNode.getRight()), context.getLookup(), 0L);
        if (leftChildEmpty && rightChildEmpty || (leftChildEmpty || rightChildEmpty) && joinNode.getType() == JoinNode.Type.INNER || leftChildEmpty && joinNode.getType() == JoinNode.Type.LEFT || rightChildEmpty && joinNode.getType() == JoinNode.Type.RIGHT) {
            return Rule.Result.ofPlanNode((PlanNode)new ValuesNode(joinNode.getSourceLocation(), joinNode.getId(), joinNode.getOutputVariables(), Collections.emptyList(), Optional.empty()));
        }
        if (leftChildEmpty || rightChildEmpty) {
            PlanNode nonEmptyChild = leftChildEmpty ? joinNode.getRight() : joinNode.getLeft();
            Assignments.Builder newProjections = Assignments.builder().putAll(EliminateEmptyJoins.buildAssignments(joinNode.getOutputVariables(), nonEmptyChild));
            return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(joinNode.getSourceLocation(), joinNode.getId(), nonEmptyChild, newProjections.build(), ProjectNode.Locality.LOCAL));
        }
        return Rule.Result.empty();
    }
}

