/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CostCalculatorWithEstimatedExchanges;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.LocalCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.DetermineJoinDistributionType;
import com.facebook.presto.sql.planner.iterative.rule.PlanNodeWithCost;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.google.common.collect.Ordering;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Objects;

public class DetermineSemiJoinDistributionType
implements Rule<SemiJoinNode> {
    private final TaskCountEstimator taskCountEstimator;
    private final CostComparator costComparator;
    private static final Pattern<SemiJoinNode> PATTERN = Patterns.semiJoin().matching(semiJoin -> !semiJoin.getDistributionType().isPresent());

    public DetermineSemiJoinDistributionType(CostComparator costComparator, TaskCountEstimator taskCountEstimator) {
        this.costComparator = Objects.requireNonNull(costComparator, "costComparator is null");
        this.taskCountEstimator = Objects.requireNonNull(taskCountEstimator, "taskCountEstimator is null");
    }

    @Override
    public Pattern<SemiJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SemiJoinNode semiJoinNode, Captures captures, Rule.Context context) {
        FeaturesConfig.JoinDistributionType joinDistributionType = SystemSessionProperties.getJoinDistributionType(context.getSession());
        switch (joinDistributionType) {
            case AUTOMATIC: {
                return Rule.Result.ofPlanNode(this.getCostBasedDistributionType(semiJoinNode, context));
            }
            case PARTITIONED: {
                return Rule.Result.ofPlanNode(semiJoinNode.withDistributionType(SemiJoinNode.DistributionType.PARTITIONED));
            }
            case BROADCAST: {
                return Rule.Result.ofPlanNode(semiJoinNode.withDistributionType(SemiJoinNode.DistributionType.REPLICATED));
            }
        }
        throw new IllegalArgumentException("Unknown join_distribution_type: " + (Object)((Object)joinDistributionType));
    }

    private PlanNode getCostBasedDistributionType(SemiJoinNode node, Rule.Context context) {
        if (!this.canReplicate(node, context)) {
            return node.withDistributionType(SemiJoinNode.DistributionType.PARTITIONED);
        }
        ArrayList<PlanNodeWithCost> possibleJoinNodes = new ArrayList<PlanNodeWithCost>();
        possibleJoinNodes.add(this.getSemiJoinNodeWithCost(node.withDistributionType(SemiJoinNode.DistributionType.REPLICATED), context));
        possibleJoinNodes.add(this.getSemiJoinNodeWithCost(node.withDistributionType(SemiJoinNode.DistributionType.PARTITIONED), context));
        if (possibleJoinNodes.stream().anyMatch(result -> result.getCost().hasUnknownComponents())) {
            if (SystemSessionProperties.isSizeBasedJoinDistributionTypeEnabled(context.getSession())) {
                return this.getSizeBaseDistributionType(node, context);
            }
            return node.withDistributionType(SemiJoinNode.DistributionType.PARTITIONED);
        }
        Ordering planNodeOrderings = this.costComparator.forSession(context.getSession()).onResultOf(PlanNodeWithCost::getCost);
        return ((PlanNodeWithCost)planNodeOrderings.min(possibleJoinNodes)).getPlanNode();
    }

    private PlanNode getSizeBaseDistributionType(SemiJoinNode node, Rule.Context context) {
        DataSize joinMaxBroadcastTableSize = SystemSessionProperties.getJoinMaxBroadcastTableSize(context.getSession());
        if (DetermineJoinDistributionType.getSourceTablesSizeInBytes(node.getFilteringSource(), context) <= (double)joinMaxBroadcastTableSize.toBytes()) {
            return node.withDistributionType(SemiJoinNode.DistributionType.REPLICATED);
        }
        return node.withDistributionType(SemiJoinNode.DistributionType.PARTITIONED);
    }

    private boolean canReplicate(SemiJoinNode node, Rule.Context context) {
        DataSize joinMaxBroadcastTableSize = SystemSessionProperties.getJoinMaxBroadcastTableSize(context.getSession());
        PlanNode buildSide = node.getFilteringSource();
        PlanNodeStatsEstimate buildSideStatsEstimate = context.getStatsProvider().getStats(buildSide);
        double buildSideSizeInBytes = buildSideStatsEstimate.getOutputSizeInBytes(buildSide.getOutputVariables());
        return buildSideSizeInBytes <= (double)joinMaxBroadcastTableSize.toBytes() || SystemSessionProperties.isSizeBasedJoinDistributionTypeEnabled(context.getSession()) && DetermineJoinDistributionType.getSourceTablesSizeInBytes(buildSide, context) <= (double)joinMaxBroadcastTableSize.toBytes();
    }

    private PlanNodeWithCost getSemiJoinNodeWithCost(SemiJoinNode possibleJoinNode, Rule.Context context) {
        StatsProvider stats = context.getStatsProvider();
        boolean replicated = possibleJoinNode.getDistributionType().get().equals((Object)SemiJoinNode.DistributionType.REPLICATED);
        int estimatedSourceDistributedTaskCount = this.taskCountEstimator.estimateSourceDistributedTaskCount();
        LocalCostEstimate cost = CostCalculatorWithEstimatedExchanges.calculateJoinCostWithoutOutput(possibleJoinNode.getSource(), possibleJoinNode.getFilteringSource(), stats, replicated, estimatedSourceDistributedTaskCount);
        return new PlanNodeWithCost(cost.toPlanCost(), possibleJoinNode);
    }
}

