/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.constraints.UniqueConstraint;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesImpl;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class LogicalPropertiesProviderImpl
implements LogicalPropertiesProvider {
    private final FunctionResolution functionResolution;

    public LogicalPropertiesProviderImpl(FunctionResolution functionResolution) {
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
    }

    public LogicalProperties getValuesProperties(ValuesNode valuesNode) {
        LogicalPropertiesImpl sourceProperties = LogicalPropertiesImpl.emptyProperties(this.functionResolution);
        return LogicalPropertiesImpl.propagateAndLimitProperties(sourceProperties, valuesNode.getRows().size(), this.functionResolution);
    }

    public LogicalProperties getTableScanProperties(TableScanNode tableScanNode) {
        ArrayList<Set<VariableReferenceExpression>> keys = new ArrayList<Set<VariableReferenceExpression>>();
        List uniqueConstraints = tableScanNode.getTableConstraints().stream().filter(tableConstraint -> tableConstraint instanceof UniqueConstraint && (tableConstraint.isEnforced() || tableConstraint.isRely())).collect(Collectors.toList());
        if (!uniqueConstraints.isEmpty()) {
            Map assignments = tableScanNode.getAssignments();
            Map<ColumnHandle, VariableReferenceExpression> inverseAssignments = assignments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            uniqueConstraints.stream().filter(uniqueConstraint -> uniqueConstraint.getColumns().stream().allMatch(col -> inverseAssignments.containsKey(col))).forEach(uniqueConstraint -> keys.add(uniqueConstraint.getColumns().stream().map(col -> (VariableReferenceExpression)inverseAssignments.get(col)).collect(Collectors.toSet())));
        }
        return LogicalPropertiesImpl.tableScanProperties(keys, this.functionResolution);
    }

    public LogicalProperties getFilterProperties(FilterNode filterNode) {
        if (!(filterNode.getSource() instanceof GroupReference) || !((GroupReference)filterNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProperties = (LogicalPropertiesImpl)((GroupReference)filterNode.getSource()).getLogicalProperties().get();
        return LogicalPropertiesImpl.filterProperties(sourceProperties, filterNode.getPredicate(), this.functionResolution);
    }

    public LogicalProperties getProjectProperties(ProjectNode projectNode) {
        if (!(projectNode.getSource() instanceof GroupReference) || !((GroupReference)projectNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProperties = (LogicalPropertiesImpl)((GroupReference)projectNode.getSource()).getLogicalProperties().get();
        return LogicalPropertiesImpl.projectProperties(sourceProperties, projectNode.getAssignments(), this.functionResolution);
    }

    public LogicalProperties getJoinProperties(PlanNode node) {
        if (!(node instanceof JoinNode)) {
            throw new IllegalArgumentException("Expected PlanNode to be instance of JoinNode");
        }
        JoinNode joinNode = (JoinNode)node;
        if (!(joinNode.getLeft() instanceof GroupReference) || !((GroupReference)joinNode.getLeft()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected left source PlanNode to be a GroupReference with LogicalProperties");
        }
        if (!(joinNode.getRight() instanceof GroupReference) || !((GroupReference)joinNode.getRight()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected right source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl leftProps = (LogicalPropertiesImpl)((GroupReference)joinNode.getLeft()).getLogicalProperties().get();
        LogicalPropertiesImpl rightProps = (LogicalPropertiesImpl)((GroupReference)joinNode.getRight()).getLogicalProperties().get();
        return LogicalPropertiesImpl.joinProperties(leftProps, rightProps, joinNode.getCriteria(), joinNode.getType(), joinNode.getFilter(), joinNode.getOutputVariables(), this.functionResolution);
    }

    public LogicalProperties getSemiJoinProperties(PlanNode node) {
        if (!(node instanceof SemiJoinNode)) {
            throw new IllegalArgumentException("Expected PlanNode to be instance of SemiJoinNode");
        }
        SemiJoinNode semiJoinNode = (SemiJoinNode)node;
        if (!(semiJoinNode.getSource() instanceof GroupReference) || !((GroupReference)semiJoinNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected non-filtering source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProperties = (LogicalPropertiesImpl)((GroupReference)semiJoinNode.getSource()).getLogicalProperties().get();
        return LogicalPropertiesImpl.propagateProperties(sourceProperties, this.functionResolution);
    }

    public LogicalProperties getAggregationProperties(AggregationNode aggregationNode) {
        if (!(aggregationNode.getSource() instanceof GroupReference) || !((GroupReference)aggregationNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        if (aggregationNode.getGroupingKeys().isEmpty() && aggregationNode.getAggregations().isEmpty()) {
            throw new IllegalStateException("Aggregation node with no grouping columns and no aggregation functions");
        }
        LogicalPropertiesImpl sourceProperties = (LogicalPropertiesImpl)((GroupReference)aggregationNode.getSource()).getLogicalProperties().get();
        if (!aggregationNode.getAggregations().isEmpty() && aggregationNode.getGroupingKeys().isEmpty()) {
            return LogicalPropertiesImpl.propagateAndLimitProperties(sourceProperties, 1L, this.functionResolution);
        }
        return LogicalPropertiesImpl.aggregationProperties(sourceProperties, aggregationNode.getGroupingKeys().stream().collect(Collectors.toSet()), aggregationNode.getOutputVariables(), this.functionResolution);
    }

    public LogicalProperties getAssignUniqueIdProperties(PlanNode node) {
        if (!(node instanceof AssignUniqueId)) {
            throw new IllegalArgumentException("Expected PlanNode to be instance of AssignUniqueId");
        }
        AssignUniqueId assignUniqueIdNode = (AssignUniqueId)node;
        if (!(assignUniqueIdNode.getSource() instanceof GroupReference) || !((GroupReference)assignUniqueIdNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        if (assignUniqueIdNode.getIdVariable() == null) {
            throw new IllegalStateException("AssignUniqueId should have an id variable");
        }
        LogicalPropertiesImpl sourceProperties = (LogicalPropertiesImpl)((GroupReference)assignUniqueIdNode.getSource()).getLogicalProperties().get();
        HashSet<VariableReferenceExpression> key = new HashSet<VariableReferenceExpression>();
        key.add(assignUniqueIdNode.getIdVariable());
        return LogicalPropertiesImpl.aggregationProperties(sourceProperties, key, assignUniqueIdNode.getOutputVariables(), this.functionResolution);
    }

    public LogicalProperties getDistinctLimitProperties(DistinctLimitNode distinctLimitNode) {
        if (!(distinctLimitNode.getSource() instanceof GroupReference) || !((GroupReference)distinctLimitNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProperties = (LogicalPropertiesImpl)((GroupReference)distinctLimitNode.getSource()).getLogicalProperties().get();
        return LogicalPropertiesImpl.distinctLimitProperties(sourceProperties, distinctLimitNode.getDistinctVariables().stream().collect(Collectors.toSet()), distinctLimitNode.getLimit(), distinctLimitNode.getOutputVariables(), this.functionResolution);
    }

    public LogicalProperties getLimitProperties(LimitNode limitNode) {
        if (!(limitNode.getSource() instanceof GroupReference) || !((GroupReference)limitNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProperties = (LogicalPropertiesImpl)((GroupReference)limitNode.getSource()).getLogicalProperties().get();
        return LogicalPropertiesImpl.propagateAndLimitProperties(sourceProperties, limitNode.getCount(), this.functionResolution);
    }

    public LogicalProperties getTopNProperties(TopNNode topNNode) {
        if (!(topNNode.getSource() instanceof GroupReference) || !((GroupReference)topNNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected left source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProperties = (LogicalPropertiesImpl)((GroupReference)topNNode.getSource()).getLogicalProperties().get();
        return LogicalPropertiesImpl.propagateAndLimitProperties(sourceProperties, topNNode.getCount(), this.functionResolution);
    }

    public LogicalProperties getSortProperties(PlanNode node) {
        if (!(node instanceof SortNode)) {
            throw new IllegalArgumentException("Expected PlanNode to be instance of SortNode");
        }
        SortNode sortNode = (SortNode)node;
        if (!(sortNode.getSource() instanceof GroupReference) || !((GroupReference)sortNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProperties = (LogicalPropertiesImpl)((GroupReference)sortNode.getSource()).getLogicalProperties().get();
        return LogicalPropertiesImpl.propagateProperties(sourceProperties, this.functionResolution);
    }

    public LogicalProperties getDefaultProperties() {
        return LogicalPropertiesImpl.emptyProperties(this.functionResolution);
    }
}

