/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.properties.EquivalenceClassProperty;
import com.facebook.presto.sql.planner.iterative.properties.Key;
import com.facebook.presto.sql.planner.iterative.properties.KeyProperty;
import com.facebook.presto.sql.planner.iterative.properties.MaxCardProperty;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class LogicalPropertiesImpl
implements LogicalProperties {
    private final MaxCardProperty maxCardProperty;
    private final KeyProperty keyProperty;
    private final EquivalenceClassProperty equivalenceClassProperty;

    public LogicalPropertiesImpl(EquivalenceClassProperty equivalenceClassProperty, MaxCardProperty maxCardProperty, KeyProperty keyProperty) {
        this.equivalenceClassProperty = Objects.requireNonNull(equivalenceClassProperty, "equivalenceClassProperty is null");
        this.maxCardProperty = Objects.requireNonNull(maxCardProperty, "maxCardProperty is null");
        this.keyProperty = Objects.requireNonNull(keyProperty, "keyProperty is null");
    }

    private boolean isMoreGeneralThan(LogicalPropertiesImpl otherLogicalProperties) {
        Objects.requireNonNull(otherLogicalProperties, "otherLogicalProperties is null");
        return this.maxCardProperty.moreGeneral(otherLogicalProperties.maxCardProperty) && this.keyProperty.moreGeneral(otherLogicalProperties.keyProperty) && this.equivalenceClassProperty.isMoreGeneralThan(otherLogicalProperties.equivalenceClassProperty);
    }

    public boolean equals(LogicalPropertiesImpl otherLogicalProperties) {
        Objects.requireNonNull(otherLogicalProperties, "otherLogicalProperties is null");
        return this.isMoreGeneralThan(otherLogicalProperties) && otherLogicalProperties.isMoreGeneralThan(this);
    }

    private static Map<VariableReferenceExpression, VariableReferenceExpression> inverseVariableAssignments(Assignments assignments) {
        Objects.requireNonNull(assignments, "assignments is null");
        HashMap<VariableReferenceExpression, VariableReferenceExpression> inverseVariableAssignments = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
        for (Map.Entry e : assignments.entrySet()) {
            if (!(e.getValue() instanceof VariableReferenceExpression)) continue;
            inverseVariableAssignments.put((VariableReferenceExpression)e.getValue(), (VariableReferenceExpression)e.getKey());
        }
        return inverseVariableAssignments;
    }

    private static void normalizeKeyPropertyAndSetMaxCard(KeyProperty keyProperty, MaxCardProperty maxCardProperty, EquivalenceClassProperty equivalenceClassProperty) {
        if (maxCardProperty.isAtMostOne()) {
            keyProperty.empty();
            return;
        }
        Optional<KeyProperty> normalizedKeyProperty = keyProperty.normalize(equivalenceClassProperty);
        keyProperty.empty();
        if (normalizedKeyProperty.isPresent()) {
            keyProperty.addKeys(normalizedKeyProperty.get());
        } else {
            maxCardProperty.update(1L);
        }
    }

    public boolean isDistinct(Set<VariableReferenceExpression> keyVars) {
        Objects.requireNonNull(keyVars, "keyVars is null");
        Preconditions.checkArgument((!keyVars.isEmpty() ? 1 : 0) != 0, (Object)"keyVars is empty");
        return this.keyRequirementSatisfied(new Key(keyVars));
    }

    public boolean isAtMostSingleRow() {
        return this.isAtMost(1L);
    }

    public boolean isAtMost(long n) {
        return this.maxCardProperty.isAtMost(n);
    }

    private boolean keyRequirementSatisfied(Key keyRequirement) {
        Objects.requireNonNull(keyRequirement, "keyRequirement is null");
        if (this.maxCardProperty.isAtMostOne()) {
            return true;
        }
        Optional<Key> normalizedKeyRequirement = keyRequirement.normalize(this.equivalenceClassProperty);
        if (normalizedKeyRequirement.isPresent()) {
            return this.keyProperty.satisfiesKeyRequirement(keyRequirement);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("KeyProperty", (Object)this.keyProperty).add("EquivalenceClassProperty", (Object)this.equivalenceClassProperty).add("MaxCardProperty", (Object)this.maxCardProperty).toString();
    }

    public static LogicalPropertiesImpl emptyProperties(FunctionResolution functionResolution) {
        return new LogicalPropertiesImpl(new EquivalenceClassProperty(functionResolution), new MaxCardProperty(), new KeyProperty());
    }

    public static LogicalPropertiesImpl propagateProperties(LogicalPropertiesImpl sourceProperties, FunctionResolution functionResolution) {
        KeyProperty keyProperty = new KeyProperty();
        MaxCardProperty maxCardProperty = new MaxCardProperty();
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        keyProperty.addKeys(sourceProperties.keyProperty);
        maxCardProperty.update(sourceProperties.maxCardProperty);
        equivalenceClassProperty.update(sourceProperties.equivalenceClassProperty);
        return new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, keyProperty);
    }

    public static LogicalPropertiesImpl tableScanProperties(List<Set<VariableReferenceExpression>> keys, FunctionResolution functionResolution) {
        KeyProperty keyProperty = new KeyProperty();
        keyProperty.addKeys(keys.stream().map(Key::new).collect(Collectors.toSet()));
        return new LogicalPropertiesImpl(new EquivalenceClassProperty(functionResolution), new MaxCardProperty(), keyProperty);
    }

    public static LogicalPropertiesImpl filterProperties(LogicalPropertiesImpl sourceProperties, RowExpression predicate, FunctionResolution functionResolution) {
        MaxCardProperty maxCardProperty = new MaxCardProperty();
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        KeyProperty keyProperty = new KeyProperty();
        keyProperty.addKeys(sourceProperties.keyProperty);
        maxCardProperty.update(sourceProperties.maxCardProperty);
        equivalenceClassProperty.update(sourceProperties.equivalenceClassProperty);
        if (equivalenceClassProperty.update(predicate)) {
            LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(keyProperty, maxCardProperty, equivalenceClassProperty);
        }
        return new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, keyProperty);
    }

    public static LogicalPropertiesImpl projectProperties(LogicalPropertiesImpl sourceProperties, Assignments assignments, FunctionResolution functionResolution) {
        MaxCardProperty maxCardProperty = new MaxCardProperty();
        KeyProperty keyProperty = new KeyProperty();
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        keyProperty.addKeys(sourceProperties.keyProperty);
        maxCardProperty.update(sourceProperties.maxCardProperty);
        equivalenceClassProperty.update(sourceProperties.equivalenceClassProperty);
        Map<VariableReferenceExpression, VariableReferenceExpression> inverseVariableAssignments = LogicalPropertiesImpl.inverseVariableAssignments(assignments);
        keyProperty = keyProperty.project(new InverseVariableMappingsWithEquivalence(equivalenceClassProperty, inverseVariableAssignments));
        equivalenceClassProperty = equivalenceClassProperty.project(inverseVariableAssignments);
        LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(keyProperty, maxCardProperty, equivalenceClassProperty);
        return new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, keyProperty);
    }

    public static LogicalPropertiesImpl propagateAndLimitProperties(LogicalPropertiesImpl sourceProperties, long limit, FunctionResolution functionResolution) {
        MaxCardProperty maxCardProperty = new MaxCardProperty();
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        KeyProperty keyProperty = new KeyProperty();
        keyProperty.addKeys(sourceProperties.keyProperty);
        maxCardProperty.update(sourceProperties.maxCardProperty);
        maxCardProperty.update(limit);
        equivalenceClassProperty.update(sourceProperties.equivalenceClassProperty);
        if (maxCardProperty.isAtMostOne()) {
            keyProperty.empty();
        }
        return new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, keyProperty);
    }

    public static LogicalPropertiesImpl aggregationProperties(LogicalPropertiesImpl sourceProperties, Set<VariableReferenceExpression> keyVariables, List<VariableReferenceExpression> outputVariables, FunctionResolution functionResolution) {
        Preconditions.checkArgument((!keyVariables.isEmpty() ? 1 : 0) != 0, (Object)"keyVariables is empty");
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        KeyProperty keyProperty = new KeyProperty();
        MaxCardProperty maxCardProperty = new MaxCardProperty();
        keyProperty.addKeys(sourceProperties.keyProperty);
        maxCardProperty.update(sourceProperties.maxCardProperty);
        equivalenceClassProperty.update(sourceProperties.equivalenceClassProperty);
        if (!maxCardProperty.isAtMostOne()) {
            keyProperty.addKey(new Key(keyVariables));
            LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(keyProperty, maxCardProperty, equivalenceClassProperty);
        }
        return LogicalPropertiesImpl.projectProperties(new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, keyProperty), AssignmentUtils.identityAssignments(outputVariables), functionResolution);
    }

    public static LogicalPropertiesImpl distinctLimitProperties(LogicalPropertiesImpl sourceProperties, Set<VariableReferenceExpression> keyVariables, Long limit, List<VariableReferenceExpression> outputVariables, FunctionResolution functionResolution) {
        Preconditions.checkArgument((!keyVariables.isEmpty() ? 1 : 0) != 0, (Object)"keyVariables is empty");
        LogicalPropertiesImpl aggregationProperties = LogicalPropertiesImpl.aggregationProperties(sourceProperties, keyVariables, outputVariables, functionResolution);
        return LogicalPropertiesImpl.propagateAndLimitProperties(aggregationProperties, limit, functionResolution);
    }

    public static LogicalPropertiesImpl joinProperties(LogicalPropertiesImpl leftProperties, LogicalPropertiesImpl rightProperties, List<JoinNode.EquiJoinClause> equijoinPredicates, JoinNode.Type joinType, Optional<RowExpression> filterPredicate, List<VariableReferenceExpression> outputVariables, FunctionResolution functionResolution) {
        MaxCardProperty maxCardProperty = new MaxCardProperty();
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(functionResolution);
        KeyProperty keyProperty = new KeyProperty();
        boolean nToOne = false;
        boolean oneToN = false;
        Set<VariableReferenceExpression> rightJoinVariables = equijoinPredicates.stream().map(JoinNode.EquiJoinClause::getRight).collect(Collectors.toSet());
        Set<VariableReferenceExpression> leftJoinVariables = equijoinPredicates.stream().map(JoinNode.EquiJoinClause::getLeft).collect(Collectors.toSet());
        if ((rightProperties.maxCardProperty.isAtMostOne() || !rightJoinVariables.isEmpty() && rightProperties.isDistinct(rightJoinVariables)) && (joinType == JoinNode.Type.INNER || joinType == JoinNode.Type.LEFT || joinType == JoinNode.Type.FULL && leftProperties.maxCardProperty.isAtMost(1L))) {
            nToOne = true;
            keyProperty.addKeys(leftProperties.keyProperty);
            maxCardProperty.update(leftProperties.maxCardProperty);
        }
        if ((leftProperties.maxCardProperty.isAtMostOne() || !leftJoinVariables.isEmpty() && leftProperties.isDistinct(leftJoinVariables)) && (joinType == JoinNode.Type.INNER || joinType == JoinNode.Type.RIGHT || joinType == JoinNode.Type.FULL && rightProperties.maxCardProperty.isAtMost(1L))) {
            oneToN = true;
            keyProperty.addKeys(rightProperties.keyProperty);
            maxCardProperty.update(rightProperties.maxCardProperty);
        }
        if (!nToOne && !oneToN) {
            maxCardProperty.update(leftProperties.maxCardProperty);
            maxCardProperty.multiply(rightProperties.maxCardProperty);
            if (joinType == JoinNode.Type.INNER) {
                keyProperty.addKeys(leftProperties.keyProperty);
                keyProperty = keyProperty.concat(rightProperties.keyProperty);
            }
        }
        if (joinType == JoinNode.Type.INNER || joinType == JoinNode.Type.LEFT) {
            equivalenceClassProperty.update(leftProperties.equivalenceClassProperty);
        }
        if (joinType == JoinNode.Type.INNER || joinType == JoinNode.Type.RIGHT) {
            equivalenceClassProperty.update(rightProperties.equivalenceClassProperty);
        }
        if (joinType == JoinNode.Type.INNER) {
            equijoinPredicates.forEach(joinVariables -> equivalenceClassProperty.update((RowExpression)joinVariables.getLeft(), (RowExpression)joinVariables.getRight()));
            filterPredicate.ifPresent(equivalenceClassProperty::update);
        }
        LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(keyProperty, maxCardProperty, equivalenceClassProperty);
        return LogicalPropertiesImpl.projectProperties(new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, keyProperty), AssignmentUtils.identityAssignments(outputVariables), functionResolution);
    }

    public static class InverseVariableMappingsWithEquivalence {
        private final EquivalenceClassProperty equivalenceClassProperty;
        private final Map<VariableReferenceExpression, VariableReferenceExpression> inverseMappings;

        InverseVariableMappingsWithEquivalence(EquivalenceClassProperty equivalenceClassProperty, Map<VariableReferenceExpression, VariableReferenceExpression> inverseMappings) {
            Objects.requireNonNull(equivalenceClassProperty, "equivalenceClassProperty is null");
            Objects.requireNonNull(inverseMappings, "inverseMappings is null");
            this.equivalenceClassProperty = equivalenceClassProperty;
            this.inverseMappings = inverseMappings;
        }

        private boolean containsKey(VariableReferenceExpression variable) {
            if (!this.inverseMappings.containsKey(variable)) {
                RowExpression head = this.equivalenceClassProperty.getEquivalenceClassHead((RowExpression)variable);
                ArrayList<RowExpression> equivalentVariables = new ArrayList<RowExpression>();
                equivalentVariables.add(head);
                equivalentVariables.addAll(this.equivalenceClassProperty.getEquivalenceClasses(head));
                for (RowExpression e : equivalentVariables) {
                    if (!(e instanceof VariableReferenceExpression) || !this.inverseMappings.containsKey(e)) continue;
                    this.inverseMappings.put(variable, this.inverseMappings.get(e));
                    break;
                }
            }
            return this.inverseMappings.containsKey(variable);
        }

        public Optional<VariableReferenceExpression> get(VariableReferenceExpression variable) {
            Objects.requireNonNull(variable, "variable is null");
            if (this.containsKey(variable)) {
                return Optional.of(this.inverseMappings.get(variable));
            }
            return Optional.empty();
        }
    }
}

